/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.TwoByteChunk;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class GridAxisDescriptorVariable
implements Serializable {
    protected double domainInitialXi;
    protected double domainFinalXi;
    protected int domainPointsXi;
    protected short interleafFactor;
    protected short axisType;
    protected int numberOfPointsOnXiAxis;
    protected int initialIndex;
    protected double coordinateScaleXi;
    protected double coordinateOffsetXi = 0.0;
    protected List<TwoByteChunk> xiValues = new ArrayList<TwoByteChunk>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 8;
        marshalSize += 8;
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 8;
        marshalSize += 8;
        for (int idx = 0; idx < this.xiValues.size(); ++idx) {
            TwoByteChunk listElement = this.xiValues.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setDomainInitialXi(double pDomainInitialXi) {
        this.domainInitialXi = pDomainInitialXi;
    }

    public double getDomainInitialXi() {
        return this.domainInitialXi;
    }

    public void setDomainFinalXi(double pDomainFinalXi) {
        this.domainFinalXi = pDomainFinalXi;
    }

    public double getDomainFinalXi() {
        return this.domainFinalXi;
    }

    public void setDomainPointsXi(int pDomainPointsXi) {
        this.domainPointsXi = pDomainPointsXi;
    }

    public int getDomainPointsXi() {
        return this.domainPointsXi;
    }

    public void setInterleafFactor(short pInterleafFactor) {
        this.interleafFactor = pInterleafFactor;
    }

    public short getInterleafFactor() {
        return this.interleafFactor;
    }

    public void setAxisType(short pAxisType) {
        this.axisType = pAxisType;
    }

    public short getAxisType() {
        return this.axisType;
    }

    public int getNumberOfPointsOnXiAxis() {
        return this.xiValues.size();
    }

    public void setNumberOfPointsOnXiAxis(int pNumberOfPointsOnXiAxis) {
        this.numberOfPointsOnXiAxis = pNumberOfPointsOnXiAxis;
    }

    public void setInitialIndex(int pInitialIndex) {
        this.initialIndex = pInitialIndex;
    }

    public int getInitialIndex() {
        return this.initialIndex;
    }

    public void setCoordinateScaleXi(double pCoordinateScaleXi) {
        this.coordinateScaleXi = pCoordinateScaleXi;
    }

    public double getCoordinateScaleXi() {
        return this.coordinateScaleXi;
    }

    public void setCoordinateOffsetXi(double pCoordinateOffsetXi) {
        this.coordinateOffsetXi = pCoordinateOffsetXi;
    }

    public double getCoordinateOffsetXi() {
        return this.coordinateOffsetXi;
    }

    public void setXiValues(List<TwoByteChunk> pXiValues) {
        this.xiValues = pXiValues;
    }

    public List<TwoByteChunk> getXiValues() {
        return this.xiValues;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeDouble(this.domainInitialXi);
            dos.writeDouble(this.domainFinalXi);
            dos.writeShort((short)this.domainPointsXi);
            dos.writeByte((byte)this.interleafFactor);
            dos.writeByte((byte)this.axisType);
            dos.writeShort((short)this.xiValues.size());
            dos.writeShort((short)this.initialIndex);
            dos.writeDouble(this.coordinateScaleXi);
            dos.writeDouble(this.coordinateOffsetXi);
            for (int idx = 0; idx < this.xiValues.size(); ++idx) {
                TwoByteChunk aTwoByteChunk = this.xiValues.get(idx);
                aTwoByteChunk.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.domainInitialXi = dis.readDouble();
            this.domainFinalXi = dis.readDouble();
            this.domainPointsXi = dis.readUnsignedShort();
            this.interleafFactor = (short)dis.readUnsignedByte();
            this.axisType = (short)dis.readUnsignedByte();
            this.numberOfPointsOnXiAxis = dis.readUnsignedShort();
            this.initialIndex = dis.readUnsignedShort();
            this.coordinateScaleXi = dis.readDouble();
            this.coordinateOffsetXi = dis.readDouble();
            for (int idx = 0; idx < this.numberOfPointsOnXiAxis; ++idx) {
                TwoByteChunk anX = new TwoByteChunk();
                anX.unmarshal(dis);
                this.xiValues.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putDouble(this.domainInitialXi);
        buff.putDouble(this.domainFinalXi);
        buff.putShort((short)this.domainPointsXi);
        buff.put((byte)this.interleafFactor);
        buff.put((byte)this.axisType);
        buff.putShort((short)this.xiValues.size());
        buff.putShort((short)this.initialIndex);
        buff.putDouble(this.coordinateScaleXi);
        buff.putDouble(this.coordinateOffsetXi);
        for (int idx = 0; idx < this.xiValues.size(); ++idx) {
            TwoByteChunk aTwoByteChunk = this.xiValues.get(idx);
            aTwoByteChunk.marshal(buff);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.domainInitialXi = buff.getDouble();
        this.domainFinalXi = buff.getDouble();
        this.domainPointsXi = buff.getShort() & 0xFFFF;
        this.interleafFactor = (short)(buff.get() & 0xFF);
        this.axisType = (short)(buff.get() & 0xFF);
        this.numberOfPointsOnXiAxis = buff.getShort() & 0xFFFF;
        this.initialIndex = buff.getShort() & 0xFFFF;
        this.coordinateScaleXi = buff.getDouble();
        this.coordinateOffsetXi = buff.getDouble();
        for (int idx = 0; idx < this.numberOfPointsOnXiAxis; ++idx) {
            TwoByteChunk anX = new TwoByteChunk();
            anX.unmarshal(buff);
            this.xiValues.add(anX);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof GridAxisDescriptorVariable)) {
            return false;
        }
        GridAxisDescriptorVariable rhs = (GridAxisDescriptorVariable)obj;
        if (this.domainInitialXi != rhs.domainInitialXi) {
            ivarsEqual = false;
        }
        if (this.domainFinalXi != rhs.domainFinalXi) {
            ivarsEqual = false;
        }
        if (this.domainPointsXi != rhs.domainPointsXi) {
            ivarsEqual = false;
        }
        if (this.interleafFactor != rhs.interleafFactor) {
            ivarsEqual = false;
        }
        if (this.axisType != rhs.axisType) {
            ivarsEqual = false;
        }
        if (this.numberOfPointsOnXiAxis != rhs.numberOfPointsOnXiAxis) {
            ivarsEqual = false;
        }
        if (this.initialIndex != rhs.initialIndex) {
            ivarsEqual = false;
        }
        if (this.coordinateScaleXi != rhs.coordinateScaleXi) {
            ivarsEqual = false;
        }
        if (this.coordinateOffsetXi != rhs.coordinateOffsetXi) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.xiValues.size(); ++idx) {
            if (this.xiValues.get(idx).equals(rhs.xiValues.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

