/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class IFFData
implements Serializable {
    protected long recordType;
    protected int recordLength;
    protected byte[] iffData = new byte[0];

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        marshalSize += 2;
        return marshalSize += this.iffData.length;
    }

    public void setRecordType(long pRecordType) {
        this.recordType = pRecordType;
    }

    public long getRecordType() {
        return this.recordType;
    }

    public int getRecordLength() {
        return this.iffData.length;
    }

    public void setRecordLength(int pRecordLength) {
        this.recordLength = pRecordLength;
    }

    public void setIffData(byte[] pIffData) {
        this.iffData = pIffData;
    }

    public byte[] getIffData() {
        return this.iffData;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt((int)this.recordType);
            dos.writeShort((short)this.iffData.length);
            dos.write(this.iffData);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.recordType = dis.readInt();
            this.recordLength = dis.readUnsignedShort();
            this.iffData = new byte[this.recordLength];
            dis.read(this.iffData);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt((int)this.recordType);
        buff.putShort((short)this.iffData.length);
        buff.put(this.iffData);
    }

    public void unmarshal(ByteBuffer buff) {
        this.recordType = buff.getInt();
        this.recordLength = buff.getShort() & 0xFFFF;
        this.iffData = new byte[this.recordLength];
        buff.get(this.iffData);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IFFData)) {
            return false;
        }
        IFFData rhs = (IFFData)obj;
        if (this.recordType != rhs.recordType) {
            ivarsEqual = false;
        }
        if (this.recordLength != rhs.recordLength) {
            ivarsEqual = false;
        }
        if (!Arrays.equals(this.iffData, rhs.iffData)) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

