/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.DistributedEmissionsFamilyPdu;
import edu.nps.moves.dis7.IFFLayer1;
import edu.nps.moves.dis7.IFFLayer2;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class IFFPdu
extends DistributedEmissionsFamilyPdu
implements Serializable {
    protected IFFLayer1 layer1 = new IFFLayer1();
    protected IFFLayer2 layer2 = null;

    public IFFPdu() {
        this.setPduType((short)28);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.layer1.getMarshalledSize();
        if (this.isLayerPresent(2)) {
            marshalSize += this.layer2.getMarshalledSize();
        }
        return marshalSize;
    }

    public IFFLayer1 getLayer1() {
        return this.layer1;
    }

    public void setLayer1(IFFLayer1 layer1) {
        this.layer1 = layer1;
    }

    public IFFLayer2 getLayer2() {
        return this.layer2;
    }

    public void setLayer2(IFFLayer2 layer2) {
        this.layer2 = layer2;
        this.updateInformationLayersPresent();
    }

    private void updateInformationLayersPresent() {
        short informationLayersPresent = 1;
        if (this.layer2 != null) {
            informationLayersPresent = (short)(informationLayersPresent | 2);
        }
        this.layer1.getFundamentalOperationalData().setInformationLayers(informationLayersPresent);
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.layer1.marshal(dos);
            if (this.layer2 != null) {
                this.updateInformationLayersPresent();
                this.layer2.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.layer1.unmarshal(dis);
            if (this.isLayerPresent(2)) {
                this.layer2 = new IFFLayer2();
                this.layer2.unmarshal(dis);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.layer1.marshal(buff);
        if (this.layer2 != null) {
            this.updateInformationLayersPresent();
            this.layer2.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.layer1.unmarshal(buff);
        if (this.isLayerPresent(2)) {
            this.layer2 = new IFFLayer2();
            this.layer2.unmarshal(buff);
        }
    }

    private boolean isLayerPresent(int layer) {
        return (this.layer1.getFundamentalOperationalData().getInformationLayers() & layer) > 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IFFPdu)) {
            return false;
        }
        IFFPdu rhs = (IFFPdu)obj;
        if (!this.layer1.equals(rhs.layer1)) {
            ivarsEqual = false;
        }
        if (!(this.layer2 == null && rhs.layer2 == null || this.layer2 == null && rhs.layer2 == null)) {
            ivarsEqual = false;
        }
        if (!this.layer2.equals(rhs.layer2)) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

