/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.IntercomCommunicationsParameters;
import edu.nps.moves.dis7.RadioCommunicationsFamilyPdu;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class IntercomControlPdu
extends RadioCommunicationsFamilyPdu
implements Serializable {
    protected short controlType;
    protected short communicationsChannelType;
    protected EntityID sourceEntityID = new EntityID();
    protected short sourceCommunicationsDeviceID;
    protected short sourceLineID;
    protected short transmitPriority;
    protected short transmitLineState;
    protected short command;
    protected EntityID masterEntityID = new EntityID();
    protected int masterCommunicationsDeviceID;
    protected long intercomParametersLength;
    protected List<IntercomCommunicationsParameters> intercomParameters = new ArrayList<IntercomCommunicationsParameters>();

    public IntercomControlPdu() {
        this.setPduType((short)32);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.sourceEntityID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.masterEntityID.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 4;
        for (int idx = 0; idx < this.intercomParameters.size(); ++idx) {
            IntercomCommunicationsParameters listElement = this.intercomParameters.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setControlType(short pControlType) {
        this.controlType = pControlType;
    }

    public short getControlType() {
        return this.controlType;
    }

    public void setCommunicationsChannelType(short pCommunicationsChannelType) {
        this.communicationsChannelType = pCommunicationsChannelType;
    }

    public short getCommunicationsChannelType() {
        return this.communicationsChannelType;
    }

    public void setSourceEntityID(EntityID pSourceEntityID) {
        this.sourceEntityID = pSourceEntityID;
    }

    public EntityID getSourceEntityID() {
        return this.sourceEntityID;
    }

    public void setSourceCommunicationsDeviceID(short pSourceCommunicationsDeviceID) {
        this.sourceCommunicationsDeviceID = pSourceCommunicationsDeviceID;
    }

    public short getSourceCommunicationsDeviceID() {
        return this.sourceCommunicationsDeviceID;
    }

    public void setSourceLineID(short pSourceLineID) {
        this.sourceLineID = pSourceLineID;
    }

    public short getSourceLineID() {
        return this.sourceLineID;
    }

    public void setTransmitPriority(short pTransmitPriority) {
        this.transmitPriority = pTransmitPriority;
    }

    public short getTransmitPriority() {
        return this.transmitPriority;
    }

    public void setTransmitLineState(short pTransmitLineState) {
        this.transmitLineState = pTransmitLineState;
    }

    public short getTransmitLineState() {
        return this.transmitLineState;
    }

    public void setCommand(short pCommand) {
        this.command = pCommand;
    }

    public short getCommand() {
        return this.command;
    }

    public void setMasterEntityID(EntityID pMasterEntityID) {
        this.masterEntityID = pMasterEntityID;
    }

    public EntityID getMasterEntityID() {
        return this.masterEntityID;
    }

    public void setMasterCommunicationsDeviceID(int pMasterCommunicationsDeviceID) {
        this.masterCommunicationsDeviceID = pMasterCommunicationsDeviceID;
    }

    public int getMasterCommunicationsDeviceID() {
        return this.masterCommunicationsDeviceID;
    }

    public long getIntercomParametersLength() {
        return this.intercomParameters.size();
    }

    public void setIntercomParametersLength(long pIntercomParametersLength) {
        this.intercomParametersLength = pIntercomParametersLength;
    }

    public void setIntercomParameters(List<IntercomCommunicationsParameters> pIntercomParameters) {
        this.intercomParameters = pIntercomParameters;
    }

    public List<IntercomCommunicationsParameters> getIntercomParameters() {
        return this.intercomParameters;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            dos.writeByte((byte)this.controlType);
            dos.writeByte((byte)this.communicationsChannelType);
            this.sourceEntityID.marshal(dos);
            dos.writeByte((byte)this.sourceCommunicationsDeviceID);
            dos.writeByte((byte)this.sourceLineID);
            dos.writeByte((byte)this.transmitPriority);
            dos.writeByte((byte)this.transmitLineState);
            dos.writeByte((byte)this.command);
            this.masterEntityID.marshal(dos);
            dos.writeShort((short)this.masterCommunicationsDeviceID);
            dos.writeInt(this.intercomParameters.size());
            for (int idx = 0; idx < this.intercomParameters.size(); ++idx) {
                IntercomCommunicationsParameters aIntercomCommunicationsParameters = this.intercomParameters.get(idx);
                aIntercomCommunicationsParameters.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.controlType = (short)dis.readUnsignedByte();
            this.communicationsChannelType = (short)dis.readUnsignedByte();
            this.sourceEntityID.unmarshal(dis);
            this.sourceCommunicationsDeviceID = (short)dis.readUnsignedByte();
            this.sourceLineID = (short)dis.readUnsignedByte();
            this.transmitPriority = (short)dis.readUnsignedByte();
            this.transmitLineState = (short)dis.readUnsignedByte();
            this.command = (short)dis.readUnsignedByte();
            this.masterEntityID.unmarshal(dis);
            this.masterCommunicationsDeviceID = dis.readUnsignedShort();
            this.intercomParametersLength = dis.readInt();
            int idx = 0;
            while ((long)idx < this.intercomParametersLength) {
                IntercomCommunicationsParameters anX = new IntercomCommunicationsParameters();
                anX.unmarshal(dis);
                this.intercomParameters.add(anX);
                ++idx;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        buff.put((byte)this.controlType);
        buff.put((byte)this.communicationsChannelType);
        this.sourceEntityID.marshal(buff);
        buff.put((byte)this.sourceCommunicationsDeviceID);
        buff.put((byte)this.sourceLineID);
        buff.put((byte)this.transmitPriority);
        buff.put((byte)this.transmitLineState);
        buff.put((byte)this.command);
        this.masterEntityID.marshal(buff);
        buff.putShort((short)this.masterCommunicationsDeviceID);
        buff.putInt(this.intercomParameters.size());
        for (int idx = 0; idx < this.intercomParameters.size(); ++idx) {
            IntercomCommunicationsParameters aIntercomCommunicationsParameters = this.intercomParameters.get(idx);
            aIntercomCommunicationsParameters.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.controlType = (short)(buff.get() & 0xFF);
        this.communicationsChannelType = (short)(buff.get() & 0xFF);
        this.sourceEntityID.unmarshal(buff);
        this.sourceCommunicationsDeviceID = (short)(buff.get() & 0xFF);
        this.sourceLineID = (short)(buff.get() & 0xFF);
        this.transmitPriority = (short)(buff.get() & 0xFF);
        this.transmitLineState = (short)(buff.get() & 0xFF);
        this.command = (short)(buff.get() & 0xFF);
        this.masterEntityID.unmarshal(buff);
        this.masterCommunicationsDeviceID = buff.getShort() & 0xFFFF;
        this.intercomParametersLength = buff.getInt();
        int idx = 0;
        while ((long)idx < this.intercomParametersLength) {
            IntercomCommunicationsParameters anX = new IntercomCommunicationsParameters();
            anX.unmarshal(buff);
            this.intercomParameters.add(anX);
            ++idx;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof IntercomControlPdu)) {
            return false;
        }
        IntercomControlPdu rhs = (IntercomControlPdu)obj;
        if (this.controlType != rhs.controlType) {
            ivarsEqual = false;
        }
        if (this.communicationsChannelType != rhs.communicationsChannelType) {
            ivarsEqual = false;
        }
        if (!this.sourceEntityID.equals(rhs.sourceEntityID)) {
            ivarsEqual = false;
        }
        if (this.sourceCommunicationsDeviceID != rhs.sourceCommunicationsDeviceID) {
            ivarsEqual = false;
        }
        if (this.sourceLineID != rhs.sourceLineID) {
            ivarsEqual = false;
        }
        if (this.transmitPriority != rhs.transmitPriority) {
            ivarsEqual = false;
        }
        if (this.transmitLineState != rhs.transmitLineState) {
            ivarsEqual = false;
        }
        if (this.command != rhs.command) {
            ivarsEqual = false;
        }
        if (!this.masterEntityID.equals(rhs.masterEntityID)) {
            ivarsEqual = false;
        }
        if (this.masterCommunicationsDeviceID != rhs.masterCommunicationsDeviceID) {
            ivarsEqual = false;
        }
        if (this.intercomParametersLength != rhs.intercomParametersLength) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.intercomParameters.size(); ++idx) {
            if (this.intercomParameters.get(idx).equals(rhs.intercomParameters.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

