/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.PduSuperclass;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class LiveEntityPdu
extends PduSuperclass
implements Serializable {
    protected int subprotocolNumber;
    protected short padding = 0;

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += 2;
        return ++marshalSize;
    }

    public void setSubprotocolNumber(int pSubprotocolNumber) {
        this.subprotocolNumber = pSubprotocolNumber;
    }

    public int getSubprotocolNumber() {
        return this.subprotocolNumber;
    }

    public void setPadding(short pPadding) {
        this.padding = pPadding;
    }

    public short getPadding() {
        return this.padding;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            dos.writeShort((short)this.subprotocolNumber);
            dos.writeByte((byte)this.padding);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.subprotocolNumber = dis.readUnsignedShort();
            this.padding = (short)dis.readUnsignedByte();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        buff.putShort((short)this.subprotocolNumber);
        buff.put((byte)this.padding);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.subprotocolNumber = buff.getShort() & 0xFFFF;
        this.padding = (short)(buff.get() & 0xFF);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof LiveEntityPdu)) {
            return false;
        }
        LiveEntityPdu rhs = (LiveEntityPdu)obj;
        if (this.subprotocolNumber != rhs.subprotocolNumber) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

