/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.ModulationParameters;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ModulationParametersGeneric
extends ModulationParameters {
    private List<Byte> modulationParametersList = new ArrayList<Byte>();

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.modulationParametersList.size();
        int remainder = this.modulationParametersList.size() % 8;
        if (remainder > 0) {
            marshalSize += this.calculatePaddingByteNr(remainder);
        }
        return marshalSize;
    }

    public List<Byte> getModulationParametersList() {
        return this.modulationParametersList;
    }

    public void setModulationParametersList(List<Byte> modulationParametersList) {
        this.modulationParametersList = modulationParametersList;
    }

    private int calculatePaddingByteNr(int remainder) {
        int paddingByteNr = 0;
        switch (remainder) {
            case 1: {
                paddingByteNr = 7;
                break;
            }
            case 2: {
                paddingByteNr = 6;
                break;
            }
            case 3: {
                paddingByteNr = 5;
                break;
            }
            case 4: {
                paddingByteNr = 4;
                break;
            }
            case 5: {
                paddingByteNr = 3;
                break;
            }
            case 6: {
                paddingByteNr = 2;
                break;
            }
            case 7: {
                paddingByteNr = 1;
            }
        }
        return paddingByteNr;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        try {
            for (int idx = 0; idx < this.modulationParametersList.size(); ++idx) {
                byte modulationParameter = this.modulationParametersList.get(idx);
                dos.writeByte(modulationParameter);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis, int byteCount) {
        try {
            for (int i = 0; i < byteCount; ++i) {
                byte nextByte = dis.readByte();
                this.modulationParametersList.add(nextByte);
            }
            int remainder = byteCount % 8;
            if (remainder > 0) {
                int paddingByteNr = 0;
                paddingByteNr = this.calculatePaddingByteNr(remainder);
                for (int i = 0; i < paddingByteNr; ++i) {
                    dis.readByte();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        for (byte nextByte : this.modulationParametersList) {
            buff.put(nextByte);
        }
        int remainder = this.modulationParametersList.size() % 8;
        if (remainder > 0) {
            int paddingByteNr = 0;
            paddingByteNr = this.calculatePaddingByteNr(remainder);
            for (int i = 0; i < paddingByteNr; ++i) {
                buff.put((byte)0);
            }
        }
    }

    public void unmarshal(ByteBuffer buff, int byteCount) {
        try {
            for (int i = 0; i < byteCount; ++i) {
                byte nextByte = buff.get();
                this.modulationParametersList.add(nextByte);
            }
            int remainder = byteCount % 8;
            if (remainder > 0) {
                int paddingByteNr = 0;
                paddingByteNr = this.calculatePaddingByteNr(remainder);
                for (int i = 0; i < paddingByteNr; ++i) {
                    buff.get();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ModulationParametersGeneric)) {
            return false;
        }
        ModulationParametersGeneric rhs = (ModulationParametersGeneric)obj;
        for (int idx = 0; idx < this.modulationParametersList.size(); ++idx) {
            if (this.modulationParametersList.get(idx).equals(rhs.modulationParametersList.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

