/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.SimulationAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class ObjectIdentifier
implements Serializable {
    protected SimulationAddress simulationAddress = new SimulationAddress();
    protected int objectNumber;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.simulationAddress.getMarshalledSize();
        return marshalSize += 2;
    }

    public void setSimulationAddress(SimulationAddress pSimulationAddress) {
        this.simulationAddress = pSimulationAddress;
    }

    public SimulationAddress getSimulationAddress() {
        return this.simulationAddress;
    }

    public void setObjectNumber(int pObjectNumber) {
        this.objectNumber = pObjectNumber;
    }

    public int getObjectNumber() {
        return this.objectNumber;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.simulationAddress.marshal(dos);
            dos.writeShort((short)this.objectNumber);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.simulationAddress.unmarshal(dis);
            this.objectNumber = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.simulationAddress.marshal(buff);
        buff.putShort((short)this.objectNumber);
    }

    public void unmarshal(ByteBuffer buff) {
        this.simulationAddress.unmarshal(buff);
        this.objectNumber = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ObjectIdentifier)) {
            return false;
        }
        ObjectIdentifier rhs = (ObjectIdentifier)obj;
        if (!this.simulationAddress.equals(rhs.simulationAddress)) {
            ivarsEqual = false;
        }
        if (this.objectNumber != rhs.objectNumber) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

