/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class PduHeader
implements Serializable {
    protected short protocolVersion = (short)7;
    protected short exerciseID = 0;
    protected short pduType;
    protected short protocolFamily;
    protected long timestamp;
    protected short pduLength;
    protected int pduStatus;
    protected short padding = 0;

    public int getMarshalledSize() {
        int marshalSize = 0;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        ++marshalSize;
        marshalSize += 4;
        ++marshalSize;
        marshalSize += 2;
        return ++marshalSize;
    }

    public void setProtocolVersion(short pProtocolVersion) {
        this.protocolVersion = pProtocolVersion;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setExerciseID(short pExerciseID) {
        this.exerciseID = pExerciseID;
    }

    public short getExerciseID() {
        return this.exerciseID;
    }

    public void setPduType(short pPduType) {
        this.pduType = pPduType;
    }

    public short getPduType() {
        return this.pduType;
    }

    public void setProtocolFamily(short pProtocolFamily) {
        this.protocolFamily = pProtocolFamily;
    }

    public short getProtocolFamily() {
        return this.protocolFamily;
    }

    public void setTimestamp(long pTimestamp) {
        this.timestamp = pTimestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setPduLength(short pPduLength) {
        this.pduLength = pPduLength;
    }

    public short getPduLength() {
        return this.pduLength;
    }

    public void setPduStatus(int pPduStatus) {
        this.pduStatus = pPduStatus;
    }

    public int getPduStatus() {
        return this.pduStatus;
    }

    public void setPadding(short pPadding) {
        this.padding = pPadding;
    }

    public short getPadding() {
        return this.padding;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeByte((byte)this.protocolVersion);
            dos.writeByte((byte)this.exerciseID);
            dos.writeByte((byte)this.pduType);
            dos.writeByte((byte)this.protocolFamily);
            dos.writeInt((int)this.timestamp);
            dos.writeByte((byte)this.pduLength);
            dos.writeShort((short)this.pduStatus);
            dos.writeByte((byte)this.padding);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.protocolVersion = (short)dis.readUnsignedByte();
            this.exerciseID = (short)dis.readUnsignedByte();
            this.pduType = (short)dis.readUnsignedByte();
            this.protocolFamily = (short)dis.readUnsignedByte();
            this.timestamp = dis.readInt();
            this.pduLength = (short)dis.readUnsignedByte();
            this.pduStatus = dis.readUnsignedShort();
            this.padding = (short)dis.readUnsignedByte();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.put((byte)this.protocolVersion);
        buff.put((byte)this.exerciseID);
        buff.put((byte)this.pduType);
        buff.put((byte)this.protocolFamily);
        buff.putInt((int)this.timestamp);
        buff.put((byte)this.pduLength);
        buff.putShort((short)this.pduStatus);
        buff.put((byte)this.padding);
    }

    public void unmarshal(ByteBuffer buff) {
        this.protocolVersion = (short)(buff.get() & 0xFF);
        this.exerciseID = (short)(buff.get() & 0xFF);
        this.pduType = (short)(buff.get() & 0xFF);
        this.protocolFamily = (short)(buff.get() & 0xFF);
        this.timestamp = buff.getInt();
        this.pduLength = (short)(buff.get() & 0xFF);
        this.pduStatus = buff.getShort() & 0xFFFF;
        this.padding = (short)(buff.get() & 0xFF);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof PduHeader)) {
            return false;
        }
        PduHeader rhs = (PduHeader)obj;
        if (this.protocolVersion != rhs.protocolVersion) {
            ivarsEqual = false;
        }
        if (this.exerciseID != rhs.exerciseID) {
            ivarsEqual = false;
        }
        if (this.pduType != rhs.pduType) {
            ivarsEqual = false;
        }
        if (this.protocolFamily != rhs.protocolFamily) {
            ivarsEqual = false;
        }
        if (this.timestamp != rhs.timestamp) {
            ivarsEqual = false;
        }
        if (this.pduLength != rhs.pduLength) {
            ivarsEqual = false;
        }
        if (this.pduStatus != rhs.pduStatus) {
            ivarsEqual = false;
        }
        if (this.padding != rhs.padding) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

