/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class PduStream
implements Serializable {
    protected byte[] description = new byte[512];
    protected byte[] name = new byte[256];
    protected long startTime;
    protected long stopTime;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 512;
        marshalSize += 256;
        marshalSize += 8;
        return marshalSize += 8;
    }

    public void setDescription(byte[] pDescription) {
        this.description = pDescription;
    }

    public byte[] getDescription() {
        return this.description;
    }

    public void setName(byte[] pName) {
        this.name = pName;
    }

    public byte[] getName() {
        return this.name;
    }

    public void setStartTime(long pStartTime) {
        this.startTime = pStartTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStopTime(long pStopTime) {
        this.stopTime = pStopTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void marshal(DataOutputStream dos) {
        try {
            int idx;
            for (idx = 0; idx < this.description.length; ++idx) {
                dos.writeByte(this.description[idx]);
            }
            for (idx = 0; idx < this.name.length; ++idx) {
                dos.writeByte(this.name[idx]);
            }
            dos.writeLong(this.startTime);
            dos.writeLong(this.stopTime);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            int idx;
            for (idx = 0; idx < this.description.length; ++idx) {
                this.description[idx] = dis.readByte();
            }
            for (idx = 0; idx < this.name.length; ++idx) {
                this.name[idx] = dis.readByte();
            }
            this.startTime = dis.readLong();
            this.stopTime = dis.readLong();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        int idx;
        for (idx = 0; idx < this.description.length; ++idx) {
            buff.put(this.description[idx]);
        }
        for (idx = 0; idx < this.name.length; ++idx) {
            buff.put(this.name[idx]);
        }
        buff.putLong(this.startTime);
        buff.putLong(this.stopTime);
    }

    public void unmarshal(ByteBuffer buff) {
        int idx;
        for (idx = 0; idx < this.description.length; ++idx) {
            this.description[idx] = buff.get();
        }
        for (idx = 0; idx < this.name.length; ++idx) {
            this.name[idx] = buff.get();
        }
        this.startTime = buff.getLong();
        this.stopTime = buff.getLong();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof PduStream)) {
            return false;
        }
        PduStream rhs = (PduStream)obj;
        for (idx = 0; idx < 512; ++idx) {
            if (this.description[idx] == rhs.description[idx]) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < 256; ++idx) {
            if (this.name[idx] == rhs.name[idx]) continue;
            ivarsEqual = false;
        }
        if (this.startTime != rhs.startTime) {
            ivarsEqual = false;
        }
        if (this.stopTime != rhs.stopTime) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

