/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.EulerAngles;
import edu.nps.moves.dis7.ObjectType;
import edu.nps.moves.dis7.SimulationAddress;
import edu.nps.moves.dis7.SyntheticEnvironmentFamilyPdu;
import edu.nps.moves.dis7.Vector3Double;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class PointObjectStatePdu
extends SyntheticEnvironmentFamilyPdu
implements Serializable {
    protected EntityID objectID = new EntityID();
    protected EntityID referencedObjectID = new EntityID();
    protected int updateNumber;
    protected short forceID;
    protected short modifications;
    protected ObjectType objectType = new ObjectType();
    protected Vector3Double objectLocation = new Vector3Double();
    protected EulerAngles objectOrientation = new EulerAngles();
    protected double objectAppearance;
    protected SimulationAddress requesterID = new SimulationAddress();
    protected SimulationAddress receivingID = new SimulationAddress();
    protected long pad2;

    public PointObjectStatePdu() {
        this.setPduType((short)43);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.objectID.getMarshalledSize();
        marshalSize += this.referencedObjectID.getMarshalledSize();
        marshalSize += 2;
        ++marshalSize;
        ++marshalSize;
        marshalSize += this.objectType.getMarshalledSize();
        marshalSize += this.objectLocation.getMarshalledSize();
        marshalSize += this.objectOrientation.getMarshalledSize();
        marshalSize += 8;
        marshalSize += this.requesterID.getMarshalledSize();
        marshalSize += this.receivingID.getMarshalledSize();
        return marshalSize += 4;
    }

    public void setObjectID(EntityID pObjectID) {
        this.objectID = pObjectID;
    }

    public EntityID getObjectID() {
        return this.objectID;
    }

    public void setReferencedObjectID(EntityID pReferencedObjectID) {
        this.referencedObjectID = pReferencedObjectID;
    }

    public EntityID getReferencedObjectID() {
        return this.referencedObjectID;
    }

    public void setUpdateNumber(int pUpdateNumber) {
        this.updateNumber = pUpdateNumber;
    }

    public int getUpdateNumber() {
        return this.updateNumber;
    }

    public void setForceID(short pForceID) {
        this.forceID = pForceID;
    }

    public short getForceID() {
        return this.forceID;
    }

    public void setModifications(short pModifications) {
        this.modifications = pModifications;
    }

    public short getModifications() {
        return this.modifications;
    }

    public void setObjectType(ObjectType pObjectType) {
        this.objectType = pObjectType;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectLocation(Vector3Double pObjectLocation) {
        this.objectLocation = pObjectLocation;
    }

    public Vector3Double getObjectLocation() {
        return this.objectLocation;
    }

    public void setObjectOrientation(EulerAngles pObjectOrientation) {
        this.objectOrientation = pObjectOrientation;
    }

    public EulerAngles getObjectOrientation() {
        return this.objectOrientation;
    }

    public void setObjectAppearance(double pObjectAppearance) {
        this.objectAppearance = pObjectAppearance;
    }

    public double getObjectAppearance() {
        return this.objectAppearance;
    }

    public void setRequesterID(SimulationAddress pRequesterID) {
        this.requesterID = pRequesterID;
    }

    public SimulationAddress getRequesterID() {
        return this.requesterID;
    }

    public void setReceivingID(SimulationAddress pReceivingID) {
        this.receivingID = pReceivingID;
    }

    public SimulationAddress getReceivingID() {
        return this.receivingID;
    }

    public void setPad2(long pPad2) {
        this.pad2 = pPad2;
    }

    public long getPad2() {
        return this.pad2;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.objectID.marshal(dos);
            this.referencedObjectID.marshal(dos);
            dos.writeShort((short)this.updateNumber);
            dos.writeByte((byte)this.forceID);
            dos.writeByte((byte)this.modifications);
            this.objectType.marshal(dos);
            this.objectLocation.marshal(dos);
            this.objectOrientation.marshal(dos);
            dos.writeDouble(this.objectAppearance);
            this.requesterID.marshal(dos);
            this.receivingID.marshal(dos);
            dos.writeInt((int)this.pad2);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.objectID.unmarshal(dis);
            this.referencedObjectID.unmarshal(dis);
            this.updateNumber = dis.readUnsignedShort();
            this.forceID = (short)dis.readUnsignedByte();
            this.modifications = (short)dis.readUnsignedByte();
            this.objectType.unmarshal(dis);
            this.objectLocation.unmarshal(dis);
            this.objectOrientation.unmarshal(dis);
            this.objectAppearance = dis.readDouble();
            this.requesterID.unmarshal(dis);
            this.receivingID.unmarshal(dis);
            this.pad2 = dis.readInt();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.objectID.marshal(buff);
        this.referencedObjectID.marshal(buff);
        buff.putShort((short)this.updateNumber);
        buff.put((byte)this.forceID);
        buff.put((byte)this.modifications);
        this.objectType.marshal(buff);
        this.objectLocation.marshal(buff);
        this.objectOrientation.marshal(buff);
        buff.putDouble(this.objectAppearance);
        this.requesterID.marshal(buff);
        this.receivingID.marshal(buff);
        buff.putInt((int)this.pad2);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.objectID.unmarshal(buff);
        this.referencedObjectID.unmarshal(buff);
        this.updateNumber = buff.getShort() & 0xFFFF;
        this.forceID = (short)(buff.get() & 0xFF);
        this.modifications = (short)(buff.get() & 0xFF);
        this.objectType.unmarshal(buff);
        this.objectLocation.unmarshal(buff);
        this.objectOrientation.unmarshal(buff);
        this.objectAppearance = buff.getDouble();
        this.requesterID.unmarshal(buff);
        this.receivingID.unmarshal(buff);
        this.pad2 = buff.getInt();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof PointObjectStatePdu)) {
            return false;
        }
        PointObjectStatePdu rhs = (PointObjectStatePdu)obj;
        if (!this.objectID.equals(rhs.objectID)) {
            ivarsEqual = false;
        }
        if (!this.referencedObjectID.equals(rhs.referencedObjectID)) {
            ivarsEqual = false;
        }
        if (this.updateNumber != rhs.updateNumber) {
            ivarsEqual = false;
        }
        if (this.forceID != rhs.forceID) {
            ivarsEqual = false;
        }
        if (this.modifications != rhs.modifications) {
            ivarsEqual = false;
        }
        if (!this.objectType.equals(rhs.objectType)) {
            ivarsEqual = false;
        }
        if (!this.objectLocation.equals(rhs.objectLocation)) {
            ivarsEqual = false;
        }
        if (!this.objectOrientation.equals(rhs.objectOrientation)) {
            ivarsEqual = false;
        }
        if (this.objectAppearance != rhs.objectAppearance) {
            ivarsEqual = false;
        }
        if (!this.requesterID.equals(rhs.requesterID)) {
            ivarsEqual = false;
        }
        if (!this.receivingID.equals(rhs.receivingID)) {
            ivarsEqual = false;
        }
        if (this.pad2 != rhs.pad2) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

