/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.RadioCommunicationsFamilyPdu;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class ReceiverPdu
extends RadioCommunicationsFamilyPdu
implements Serializable {
    protected EntityID radioReferenceID = new EntityID();
    protected int radioNumber;
    protected int receiverState;
    protected int padding1;
    protected float receivedPower;
    protected EntityID transmitterEntityId = new EntityID();
    protected int transmitterRadioId;

    public ReceiverPdu() {
        this.setPduType((short)27);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.radioReferenceID.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 4;
        marshalSize += this.transmitterEntityId.getMarshalledSize();
        return marshalSize += 2;
    }

    public void setRadioReferenceID(EntityID pRadioReferenceID) {
        this.radioReferenceID = pRadioReferenceID;
    }

    public EntityID getRadioReferenceID() {
        return this.radioReferenceID;
    }

    public void setRadioNumber(int pRadioNumber) {
        this.radioNumber = pRadioNumber;
    }

    public int getRadioNumber() {
        return this.radioNumber;
    }

    public void setReceiverState(int pReceiverState) {
        this.receiverState = pReceiverState;
    }

    public int getReceiverState() {
        return this.receiverState;
    }

    public void setPadding1(int pPadding1) {
        this.padding1 = pPadding1;
    }

    public int getPadding1() {
        return this.padding1;
    }

    public void setReceivedPower(float pReceivedPower) {
        this.receivedPower = pReceivedPower;
    }

    public float getReceivedPower() {
        return this.receivedPower;
    }

    public void setTransmitterEntityId(EntityID pTransmitterEntityId) {
        this.transmitterEntityId = pTransmitterEntityId;
    }

    public EntityID getTransmitterEntityId() {
        return this.transmitterEntityId;
    }

    public void setTransmitterRadioId(int pTransmitterRadioId) {
        this.transmitterRadioId = pTransmitterRadioId;
    }

    public int getTransmitterRadioId() {
        return this.transmitterRadioId;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.radioReferenceID.marshal(dos);
            dos.writeShort((short)this.radioNumber);
            dos.writeShort((short)this.receiverState);
            dos.writeShort((short)this.padding1);
            dos.writeFloat(this.receivedPower);
            this.transmitterEntityId.marshal(dos);
            dos.writeShort((short)this.transmitterRadioId);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.radioReferenceID.unmarshal(dis);
            this.radioNumber = dis.readUnsignedShort();
            this.receiverState = dis.readUnsignedShort();
            this.padding1 = dis.readUnsignedShort();
            this.receivedPower = dis.readFloat();
            this.transmitterEntityId.unmarshal(dis);
            this.transmitterRadioId = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.radioReferenceID.marshal(buff);
        buff.putShort((short)this.radioNumber);
        buff.putShort((short)this.receiverState);
        buff.putShort((short)this.padding1);
        buff.putFloat(this.receivedPower);
        this.transmitterEntityId.marshal(buff);
        buff.putShort((short)this.transmitterRadioId);
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.radioReferenceID.unmarshal(buff);
        this.radioNumber = buff.getShort() & 0xFFFF;
        this.receiverState = buff.getShort() & 0xFFFF;
        this.padding1 = buff.getShort() & 0xFFFF;
        this.receivedPower = buff.getFloat();
        this.transmitterEntityId.unmarshal(buff);
        this.transmitterRadioId = buff.getShort() & 0xFFFF;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ReceiverPdu)) {
            return false;
        }
        ReceiverPdu rhs = (ReceiverPdu)obj;
        if (!this.radioReferenceID.equals(rhs.radioReferenceID)) {
            ivarsEqual = false;
        }
        if (this.radioNumber != rhs.radioNumber) {
            ivarsEqual = false;
        }
        if (this.receiverState != rhs.receiverState) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.receivedPower != rhs.receivedPower) {
            ivarsEqual = false;
        }
        if (!this.transmitterEntityId.equals(rhs.transmitterEntityId)) {
            ivarsEqual = false;
        }
        if (this.transmitterRadioId != rhs.transmitterRadioId) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

