/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import edu.nps.moves.dis7.LogisticsFamilyPdu;
import edu.nps.moves.dis7.SupplyQuantity;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ResupplyOfferPdu
extends LogisticsFamilyPdu
implements Serializable {
    protected EntityID receivingEntityID = new EntityID();
    protected EntityID supplyingEntityID = new EntityID();
    protected short numberOfSupplyTypes;
    protected byte padding1 = 0;
    protected short padding2 = 0;
    protected List<SupplyQuantity> supplies = new ArrayList<SupplyQuantity>();

    public ResupplyOfferPdu() {
        this.setPduType((short)6);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.receivingEntityID.getMarshalledSize();
        marshalSize += this.supplyingEntityID.getMarshalledSize();
        ++marshalSize;
        ++marshalSize;
        marshalSize += 2;
        for (int idx = 0; idx < this.supplies.size(); ++idx) {
            SupplyQuantity listElement = this.supplies.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setReceivingEntityID(EntityID pReceivingEntityID) {
        this.receivingEntityID = pReceivingEntityID;
    }

    public EntityID getReceivingEntityID() {
        return this.receivingEntityID;
    }

    public void setSupplyingEntityID(EntityID pSupplyingEntityID) {
        this.supplyingEntityID = pSupplyingEntityID;
    }

    public EntityID getSupplyingEntityID() {
        return this.supplyingEntityID;
    }

    public short getNumberOfSupplyTypes() {
        return (short)this.supplies.size();
    }

    public void setNumberOfSupplyTypes(short pNumberOfSupplyTypes) {
        this.numberOfSupplyTypes = pNumberOfSupplyTypes;
    }

    public void setPadding1(byte pPadding1) {
        this.padding1 = pPadding1;
    }

    public byte getPadding1() {
        return this.padding1;
    }

    public void setPadding2(short pPadding2) {
        this.padding2 = pPadding2;
    }

    public short getPadding2() {
        return this.padding2;
    }

    public void setSupplies(List<SupplyQuantity> pSupplies) {
        this.supplies = pSupplies;
    }

    public List<SupplyQuantity> getSupplies() {
        return this.supplies;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.receivingEntityID.marshal(dos);
            this.supplyingEntityID.marshal(dos);
            dos.writeByte((byte)this.supplies.size());
            dos.writeByte(this.padding1);
            dos.writeShort(this.padding2);
            for (int idx = 0; idx < this.supplies.size(); ++idx) {
                SupplyQuantity aSupplyQuantity = this.supplies.get(idx);
                aSupplyQuantity.marshal(dos);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.receivingEntityID.unmarshal(dis);
            this.supplyingEntityID.unmarshal(dis);
            this.numberOfSupplyTypes = (short)dis.readUnsignedByte();
            this.padding1 = dis.readByte();
            this.padding2 = dis.readShort();
            for (int idx = 0; idx < this.numberOfSupplyTypes; ++idx) {
                SupplyQuantity anX = new SupplyQuantity();
                anX.unmarshal(dis);
                this.supplies.add(anX);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.receivingEntityID.marshal(buff);
        this.supplyingEntityID.marshal(buff);
        buff.put((byte)this.supplies.size());
        buff.put(this.padding1);
        buff.putShort(this.padding2);
        for (int idx = 0; idx < this.supplies.size(); ++idx) {
            SupplyQuantity aSupplyQuantity = this.supplies.get(idx);
            aSupplyQuantity.marshal(buff);
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.receivingEntityID.unmarshal(buff);
        this.supplyingEntityID.unmarshal(buff);
        this.numberOfSupplyTypes = (short)(buff.get() & 0xFF);
        this.padding1 = buff.get();
        this.padding2 = buff.getShort();
        for (int idx = 0; idx < this.numberOfSupplyTypes; ++idx) {
            SupplyQuantity anX = new SupplyQuantity();
            anX.unmarshal(buff);
            this.supplies.add(anX);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof ResupplyOfferPdu)) {
            return false;
        }
        ResupplyOfferPdu rhs = (ResupplyOfferPdu)obj;
        if (!this.receivingEntityID.equals(rhs.receivingEntityID)) {
            ivarsEqual = false;
        }
        if (!this.supplyingEntityID.equals(rhs.supplyingEntityID)) {
            ivarsEqual = false;
        }
        if (this.numberOfSupplyTypes != rhs.numberOfSupplyTypes) {
            ivarsEqual = false;
        }
        if (this.padding1 != rhs.padding1) {
            ivarsEqual = false;
        }
        if (this.padding2 != rhs.padding2) {
            ivarsEqual = false;
        }
        for (int idx = 0; idx < this.supplies.size(); ++idx) {
            if (this.supplies.get(idx).equals(rhs.supplies.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

