/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.RadioCommunicationsFamilyPdu;
import edu.nps.moves.dis7.RadioIdentifier;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SignalPdu
extends RadioCommunicationsFamilyPdu
implements Serializable {
    protected RadioIdentifier radioIdentifier = new RadioIdentifier();
    protected int radioNumber;
    protected int encodingScheme;
    protected int tdlType;
    protected long sampleRate;
    protected short dataLength;
    protected short samples;
    protected byte[] data = new byte[0];

    public SignalPdu() {
        this.setPduType((short)26);
    }

    @Override
    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize = super.getMarshalledSize();
        marshalSize += this.radioIdentifier.getMarshalledSize();
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += 4;
        marshalSize += 2;
        marshalSize += 2;
        marshalSize += this.data.length;
        switch (this.data.length % 4) {
            case 0: {
                break;
            }
            case 1: {
                marshalSize += 3;
                break;
            }
            case 2: {
                marshalSize += 2;
                break;
            }
            case 3: {
                ++marshalSize;
            }
        }
        return marshalSize;
    }

    public void setRadioIdentifier(RadioIdentifier pRadioIdentifier) {
        this.radioIdentifier = pRadioIdentifier;
    }

    public RadioIdentifier getRadioIdentifier() {
        return this.radioIdentifier;
    }

    public void setRadioNumber(int pRadioNumber) {
        this.radioNumber = pRadioNumber;
    }

    public int getRadioNumber() {
        return this.radioNumber;
    }

    public void setEncodingScheme(int pEncodingScheme) {
        this.encodingScheme = pEncodingScheme;
    }

    public int getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingClass(int pEncodingClass) {
        int newEncodingClass = 0;
        int newEncodingScheme = 0;
        newEncodingClass = pEncodingClass << 14;
        newEncodingScheme = newEncodingClass | this.getEncodingType();
        this.setEncodingScheme(newEncodingScheme);
    }

    public int getEncodingClass() {
        int extractEncodingClass = 0;
        extractEncodingClass = this.getEncodingScheme() & 0xC000;
        return extractEncodingClass >>>= 14;
    }

    public void setEncodingType(int pEncodingType) {
        int newEncodingScheme = 0;
        newEncodingScheme = this.getEncodingScheme() & 0xC000;
        this.setEncodingScheme(newEncodingScheme |= pEncodingType);
    }

    public int getEncodingType() {
        int extractEncodingType = 0;
        extractEncodingType = this.getEncodingScheme() & 0x3FFF;
        return extractEncodingType;
    }

    public void setNumberofTDLMessages(int pEncodingType) {
        int newEncodingScheme = 0;
        newEncodingScheme = this.getEncodingScheme() & 0xC000;
        this.setEncodingScheme(newEncodingScheme |= pEncodingType);
    }

    public int getNumberofTDLMessages() {
        int extractEncodingType = 0;
        extractEncodingType = this.getEncodingScheme() & 0x3FFF;
        return extractEncodingType;
    }

    public void setTdlType(int pTdlType) {
        this.tdlType = pTdlType;
    }

    public int getTdlType() {
        return this.tdlType;
    }

    public void setSampleRate(long pSampleRate) {
        this.sampleRate = pSampleRate;
    }

    public long getSampleRate() {
        return this.sampleRate;
    }

    public short getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(short pDataLength) {
        this.dataLength = pDataLength;
    }

    public void setSamples(short pSamples) {
        this.samples = pSamples;
    }

    public short getSamples() {
        return this.samples;
    }

    public void setData(byte[] pData) {
        this.data = pData;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void marshal(DataOutputStream dos) {
        super.marshal(dos);
        try {
            this.radioIdentifier.marshal(dos);
            dos.writeShort((short)this.radioNumber);
            dos.writeShort((short)this.encodingScheme);
            dos.writeShort((short)this.tdlType);
            dos.writeInt((int)this.sampleRate);
            dos.writeShort(this.dataLength);
            dos.writeShort(this.samples);
            dos.write(this.data);
            int nrOfBytes = this.dataLength / 8;
            int paddingBytes = nrOfBytes % 4;
            switch (paddingBytes) {
                case 0: {
                    break;
                }
                case 1: {
                    dos.write(0);
                    dos.writeShort(0);
                    break;
                }
                case 2: {
                    dos.writeShort(0);
                    break;
                }
                case 3: {
                    dos.write(0);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void unmarshal(DataInputStream dis) {
        super.unmarshal(dis);
        try {
            this.radioIdentifier.unmarshal(dis);
            this.radioNumber = dis.readUnsignedShort();
            this.encodingScheme = dis.readUnsignedShort();
            this.tdlType = dis.readUnsignedShort();
            this.sampleRate = dis.readInt();
            this.dataLength = dis.readShort();
            this.samples = dis.readShort();
            this.data = new byte[this.dataLength / 8];
            dis.read(this.data);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void marshal(ByteBuffer buff) {
        super.marshal(buff);
        this.radioIdentifier.marshal(buff);
        buff.putShort((short)this.radioNumber);
        buff.putShort((short)this.encodingScheme);
        buff.putShort((short)this.tdlType);
        buff.putInt((int)this.sampleRate);
        buff.putShort(this.dataLength);
        buff.putShort(this.samples);
        buff.put(this.data);
        int nrOfBytes = this.dataLength / 8;
        int paddingBytes = nrOfBytes % 4;
        switch (paddingBytes) {
            case 0: {
                break;
            }
            case 1: {
                buff.put((byte)0);
                buff.putShort((short)0);
                break;
            }
            case 2: {
                buff.putShort((short)0);
                break;
            }
            case 3: {
                buff.put((byte)0);
            }
        }
    }

    @Override
    public void unmarshal(ByteBuffer buff) {
        super.unmarshal(buff);
        this.radioIdentifier.unmarshal(buff);
        this.radioNumber = buff.getShort() & 0xFFFF;
        this.encodingScheme = buff.getShort() & 0xFFFF;
        this.tdlType = buff.getShort() & 0xFFFF;
        this.sampleRate = buff.getInt();
        this.dataLength = buff.getShort();
        this.samples = buff.getShort();
        this.data = new byte[this.dataLength / 8];
        buff.get(this.data);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    @Override
    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof SignalPdu)) {
            return false;
        }
        SignalPdu rhs = (SignalPdu)obj;
        if (!this.radioIdentifier.equals(rhs.radioIdentifier)) {
            ivarsEqual = false;
        }
        if (this.radioNumber != rhs.radioNumber) {
            ivarsEqual = false;
        }
        if (this.encodingScheme != rhs.encodingScheme) {
            ivarsEqual = false;
        }
        if (this.tdlType != rhs.tdlType) {
            ivarsEqual = false;
        }
        if (this.sampleRate != rhs.sampleRate) {
            ivarsEqual = false;
        }
        if (this.dataLength != rhs.dataLength) {
            ivarsEqual = false;
        }
        if (this.samples != rhs.samples) {
            ivarsEqual = false;
        }
        if (!Arrays.equals(this.data, rhs.data)) {
            ivarsEqual = false;
        }
        return ivarsEqual && super.equalsImpl(rhs);
    }
}

