/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.ChangeOptions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class SystemIdentifier
implements Serializable {
    protected int systemType;
    protected int systemName;
    protected int systemMode;
    protected ChangeOptions changeOptions = new ChangeOptions();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 2;
        marshalSize += 2;
        ++marshalSize;
        return marshalSize += this.changeOptions.getMarshalledSize();
    }

    public void setSystemType(int pSystemType) {
        this.systemType = pSystemType;
    }

    public int getSystemType() {
        return this.systemType;
    }

    public void setSystemName(int pSystemName) {
        this.systemName = pSystemName;
    }

    public int getSystemName() {
        return this.systemName;
    }

    public void setSystemMode(int pSystemMode) {
        this.systemMode = pSystemMode;
    }

    public int getSystemMode() {
        return this.systemMode;
    }

    public void setChangeOptions(ChangeOptions pChangeOptions) {
        this.changeOptions = pChangeOptions;
    }

    public ChangeOptions getChangeOptions() {
        return this.changeOptions;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeShort((short)this.systemType);
            dos.writeShort((short)this.systemName);
            dos.writeByte((byte)this.systemMode);
            this.changeOptions.marshal(dos);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.systemType = dis.readUnsignedShort();
            this.systemName = dis.readUnsignedShort();
            this.systemMode = dis.readUnsignedByte();
            this.changeOptions.unmarshal(dis);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putShort((short)this.systemType);
        buff.putShort((short)this.systemName);
        buff.put((byte)this.systemMode);
        this.changeOptions.marshal(buff);
    }

    public void unmarshal(ByteBuffer buff) {
        this.systemType = buff.getShort() & 0xFFFF;
        this.systemName = buff.getShort() & 0xFFFF;
        this.systemMode = buff.get() & 0xFF;
        this.changeOptions.unmarshal(buff);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof SystemIdentifier)) {
            return false;
        }
        SystemIdentifier rhs = (SystemIdentifier)obj;
        if (this.systemType != rhs.systemType) {
            ivarsEqual = false;
        }
        if (this.systemName != rhs.systemName) {
            ivarsEqual = false;
        }
        if (this.systemMode != rhs.systemMode) {
            ivarsEqual = false;
        }
        if (!this.changeOptions.equals(rhs.changeOptions)) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

