/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.EntityID;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class TrackJamData
implements Serializable {
    protected EntityID entityID = new EntityID();
    protected short emitterNumber;
    protected short beamNumber;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.entityID.getMarshalledSize();
        ++marshalSize;
        return ++marshalSize;
    }

    public EntityID getEntityID() {
        return this.entityID;
    }

    public void setEntityID(EntityID pEntityID) {
        this.entityID = pEntityID;
    }

    public short getEmitterNumber() {
        return this.emitterNumber;
    }

    public void setEmitterNumber(short pEmitterNumber) {
        this.emitterNumber = pEmitterNumber;
    }

    public short getBeamNumber() {
        return this.beamNumber;
    }

    public void setBeamNumber(short pBeamNumber) {
        this.beamNumber = pBeamNumber;
    }

    public void marshal(DataOutputStream dos) {
        this.entityID.marshal(dos);
        try {
            dos.writeByte((byte)this.emitterNumber);
            dos.writeByte((byte)this.beamNumber);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.entityID.marshal(buff);
        buff.put((byte)this.emitterNumber);
        buff.put((byte)this.beamNumber);
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.entityID.unmarshal(dis);
            this.emitterNumber = (short)dis.readUnsignedShort();
            this.beamNumber = (short)dis.readUnsignedShort();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void unmarshal(ByteBuffer buff) {
        this.entityID.unmarshal(buff);
        this.emitterNumber = (short)(buff.get() & 0xFF);
        this.beamNumber = (short)(buff.get() & 0xFF);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof TrackJamData)) {
            return false;
        }
        TrackJamData rhs = (TrackJamData)obj;
        if (!this.entityID.equals(rhs.entityID)) {
            ivarsEqual = false;
        }
        if (this.emitterNumber != rhs.emitterNumber) {
            ivarsEqual = false;
        }
        if (this.beamNumber != rhs.beamNumber) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

