/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import edu.nps.moves.dis7.SimulationAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class UnattachedIdentifier
implements Serializable {
    protected SimulationAddress simulationAddress = new SimulationAddress();
    protected int referenceNumber;

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += this.simulationAddress.getMarshalledSize();
        return marshalSize += 2;
    }

    public void setSimulationAddress(SimulationAddress pSimulationAddress) {
        this.simulationAddress = pSimulationAddress;
    }

    public SimulationAddress getSimulationAddress() {
        return this.simulationAddress;
    }

    public void setReferenceNumber(int pReferenceNumber) {
        this.referenceNumber = pReferenceNumber;
    }

    public int getReferenceNumber() {
        return this.referenceNumber;
    }

    public void marshal(DataOutputStream dos) {
        try {
            this.simulationAddress.marshal(dos);
            dos.writeShort((short)this.referenceNumber);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.simulationAddress.unmarshal(dis);
            this.referenceNumber = dis.readUnsignedShort();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        this.simulationAddress.marshal(buff);
        buff.putShort((short)this.referenceNumber);
    }

    public void unmarshal(ByteBuffer buff) {
        this.simulationAddress.unmarshal(buff);
        this.referenceNumber = buff.getShort() & 0xFFFF;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof UnattachedIdentifier)) {
            return false;
        }
        UnattachedIdentifier rhs = (UnattachedIdentifier)obj;
        if (!this.simulationAddress.equals(rhs.simulationAddress)) {
            ivarsEqual = false;
        }
        if (this.referenceNumber != rhs.referenceNumber) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

