/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.dis7;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class VariableDatum
implements Serializable {
    protected long variableDatumID;
    protected long variableDatumLength;
    private byte[] payload = EMPTY;
    private byte[] padding = EMPTY;
    private static final byte[] EMPTY = new byte[0];

    public VariableDatum() {
    }

    public VariableDatum(long id, double d) {
        this.variableDatumID = id;
        this.setPayload(d);
    }

    public VariableDatum(long id, long l) {
        this.variableDatumID = id;
        this.setPayload(l);
    }

    public VariableDatum(long id, String s) {
        this.variableDatumID = id;
        this.setPayload(s);
    }

    public VariableDatum(long id, byte[] payload) {
        this.variableDatumID = id;
        this.setPayload(payload);
    }

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 4;
        marshalSize += 4;
        marshalSize += this.payload.length;
        return marshalSize += this.padding.length;
    }

    public void setVariableDatumID(long pVariableDatumID) {
        this.variableDatumID = pVariableDatumID;
    }

    public long getVariableDatumID() {
        return this.variableDatumID;
    }

    public long getVariableDatumLength() {
        return this.variableDatumLength;
    }

    public void setVariableDatumLength(long pVariableDatumLength) {
        this.variableDatumLength = pVariableDatumLength;
    }

    public void setVariableData(byte[] pVariableData) {
        this.setPayload(pVariableData);
    }

    public byte[] getVariableData() {
        return this.getPayload();
    }

    public double getPayloadAsDouble() {
        return Double.longBitsToDouble(this.getPayloadAsLong());
    }

    public long getPayloadAsLong() {
        return ((long)this.payload[0] << 56) + ((long)(this.payload[1] & 0xFF) << 48) + ((long)(this.payload[2] & 0xFF) << 40) + ((long)(this.payload[3] & 0xFF) << 32) + ((long)(this.payload[4] & 0xFF) << 24) + (long)((this.payload[5] & 0xFF) << 16) + (long)((this.payload[6] & 0xFF) << 8) + (long)(this.payload[7] & 0xFF);
    }

    public String getPayloadAsString() {
        return new String(this.payload);
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public final boolean setPayload(double d) {
        return this.setPayload(Double.doubleToRawLongBits(d));
    }

    public final boolean setPayload(long l) {
        byte[] bytes = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        return this.setPayload(bytes);
    }

    public final boolean setPayload(String s) {
        if (s != null) {
            return this.setPayload(s.getBytes(Charset.forName("US-ASCII")));
        }
        return false;
    }

    public final boolean setPayload(byte[] payload) {
        if (payload != null) {
            return this.setPayload(payload, payload.length * 8);
        }
        return false;
    }

    public final boolean setPayload(byte[] payload, long lengthBits) {
        if (payload != null) {
            int payloadBits = payload.length * 8;
            if (lengthBits >= 0L && lengthBits <= (long)payloadBits && lengthBits > (long)(payloadBits - 8)) {
                this.payload = payload;
                this.variableDatumLength = lengthBits;
                this.padding = VariableDatum.createPadding(payload.length);
                return true;
            }
        }
        return false;
    }

    private static byte[] createPadding(int payloadBytes) {
        int mod = payloadBytes % 8;
        if (mod != 0) {
            return new byte[8 - mod];
        }
        return EMPTY;
    }

    public void marshal(DataOutputStream dos) {
        try {
            dos.writeInt((int)this.variableDatumID);
            dos.writeInt((int)this.getVariableDatumLength());
            dos.write(this.payload);
            dos.write(this.padding);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void unmarshal(DataInputStream dis) {
        try {
            this.variableDatumID = dis.readInt();
            this.variableDatumLength = dis.readInt();
            int payloadBytes = (int)(this.variableDatumLength / 8L);
            this.payload = new byte[payloadBytes];
            dis.read(this.payload);
            this.padding = VariableDatum.createPadding(payloadBytes);
            dis.read(this.padding);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void marshal(ByteBuffer buff) {
        buff.putInt((int)this.variableDatumID);
        buff.putInt((int)this.getVariableDatumLength());
        buff.put(this.payload);
        buff.put(this.padding);
    }

    public void unmarshal(ByteBuffer buff) {
        this.variableDatumID = buff.getInt();
        this.variableDatumLength = buff.getInt();
        int payloadBytes = (int)(this.variableDatumLength / 8L);
        if (this.variableDatumLength % 8L > 0L) {
            ++payloadBytes;
        }
        this.payload = new byte[payloadBytes];
        buff.get(this.payload);
        this.padding = VariableDatum.createPadding(payloadBytes);
        buff.get(this.padding);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        boolean ivarsEqual = true;
        if (!(obj instanceof VariableDatum)) {
            return false;
        }
        VariableDatum rhs = (VariableDatum)obj;
        if (this.variableDatumID != rhs.variableDatumID) {
            ivarsEqual = false;
        }
        if (this.variableDatumLength != rhs.variableDatumLength) {
            ivarsEqual = false;
        }
        if (!Arrays.equals(this.payload, rhs.payload)) {
            ivarsEqual = false;
        }
        if (!Arrays.equals(this.padding, rhs.padding)) {
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

