/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.disutil;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class BasicHaveQuickMpRecord {
    short mwodIndex;
    int timeOfDay;
    int netIdNetNumber;
    int netIdFrequencyTable;
    int netIdMode;

    public int getMarshalledSize() {
        return 16;
    }

    public short getMwodIndex() {
        return this.mwodIndex;
    }

    public int getTimeOfDay() {
        return this.timeOfDay;
    }

    public int getNetIdNetNumber() {
        return this.netIdNetNumber;
    }

    public int getNetIdFrequencyTable() {
        return this.netIdFrequencyTable;
    }

    public int getNetIdMode() {
        return this.netIdMode;
    }

    public void setMwodIndex(short mwodIndex) {
        this.mwodIndex = mwodIndex;
    }

    public void setTimeOfDay(int timeOfDay) {
        this.timeOfDay = timeOfDay;
    }

    public void setNetIdNetNumber(int netIdNetNumber) {
        this.netIdNetNumber = netIdNetNumber;
    }

    public void setNetIdFrequencyTable(int netIdFrequencyTable) {
        this.netIdFrequencyTable = netIdFrequencyTable;
    }

    public void setNetIdMode(int netIdMode) {
        this.netIdMode = netIdMode;
    }

    public void unmarshal(List<Short> modulationParmeters) {
        ByteBuffer bb = ByteBuffer.allocate(modulationParmeters.size() * 2);
        for (Short s : modulationParmeters) {
            bb.putShort(s);
        }
        bb.rewind();
        this.unmarshal(bb);
    }

    public List<Short> marshal() {
        ByteBuffer bb = ByteBuffer.allocate(this.getMarshalledSize());
        this.marshal(bb);
        bb.rewind();
        ArrayList<Short> modulationParameters = new ArrayList<Short>();
        for (int i = 0; i < this.getMarshalledSize() / 2; ++i) {
            Short s = bb.getShort();
            modulationParameters.add(s);
        }
        return modulationParameters;
    }

    private void marshal(ByteBuffer bb) {
        short netIdRecord = 0;
        netIdRecord = (short)(netIdRecord | this.netIdMode << 11);
        netIdRecord = (short)(netIdRecord | this.netIdFrequencyTable << 9);
        netIdRecord = (short)(netIdRecord | this.netIdNetNumber);
        bb.putShort(netIdRecord);
        bb.putShort(this.mwodIndex);
        bb.putShort((short)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.putInt(this.timeOfDay);
        bb.putInt(0);
    }

    private void unmarshal(ByteBuffer bb) {
        short haveQuickNetIdRecord = bb.getShort();
        this.mwodIndex = bb.getShort();
        short haveQuickReserved1 = bb.getShort();
        Byte haveQuickReserved2 = bb.get();
        Byte haveQuickReserved3 = bb.get();
        this.timeOfDay = bb.getInt();
        int haveQuickPadding = bb.getInt();
        this.netIdNetNumber = haveQuickNetIdRecord & 0x3FF;
        this.netIdFrequencyTable = haveQuickNetIdRecord >> 10 & 3;
        this.netIdMode = haveQuickNetIdRecord >> 12 & 3;
        int haveQuickNetIdPadding = haveQuickNetIdRecord >> 14 & 3;
    }
}

