/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.disutil;

import java.util.GregorianCalendar;

public class DisTime {
    public static final int ABSOLUTE_TIMESTAMP_MASK = 1;
    public static final int RELATIVE_TIMESTAMP_MASK = -2;
    protected GregorianCalendar cal = new GregorianCalendar();
    public static DisTime disTime = null;

    public static DisTime getInstance() {
        if (disTime == null) {
            disTime = new DisTime();
        }
        return disTime;
    }

    private int getDisTimeUnitsSinceTopOfHour() {
        long currentTime = System.currentTimeMillis();
        this.cal.setTimeInMillis(currentTime);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        this.cal.set(14, 0);
        long topOfHour = this.cal.getTimeInMillis();
        long diff = currentTime - topOfHour;
        double val = (double)diff / 3600000.0 * 2.147483647E9;
        int ts = (int)val;
        return ts;
    }

    public int getDisAbsoluteTimestamp() {
        int val = this.getDisTimeUnitsSinceTopOfHour();
        val = val << 1 | 1;
        return val;
    }

    public int getDisRelativeTimestamp() {
        int val = this.getDisTimeUnitsSinceTopOfHour();
        val = val << 1 & 0xFFFFFFFE;
        return val;
    }

    public long getNpsTimestamp() {
        long currentTime = System.currentTimeMillis();
        this.cal.setTimeInMillis(currentTime);
        this.cal.set(2, 0);
        this.cal.set(5, 1);
        this.cal.set(10, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        this.cal.set(14, 0);
        long startOfYear = this.cal.getTimeInMillis();
        long diff = currentTime - startOfYear;
        return diff /= 10L;
    }

    public long getUnixTimestamp() {
        long t = System.currentTimeMillis();
        return t /= 1000L;
    }
}

