/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.disutil;

import edu.nps.moves.dis.AcknowledgePdu;
import edu.nps.moves.dis.AcknowledgeReliablePdu;
import edu.nps.moves.dis.ActionRequestPdu;
import edu.nps.moves.dis.ActionRequestReliablePdu;
import edu.nps.moves.dis.ActionResponsePdu;
import edu.nps.moves.dis.ActionResponseReliablePdu;
import edu.nps.moves.dis.AggregateStatePdu;
import edu.nps.moves.dis.ArealObjectStatePdu;
import edu.nps.moves.dis.CollisionElasticPdu;
import edu.nps.moves.dis.CollisionPdu;
import edu.nps.moves.dis.CommentPdu;
import edu.nps.moves.dis.CommentReliablePdu;
import edu.nps.moves.dis.CreateEntityPdu;
import edu.nps.moves.dis.CreateEntityReliablePdu;
import edu.nps.moves.dis.DataPdu;
import edu.nps.moves.dis.DataQueryPdu;
import edu.nps.moves.dis.DataQueryReliablePdu;
import edu.nps.moves.dis.DataReliablePdu;
import edu.nps.moves.dis.DesignatorPdu;
import edu.nps.moves.dis.DetonationPdu;
import edu.nps.moves.dis.ElectronicEmissionsPdu;
import edu.nps.moves.dis.EntityStatePdu;
import edu.nps.moves.dis.EntityStateUpdatePdu;
import edu.nps.moves.dis.EnvironmentalProcessPdu;
import edu.nps.moves.dis.EventReportPdu;
import edu.nps.moves.dis.EventReportReliablePdu;
import edu.nps.moves.dis.FirePdu;
import edu.nps.moves.dis.GriddedDataPdu;
import edu.nps.moves.dis.IffAtcNavAidsLayer1Pdu;
import edu.nps.moves.dis.IntercomControlPdu;
import edu.nps.moves.dis.IntercomSignalPdu;
import edu.nps.moves.dis.IsGroupOfPdu;
import edu.nps.moves.dis.IsPartOfPdu;
import edu.nps.moves.dis.LinearObjectStatePdu;
import edu.nps.moves.dis.MinefieldDataPdu;
import edu.nps.moves.dis.MinefieldQueryPdu;
import edu.nps.moves.dis.MinefieldResponseNackPdu;
import edu.nps.moves.dis.MinefieldStatePdu;
import edu.nps.moves.dis.Pdu;
import edu.nps.moves.dis.PointObjectStatePdu;
import edu.nps.moves.dis.ReceiverPdu;
import edu.nps.moves.dis.RecordQueryReliablePdu;
import edu.nps.moves.dis.RemoveEntityPdu;
import edu.nps.moves.dis.RemoveEntityReliablePdu;
import edu.nps.moves.dis.RepairCompletePdu;
import edu.nps.moves.dis.RepairResponsePdu;
import edu.nps.moves.dis.ResupplyCancelPdu;
import edu.nps.moves.dis.ResupplyOfferPdu;
import edu.nps.moves.dis.ResupplyReceivedPdu;
import edu.nps.moves.dis.SeesPdu;
import edu.nps.moves.dis.ServiceRequestPdu;
import edu.nps.moves.dis.SetDataPdu;
import edu.nps.moves.dis.SetDataReliablePdu;
import edu.nps.moves.dis.SetRecordReliablePdu;
import edu.nps.moves.dis.SignalPdu;
import edu.nps.moves.dis.StartResumePdu;
import edu.nps.moves.dis.StartResumeReliablePdu;
import edu.nps.moves.dis.StopFreezePdu;
import edu.nps.moves.dis.StopFreezeReliablePdu;
import edu.nps.moves.dis.TransferControlRequestPdu;
import edu.nps.moves.dis.TransmitterPdu;
import edu.nps.moves.dis.UaPdu;
import edu.nps.moves.disenum.PduType;
import edu.nps.moves.disutil.ExperimentalPdu;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PduFactory {
    private Logger logger = Logger.getLogger(PduFactory.class.getName());

    public PduFactory() {
        this.logger.setLevel(Level.OFF);
    }

    public void setLoggingLevel(Level loggingLevel) {
        this.logger.setLevel(loggingLevel);
    }

    public Pdu createPdu(byte[] data) {
        return this.createPdu(ByteBuffer.wrap(data));
    }

    public Pdu createPdu(ByteBuffer buff) {
        int pduType = PduFactory.peekAtPduType(buff);
        if (pduType == -1) {
            return null;
        }
        Pdu aPdu = null;
        if (pduType < 129) {
            PduType pduTypeEnum = PduType.lookup[pduType];
            switch (pduTypeEnum) {
                case ENTITY_STATE: {
                    aPdu = new EntityStatePdu();
                    break;
                }
                case FIRE: {
                    aPdu = new FirePdu();
                    break;
                }
                case DETONATION: {
                    aPdu = new DetonationPdu();
                    break;
                }
                case COLLISION: {
                    aPdu = new CollisionPdu();
                    break;
                }
                case SERVICE_REQUEST: {
                    aPdu = new ServiceRequestPdu();
                    break;
                }
                case RESUPPLY_OFFER: {
                    aPdu = new ResupplyOfferPdu();
                    break;
                }
                case RESUPPLY_RECEIVED: {
                    aPdu = new ResupplyReceivedPdu();
                    break;
                }
                case RESUPPLY_CANCEL: {
                    aPdu = new ResupplyCancelPdu();
                    break;
                }
                case REPAIR_COMPLETE: {
                    aPdu = new RepairCompletePdu();
                    break;
                }
                case REPAIR_RESPONSE: {
                    aPdu = new RepairResponsePdu();
                    break;
                }
                case CREATE_ENTITY: {
                    aPdu = new CreateEntityPdu();
                    break;
                }
                case REMOVE_ENTITY: {
                    aPdu = new RemoveEntityPdu();
                    break;
                }
                case START_RESUME: {
                    aPdu = new StartResumePdu();
                    break;
                }
                case STOP_FREEZE: {
                    aPdu = new StopFreezePdu();
                    break;
                }
                case ACKNOWLEDGE: {
                    aPdu = new AcknowledgePdu();
                    break;
                }
                case ACTION_REQUEST: {
                    aPdu = new ActionRequestPdu();
                    break;
                }
                case ACTION_RESPONSE: {
                    aPdu = new ActionResponsePdu();
                    break;
                }
                case DATA_QUERY: {
                    aPdu = new DataQueryPdu();
                    break;
                }
                case SET_DATA: {
                    aPdu = new SetDataPdu();
                    break;
                }
                case DATA: {
                    aPdu = new DataPdu();
                    break;
                }
                case EVENT_REPORT: {
                    aPdu = new EventReportPdu();
                    break;
                }
                case COMMENT: {
                    aPdu = new CommentPdu();
                    break;
                }
                case ELECTROMAGNETIC_EMISSION: {
                    aPdu = new ElectronicEmissionsPdu();
                    break;
                }
                case DESIGNATOR: {
                    aPdu = new DesignatorPdu();
                    break;
                }
                case TRANSMITTER: {
                    aPdu = new TransmitterPdu();
                    break;
                }
                case SIGNAL: {
                    aPdu = new SignalPdu();
                    break;
                }
                case RECEIVER: {
                    aPdu = new ReceiverPdu();
                    break;
                }
                case UNDERWATER_ACOUSTIC: {
                    aPdu = new UaPdu();
                    break;
                }
                case SUPPLEMENTAL_EMISSION_ENTITY_STATE: {
                    aPdu = new SeesPdu();
                    break;
                }
                case INTERCOM_SIGNAL: {
                    aPdu = new IntercomSignalPdu();
                    break;
                }
                case INTERCOM_CONTROL: {
                    aPdu = new IntercomControlPdu();
                    break;
                }
                case AGGREGATE_STATE: {
                    aPdu = new AggregateStatePdu();
                    break;
                }
                case ISGROUPOF: {
                    aPdu = new IsGroupOfPdu();
                    break;
                }
                case TRANSFER_CONTROL: {
                    aPdu = new TransferControlRequestPdu();
                    break;
                }
                case ISPARTOF: {
                    aPdu = new IsPartOfPdu();
                    break;
                }
                case MINEFIELD_STATE: {
                    aPdu = new MinefieldStatePdu();
                    break;
                }
                case MINEFIELD_QUERY: {
                    aPdu = new MinefieldQueryPdu();
                    break;
                }
                case MINEFIELD_DATA: {
                    aPdu = new MinefieldDataPdu();
                    break;
                }
                case MINEFIELD_RESPONSE_NAK: {
                    aPdu = new MinefieldResponseNackPdu();
                    break;
                }
                case ENVIRONMENTAL_PROCESS: {
                    aPdu = new EnvironmentalProcessPdu();
                    break;
                }
                case GRIDDED_DATA: {
                    aPdu = new GriddedDataPdu();
                    break;
                }
                case POINT_OBJECT_STATE: {
                    aPdu = new PointObjectStatePdu();
                    break;
                }
                case LINEAR_OBJECT_STATE: {
                    aPdu = new LinearObjectStatePdu();
                    break;
                }
                case AREAL_OBJECT_STATE: {
                    aPdu = new ArealObjectStatePdu();
                    break;
                }
                case CREATE_ENTITY_R: {
                    aPdu = new CreateEntityReliablePdu();
                    break;
                }
                case REMOVE_ENTITY_R: {
                    aPdu = new RemoveEntityReliablePdu();
                    break;
                }
                case START_RESUME_R: {
                    aPdu = new StartResumeReliablePdu();
                    break;
                }
                case STOP_FREEZE_R: {
                    aPdu = new StopFreezeReliablePdu();
                    break;
                }
                case ACKNOWLEDGE_R: {
                    aPdu = new AcknowledgeReliablePdu();
                    break;
                }
                case ACTION_REQUEST_R: {
                    aPdu = new ActionRequestReliablePdu();
                    break;
                }
                case ACTION_RESPONSE_R: {
                    aPdu = new ActionResponseReliablePdu();
                    break;
                }
                case DATA_QUERY_R: {
                    aPdu = new DataQueryReliablePdu();
                    break;
                }
                case SET_DATA_R: {
                    aPdu = new SetDataReliablePdu();
                    break;
                }
                case DATA_R: {
                    aPdu = new DataReliablePdu();
                    break;
                }
                case EVENT_REPORT_R: {
                    aPdu = new EventReportReliablePdu();
                    break;
                }
                case COMMENT_R: {
                    aPdu = new CommentReliablePdu();
                    break;
                }
                case SET_RECORD_R: {
                    aPdu = new SetRecordReliablePdu();
                    break;
                }
                case RECORD_QUERY_R: {
                    aPdu = new RecordQueryReliablePdu();
                    break;
                }
                case COLLISION_ELASTIC: {
                    aPdu = new CollisionElasticPdu();
                    break;
                }
                case ENTITY_STATE_UPDATE: {
                    aPdu = new EntityStateUpdatePdu();
                    break;
                }
                case IFF_ATC_NAVAIDS: {
                    aPdu = new IffAtcNavAidsLayer1Pdu();
                    break;
                }
                default: {
                    this.logger.log(Level.INFO, "PDU not implemented. Type = " + pduType + "\n");
                    if (pduTypeEnum != null) {
                        this.logger.log(Level.INFO, "  PDU  name is: " + pduTypeEnum.getDescription());
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            this.logger.log(Level.INFO, "Received experimental PDU Type " + pduType + ". Not supported.");
            aPdu = new ExperimentalPdu();
        }
        if (aPdu != null) {
            ((Pdu)aPdu).unmarshal(buff);
        }
        return aPdu;
    }

    /*
     * Exception decompiling
     */
    public List<Pdu> getPdusFromBundle(byte[] data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 3[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int peekAtPduType(ByteBuffer buff) {
        int pos = buff.position();
        if (pos + 2 > buff.limit()) {
            return -1;
        }
        buff.position(pos + 2);
        int pduType = Pdu.toUnsignedInt(buff.get());
        buff.position(pos);
        return pduType;
    }
}

