/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.disutil;

import edu.nps.moves.dis.Pdu;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class PduStream
implements Serializable {
    protected byte[] shortDescription = new byte[256];
    protected byte[] longDescription = new byte[512];
    protected byte[] personRecording = new byte[128];
    protected byte[] authorEmail = new byte[128];
    protected long startTime;
    protected long stopTime;
    protected long pduCount;
    protected List<Pdu> pdusInStream = new ArrayList<Pdu>();

    public int getMarshalledSize() {
        int marshalSize = 0;
        marshalSize += 256;
        marshalSize += 512;
        marshalSize += 128;
        marshalSize += 128;
        marshalSize += 8;
        marshalSize += 8;
        marshalSize += 4;
        for (int idx = 0; idx < this.pdusInStream.size(); ++idx) {
            Pdu listElement = this.pdusInStream.get(idx);
            marshalSize += listElement.getMarshalledSize();
        }
        return marshalSize;
    }

    public void setShortDescription(byte[] pShortDescription) {
        this.shortDescription = pShortDescription;
    }

    public byte[] getShortDescription() {
        return this.shortDescription;
    }

    public void setLongDescription(byte[] pLongDescription) {
        this.longDescription = pLongDescription;
    }

    public byte[] getLongDescription() {
        return this.longDescription;
    }

    public void setPersonRecording(byte[] pPersonRecording) {
        this.personRecording = pPersonRecording;
    }

    public byte[] getPersonRecording() {
        return this.personRecording;
    }

    public void setAuthorEmail(byte[] pAuthorEmail) {
        this.authorEmail = pAuthorEmail;
    }

    public byte[] getAuthorEmail() {
        return this.authorEmail;
    }

    public void setStartTime(long pStartTime) {
        this.startTime = pStartTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStopTime(long pStopTime) {
        this.stopTime = pStopTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public long getPduCount() {
        return this.pdusInStream.size();
    }

    public void setPduCount(long pPduCount) {
        this.pduCount = pPduCount;
    }

    public void setPdusInStream(List<Pdu> pPdusInStream) {
        this.pdusInStream = pPdusInStream;
    }

    public List<Pdu> getPdusInStream() {
        return this.pdusInStream;
    }

    public void marshal(ByteBuffer buff) {
        int idx;
        for (idx = 0; idx < this.shortDescription.length; ++idx) {
            buff.put(this.shortDescription[idx]);
        }
        for (idx = 0; idx < this.longDescription.length; ++idx) {
            buff.put(this.longDescription[idx]);
        }
        for (idx = 0; idx < this.personRecording.length; ++idx) {
            buff.put(this.personRecording[idx]);
        }
        for (idx = 0; idx < this.authorEmail.length; ++idx) {
            buff.put(this.authorEmail[idx]);
        }
        buff.putLong(this.startTime);
        buff.putLong(this.stopTime);
        buff.putInt(this.pdusInStream.size());
        for (idx = 0; idx < this.pdusInStream.size(); ++idx) {
            Pdu aPdu = this.pdusInStream.get(idx);
            aPdu.marshal(buff);
        }
    }

    public void unmarshal(ByteBuffer buff) {
        int idx;
        for (idx = 0; idx < this.shortDescription.length; ++idx) {
            this.shortDescription[idx] = buff.get();
        }
        for (idx = 0; idx < this.longDescription.length; ++idx) {
            this.longDescription[idx] = buff.get();
        }
        for (idx = 0; idx < this.personRecording.length; ++idx) {
            this.personRecording[idx] = buff.get();
        }
        for (idx = 0; idx < this.authorEmail.length; ++idx) {
            this.authorEmail[idx] = buff.get();
        }
        this.startTime = buff.getLong();
        this.stopTime = buff.getLong();
        this.pduCount = buff.getInt();
        idx = 0;
        while ((long)idx < this.pduCount) {
            Pdu anX = new Pdu();
            anX.unmarshal(buff);
            this.pdusInStream.add(anX);
            ++idx;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsImpl(obj);
    }

    public boolean equalsImpl(Object obj) {
        int idx;
        boolean ivarsEqual = true;
        if (!(obj instanceof PduStream)) {
            return false;
        }
        PduStream rhs = (PduStream)obj;
        for (idx = 0; idx < 256; ++idx) {
            if (this.shortDescription[idx] == rhs.shortDescription[idx]) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < 512; ++idx) {
            if (this.longDescription[idx] == rhs.longDescription[idx]) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < 128; ++idx) {
            if (this.personRecording[idx] == rhs.personRecording[idx]) continue;
            ivarsEqual = false;
        }
        for (idx = 0; idx < 128; ++idx) {
            if (this.authorEmail[idx] == rhs.authorEmail[idx]) continue;
            ivarsEqual = false;
        }
        if (this.startTime != rhs.startTime) {
            ivarsEqual = false;
        }
        if (this.stopTime != rhs.stopTime) {
            ivarsEqual = false;
        }
        if (this.pduCount != rhs.pduCount) {
            ivarsEqual = false;
        }
        for (idx = 0; idx < this.pdusInStream.size(); ++idx) {
            if (this.pdusInStream.get(idx).equals(rhs.pdusInStream.get(idx))) continue;
            ivarsEqual = false;
        }
        return ivarsEqual;
    }
}

