/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.examples;

import edu.nps.moves.dis.EntityID;
import edu.nps.moves.dis.EntityStatePdu;
import edu.nps.moves.dis.EntityType;
import edu.nps.moves.dis.Marking;
import edu.nps.moves.dis.Vector3Double;
import edu.nps.moves.disutil.CoordinateConversions;
import edu.nps.moves.disutil.DisConnection;
import edu.nps.moves.disutil.DisTime;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;

public class EspduSender {
    public static final String DEFAULT_MULTICAST_GROUP = "239.1.2.3";
    public static final int DIS_PORT = 3000;
    public static final int DIS_HEARTBEAT_SECS = 10;

    public static void main(String[] args) throws UnknownHostException, IOException, RuntimeException, InterruptedException {
        DisConnection con = new DisConnection(DEFAULT_MULTICAST_GROUP, 3000);
        EntityStatePdu espdu = new EntityStatePdu();
        espdu.setExerciseID((short)1);
        EntityID entityID = espdu.getEntityID();
        entityID.setSite(1);
        entityID.setApplication(1);
        entityID.setEntity(2);
        EntityType entityType = espdu.getEntityType();
        entityType.setEntityKind((short)1);
        entityType.setCountry(225);
        entityType.setDomain((short)1);
        entityType.setCategory((short)1);
        entityType.setSubcategory((short)1);
        entityType.setSpec((short)3);
        Marking m = new Marking();
        m.setCharactersString("T11");
        espdu.setMarking(m);
        DisTime disTime = DisTime.getInstance();
        double lat = 36.595517;
        double lon = -121.877;
        int NUMBER_PDU_TO_SEND = 100;
        System.out.println("This example will send 100 Entity State PDU packets to 239.1.2.3. One packet every 10 seconds.");
        for (int idx = 0; idx < 100; ++idx) {
            int timestamp = disTime.getDisAbsoluteTimestamp();
            espdu.setTimestamp(timestamp);
            double[] disCoordinates = CoordinateConversions.getXYZfromLatLonDegrees(lat, lon, 1.0);
            Vector3Double location = espdu.getEntityLocation();
            location.setX(disCoordinates[0]);
            location.setY(disCoordinates[1]);
            location.setZ(disCoordinates[2]);
            con.send(espdu);
            System.out.println("Sent Entity State PDU #" + idx);
            System.out.println(" Id (Site,App,Id): [" + espdu.getEntityID().getSite() + ", " + espdu.getEntityID().getApplication() + ", " + espdu.getEntityID().getEntity() + "]");
            System.out.println(" Marking: " + espdu.getMarking().getCharactersString());
            System.out.println(" Location (X,Y,Z): [" + espdu.getEntityLocation().getX() + ", " + espdu.getEntityLocation().getY() + ", " + espdu.getEntityLocation().getZ() + "]");
            double[] lla = CoordinateConversions.xyzToLatLonDegrees(espdu.getEntityLocation().toArray());
            System.out.println(" Location (Lat,Lon,Alt): [" + lla[0] + ", " + lla[1] + ", " + lla[2] + "]");
            System.out.println("Sleeping for heartbeat of 10 seconds.");
            Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
        }
    }
}

