/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.logger;

import edu.nps.moves.dis.Pdu;
import edu.nps.moves.disutil.PduFactory;
import edu.nps.moves.logger.LogWriter;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Properties;

public class DisLogger
implements Runnable {
    public static final int MAX_PDU_SIZE = 2048;
    public static final int MAX_PDU_LOGFILE_SIZE = 100;
    public static final int READ_TIMEOUT = 5000;
    private int pdusPerFile;
    private InetAddress multicastGroup;
    private int port;
    private String exerciseName;
    private MulticastSocket socket;
    private boolean done = false;
    private LogWriter logWriter;

    public void setDone() {
        this.done = true;
    }

    public DisLogger(Properties loggerProperties) {
        String stringMulticastGroup = loggerProperties.getProperty("multicastGroup");
        String stringPort = loggerProperties.getProperty("port");
        this.exerciseName = loggerProperties.getProperty("exerciseName");
        String stringPdusPerFile = loggerProperties.getProperty("pdusPerFile");
        System.out.println("Multicast group: " + stringMulticastGroup + " port:" + stringPort + " exerciseName: " + this.exerciseName);
        try {
            this.port = Integer.parseInt(stringPort);
            this.pdusPerFile = Integer.parseInt(stringPdusPerFile);
            this.multicastGroup = InetAddress.getByName(stringMulticastGroup);
            if (!this.multicastGroup.isMulticastAddress()) {
                System.out.println("The address " + stringMulticastGroup + " is not a multicast address");
                System.exit(0);
            }
            this.socket = new MulticastSocket(this.port);
            this.socket.setSoTimeout(5000);
            this.socket.joinGroup(this.multicastGroup);
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Format error in the properties file. Make sure the port number is an integer and ");
            System.out.println("that the multicast address is in the correct format");
        }
    }

    @Override
    public void run() {
        PduFactory pduFactory = new PduFactory();
        ArrayList<Pdu> currentPduList = new ArrayList<Pdu>(100);
        boolean timedout = false;
        int count = 0;
        if (this.logWriter == null) {
            this.logWriter = new LogWriter(this.exerciseName);
            Thread writerThread = new Thread(this.logWriter);
            writerThread.setDaemon(false);
            writerThread.start();
            Thread.yield();
        }
        System.out.println("Starting to listen for PDUs");
        while (!this.done) {
            byte[] buffer = new byte[2048];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                byte[] pduBytes;
                Pdu pdu;
                try {
                    this.socket.receive(packet);
                    this.logWriter.setUnqueuedPdus(true);
                    ++count;
                }
                catch (SocketTimeoutException ste) {
                    timedout = true;
                }
                if (!timedout && (pdu = pduFactory.createPdu(pduBytes = packet.getData())) != null) {
                    currentPduList.add(pdu);
                }
                if (currentPduList.size() > this.pdusPerFile || this.done) {
                    ArrayList<Pdu> pdusToLog = currentPduList;
                    currentPduList = new ArrayList();
                    this.logWriter.addListToWriteQueue(pdusToLog);
                    this.logWriter.setUnqueuedPdus(false);
                    Thread.yield();
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
            timedout = false;
        }
        System.out.println("PDUs captured: " + count);
    }

    public boolean finishedWriting() {
        if (!this.done) {
            return false;
        }
        return this.logWriter.finishedWriting();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: DisLogger propertyFile");
            System.exit(0);
        }
        System.out.println("Properties file=" + args[0]);
        try {
            Properties loggerProperties = new Properties();
            InputStream propsFile = DisLogger.class.getResourceAsStream(args[0]);
            loggerProperties.load(propsFile);
            System.out.println("loaded properties file");
            DisLogger logger = new DisLogger(loggerProperties);
            Thread loggerThread = new Thread(logger);
            loggerThread.setDaemon(false);
            loggerThread.start();
            Thread.sleep(100000L);
            logger.setDone();
            Thread.sleep(1000L);
            while (!logger.finishedWriting()) {
                Thread.yield();
            }
        }
        catch (Exception e) {
            System.out.println("File not found; check to make sure properties file exists");
            System.out.println(e);
        }
        System.out.println("exiting main thread of logger");
    }
}

