/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.logger;

import edu.nps.moves.dis.Pdu;
import edu.nps.moves.logger.DisLogger;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.List;
import java.util.Properties;

public class LogReplay {
    public static final int MIN_SLEEP_TIME = 2;
    private int port;
    private InetAddress multicastGroup;
    private MulticastSocket socket;
    private String exerciseName;
    private Properties configuration;
    private long timeLastSent = 0L;
    private int count = 0;

    public LogReplay(Properties properties) {
        this.configuration = properties;
        try {
            this.exerciseName = properties.getProperty("exerciseName");
            this.port = Integer.parseInt(properties.getProperty("port"));
            this.multicastGroup = InetAddress.getByName(properties.getProperty("multicastGroup"));
            if (!this.multicastGroup.isMulticastAddress()) {
                System.out.println("The address " + properties.getProperty("multicastGroup") + " is not a multicast address");
                System.exit(0);
            }
            this.socket = new MulticastSocket(this.port);
            this.socket.joinGroup(this.multicastGroup);
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Format error in the properties file. Make sure the port number is an integer and ");
            System.out.println("that the multicast address is in the correct format");
        }
    }

    public void replayExercise() {
        try {
            File exerciseDirectory = new File(this.exerciseName);
            if (!exerciseDirectory.isDirectory()) {
                System.out.println("not a directory");
                System.exit(0);
            }
            String[] logFiles = exerciseDirectory.list();
            for (int idx = 0; idx < logFiles.length; ++idx) {
                System.out.println("Log file being replayed: " + logFiles[idx]);
                String fileName = logFiles[idx];
                if (!fileName.startsWith(this.exerciseName + "_")) continue;
                fileName = this.exerciseName + "/" + fileName;
            }
            System.out.println("Pdus sent: " + this.count);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void replayList(List pduList) {
        for (int idx = 0; idx < pduList.size(); ++idx) {
            Pdu nextPdu;
            long nextTime;
            long difference;
            Pdu aPdu = (Pdu)pduList.get(idx);
            long timestamp = aPdu.getTimestamp();
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                aPdu.marshal(dos);
                byte[] ieeeData = baos.toByteArray();
                DatagramPacket packet = new DatagramPacket(ieeeData, ieeeData.length, this.multicastGroup, this.port);
                this.socket.send(packet);
                ++this.count;
            }
            catch (Exception e) {
                System.out.println(e);
            }
            if (idx + 1 >= pduList.size() || (difference = (nextTime = (nextPdu = (Pdu)pduList.get(idx + 1)).getTimestamp()) - timestamp) <= 2L) continue;
            try {
                Thread.sleep(difference);
                continue;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: LogReplay propertyFile");
            System.exit(0);
        }
        try {
            Properties loggerProperties = new Properties();
            InputStream propsFile = DisLogger.class.getResourceAsStream(args[0]);
            loggerProperties.load(propsFile);
            LogReplay replay = new LogReplay(loggerProperties);
            replay.replayExercise();
        }
        catch (Exception e) {
            System.out.println("File not found; check to make sure properties file exists");
            System.out.println(e);
        }
        System.out.println("exiting main thread of logger");
    }
}

