/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.logger;

import edu.nps.moves.dis.Pdu;
import edu.nps.moves.disutil.PduContainer;
import java.io.File;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class LogWriter
implements Runnable {
    String exerciseName;
    boolean writing = false;
    boolean unqueuedPdus = false;
    BlockingQueue<List<Pdu>> listQueue = new LinkedBlockingQueue<List<Pdu>>();

    public LogWriter(String pExerciseName) {
        this.exerciseName = pExerciseName;
    }

    public void setUnqueuedPdus(boolean state) {
        this.unqueuedPdus = state;
    }

    public void addListToWriteQueue(List<Pdu> pduList) {
        try {
            this.listQueue.put(pduList);
        }
        catch (Exception e) {
            System.out.println("unable to add list to write queue" + e);
        }
    }

    private void createLogDirectory() {
        try {
            File logDirectory = new File(this.exerciseName);
            boolean createdDirectory = logDirectory.mkdir();
            if (createdDirectory) {
                System.out.println("created log directory " + this.exerciseName);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void run() {
        this.createLogDirectory();
        long startTime = System.currentTimeMillis();
        boolean count = false;
        while (true) {
            try {
                while (true) {
                    List<Pdu> pdusToLog = this.listQueue.take();
                    this.writing = true;
                    long time = System.currentTimeMillis();
                    String fileName = this.exerciseName + "/" + this.exerciseName + "_" + time + ".xml";
                    PduContainer container = new PduContainer();
                    container.setPdus(pdusToLog);
                    this.writing = false;
                }
            }
            catch (Exception e) {
                System.out.println(e);
                continue;
            }
            break;
        }
    }

    public boolean finishedWriting() {
        return this.listQueue.isEmpty() && !this.writing && !this.unqueuedPdus;
    }
}

