/*
 * Decompiled with CFR 0.152.
 */
package edu.nps.moves.spatial;

import SRM.Coord;
import SRM.Coord3D;
import SRM.Direction;
import SRM.OrientationMatrix;
import SRM.OrientationTaitBryanAngles;
import SRM.SRF_Celestiocentric;
import SRM.SRF_Celestiodetic;
import SRM.SRF_LocalTangentSpaceEuclidean;
import SRM.SRF_LococentricEuclidean3D;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_RT_Code;
import SRM.SRM_Tait_Bryan_Angles_Params;
import edu.nps.moves.dis.Orientation;
import edu.nps.moves.dis.Vector3Double;

public class RangeCoordinates {
    SRF_Celestiodetic earthSurfaceReferenceFrame;
    Coord3D earthSurfaceReferenceFrameOrigin;
    SRF_Celestiocentric disCoordinateReferenceFrame;
    SRF_LocalTangentSpaceEuclidean localTangentSurfaceReferenceFrame;
    Coord3D localEuclidianOrigin;
    double latitudeOrigin;
    double longitudeOrigin;
    double altitudeOrigin;

    public RangeCoordinates(double originLat, double originLon, double heightOffset) {
        this.latitudeOrigin = originLat;
        this.longitudeOrigin = originLon;
        this.altitudeOrigin = heightOffset;
        try {
            this.earthSurfaceReferenceFrame = new SRF_Celestiodetic(SRM_ORM_Code.ORMCOD_WGS_1984, SRM_RT_Code.RTCOD_WGS_1984_IDENTITY);
            this.disCoordinateReferenceFrame = new SRF_Celestiocentric(SRM_ORM_Code.ORMCOD_WGS_1984, SRM_RT_Code.RTCOD_WGS_1984_IDENTITY);
            double latInRadians = Math.toRadians(originLat);
            double lonInRadians = Math.toRadians(originLon);
            this.localTangentSurfaceReferenceFrame = new SRF_LocalTangentSpaceEuclidean(SRM_ORM_Code.ORMCOD_WGS_1984, SRM_RT_Code.RTCOD_WGS_1984_IDENTITY, lonInRadians, latInRadians, 0.0, 0.0, 0.0, heightOffset);
            this.localEuclidianOrigin = this.localTangentSurfaceReferenceFrame.createCoordinate3D(0.0, 0.0, 0.0);
            this.earthSurfaceReferenceFrameOrigin = this.earthSurfaceReferenceFrame.createCoordinate3D(latInRadians, lonInRadians, heightOffset);
        }
        catch (Exception e) {
            System.out.println("problem creating coordinate systems" + e);
        }
    }

    public void changeVectorToDisCoordFromLocalFlat(Vector3Double localCoordinates) {
        Vector3Double vec = this.DISCoordFromLocalFlat(localCoordinates.getX(), localCoordinates.getY(), localCoordinates.getZ());
        localCoordinates.setX(vec.getX());
        localCoordinates.setY(vec.getY());
        localCoordinates.setZ(vec.getZ());
    }

    public Vector3Double DISCoordFromLocalFlat(double x, double y, double z) {
        Vector3Double disCoordinates = new Vector3Double();
        try {
            Coord3D localCoordinates = this.localTangentSurfaceReferenceFrame.createCoordinate3D(x, y, z);
            Coord3D disCoord = this.disCoordinateReferenceFrame.createCoordinate3D(0.0, 0.0, 0.0);
            SRM_Coordinate_Valid_Region_Code region = this.disCoordinateReferenceFrame.changeCoordinateSRF((Coord)localCoordinates, (Coord)disCoord);
            double[] values = this.disCoordinateReferenceFrame.getCoordinate3DValues(disCoord);
            disCoordinates.setX(values[0]);
            disCoordinates.setY(values[1]);
            disCoordinates.setZ(values[2]);
        }
        catch (Exception e) {
            System.out.println("can't change to DIS coord " + e);
            return null;
        }
        return disCoordinates;
    }

    public void changeVectorToLocalCoordFromDIS(Vector3Double worldCoordinates) {
        Vector3Double vec = this.localCoordFromDis(worldCoordinates.getX(), worldCoordinates.getY(), worldCoordinates.getZ());
        worldCoordinates.setX(vec.getX());
        worldCoordinates.setY(vec.getY());
        worldCoordinates.setZ(vec.getZ());
    }

    public Vector3Double localCoordFromDis(double x, double y, double z) {
        Vector3Double local = new Vector3Double();
        try {
            Coord3D localCoordinates = this.localTangentSurfaceReferenceFrame.createCoordinate3D(0.0, 0.0, 0.0);
            Coord3D disCoord = this.disCoordinateReferenceFrame.createCoordinate3D(x, y, z);
            SRM_Coordinate_Valid_Region_Code region = this.localTangentSurfaceReferenceFrame.changeCoordinateSRF((Coord)disCoord, (Coord)localCoordinates);
            double[] values = this.localTangentSurfaceReferenceFrame.getCoordinate3DValues(localCoordinates);
            local.setX(values[0]);
            local.setY(values[1]);
            local.setZ(values[2]);
        }
        catch (Exception e) {
            System.out.println("can't change from DIS coord to Local" + e);
            return null;
        }
        return local;
    }

    public Orientation localRollPitchHeadingToDisEuler(Orientation pitchRollHeading, Vector3Double localPosition) {
        try {
            Orientation openDisOrientation = new Orientation();
            OrientationTaitBryanAngles localOrientation = new OrientationTaitBryanAngles((double)pitchRollHeading.getPhi(), (double)pitchRollHeading.getTheta(), (double)pitchRollHeading.getPsi());
            Coord3D localSRMPosition = this.localTangentSurfaceReferenceFrame.createCoordinate3D(localPosition.getX(), localPosition.getY(), localPosition.getZ());
            Vector3Double disLocation = this.DISCoordFromLocalFlat(localPosition.getX(), localPosition.getY(), localPosition.getZ());
            Coord3D disCoord = this.disCoordinateReferenceFrame.createCoordinate3D(6378137.0, 0.0, 0.0);
            OrientationTaitBryanAngles disOrientation = new OrientationTaitBryanAngles();
            this.disCoordinateReferenceFrame.transformOrientation(localSRMPosition, (SRM.Orientation)localOrientation, disCoord, (SRM.Orientation)disOrientation);
            SRM_Tait_Bryan_Angles_Params tait = disOrientation.getTaitBryanAngles();
            openDisOrientation.setPhi((float)tait.pitch);
            openDisOrientation.setTheta((float)tait.roll);
            openDisOrientation.setPsi((float)tait.yaw);
            System.out.println("disOrientation:" + disOrientation.getTaitBryanAngles());
            System.out.println("DIS coordinates:" + disCoord);
            return openDisOrientation;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public void c(double lat, double lon, double alt, double bank, double pitch, double head) {
        try {
            Coord3D gd_coord = this.earthSurfaceReferenceFrame.createCoordinate3D(Math.toRadians(lon), Math.toRadians(lat), alt);
            Coord3D gc_coord = this.disCoordinateReferenceFrame.createCoordinate3D(0.0, 0.0, 0.0);
            this.disCoordinateReferenceFrame.changeCoordinate3DSRF(gd_coord, gc_coord);
            System.out.println("Geocentric coordinates for location " + lat + "," + lon + " :" + gc_coord);
            OrientationTaitBryanAngles tbE2NED_ori = new OrientationTaitBryanAngles(Math.toRadians(bank), Math.toRadians(pitch), Math.toRadians(head));
            System.out.println("Orientation for bank, pitch, heading:" + tbE2NED_ori);
            OrientationMatrix mW2LTSE_ori = new OrientationMatrix(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
            this.earthSurfaceReferenceFrame.transformOrientation(gc_coord, (SRM.Orientation)mW2LTSE_ori, gd_coord, (SRM.Orientation)mW2LTSE_ori);
            OrientationMatrix mNED2LTSE_ori = new OrientationMatrix(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, -1.0);
            System.out.println("tbE2NED_ori:" + tbE2NED_ori);
            System.out.println("tbE2NED_ori:" + tbE2NED_ori);
            System.out.println("mW2LTSE_ori:" + mW2LTSE_ori);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void change(double localX, double localY, double localZ, double bank, double noseUp, double bearing) {
        try {
            Coord3D localLTSEPosition = this.localTangentSurfaceReferenceFrame.createCoordinate3D(localZ, localY, localZ);
            Coord3D localLTSEOrigin = this.localTangentSurfaceReferenceFrame.createCoordinate3D(0.0, 0.0, 0.0);
            Coord3D disPosition = this.disCoordinateReferenceFrame.createCoordinate3D();
            Coord3D disOrigin = this.disCoordinateReferenceFrame.createCoordinate3D();
            SRM_Coordinate_Valid_Region_Code region = this.disCoordinateReferenceFrame.changeCoordinateSRF((Coord)localLTSEPosition, (Coord)disPosition);
            this.disCoordinateReferenceFrame.changeCoordinateSRF((Coord)localLTSEOrigin, (Coord)disOrigin);
            System.out.println("DIS position, should be equal to DIS coords for LTSE orig:" + disPosition);
            System.out.println("ORigin of LTSE in DIS coordinates:" + disOrigin);
            OrientationTaitBryanAngles taitBryanOrientation = new OrientationTaitBryanAngles(Math.toRadians(-180.0 + bank), Math.toRadians(noseUp), Math.toRadians(360.0 - bearing - 270.0));
            System.out.println("tb orientation:" + taitBryanOrientation);
            OrientationTaitBryanAngles taitBryanDis = new OrientationTaitBryanAngles();
            this.localTangentSurfaceReferenceFrame.transformOrientation(disOrigin, (SRM.Orientation)taitBryanOrientation, localLTSEPosition, (SRM.Orientation)taitBryanDis);
            System.out.println("orientation in DIS:" + taitBryanDis.toString());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) {
        RangeCoordinates primeMeridian = new RangeCoordinates(0.0, 0.0, 0.0);
        primeMeridian.DISCoordFromLocalFlat(0.0, 0.0, 0.0);
        primeMeridian.c(0.0, 0.0, 0.0, 0.0, 0.0, 180.0);
        RangeCoordinates northPole = new RangeCoordinates(0.0, 180.0, 0.0);
        northPole.DISCoordFromLocalFlat(0.0, 0.0, 0.0);
        RangeCoordinates yAxis = new RangeCoordinates(90.0, 0.0, 0.0);
        yAxis.DISCoordFromLocalFlat(0.0, 0.0, 0.0);
        RangeCoordinates westALittle = new RangeCoordinates(0.0, -1.0, 0.0);
        westALittle.DISCoordFromLocalFlat(0.0, 0.0, 0.0);
    }

    public SRF_LococentricEuclidean3D getPlatformReferenceFrame(Vector3Double rangePositionCoordinates) {
        try {
            Coord3D lococenter = this.localTangentSurfaceReferenceFrame.createCoordinate3D(rangePositionCoordinates.getX(), rangePositionCoordinates.getY(), rangePositionCoordinates.getZ());
            double[] orientationX = new double[3];
            Direction direction = this.localTangentSurfaceReferenceFrame.createDirection(this.localEuclidianOrigin, orientationX);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return null;
    }
}

