/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.lexparser.BaseUnknownWordModel;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import java.util.Map;
import java.util.Set;

public class GermanUnknownWordModel
extends BaseUnknownWordModel {
    private static final long serialVersionUID = 221L;
    private static final String numberMatch = "[0-9]+(?:\\.[0-9]*)";

    public GermanUnknownWordModel(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex, ClassicCounter<IntTaggedWord> unSeenCounter, Map<Label, ClassicCounter<String>> tagHash, Map<String, Float> unknownGT, Set<String> seenEnd) {
        super(op, lex, wordIndex, tagIndex, unSeenCounter, tagHash, unknownGT, seenEnd);
    }

    public GermanUnknownWordModel(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex) {
        this(op, lex, wordIndex, tagIndex, new ClassicCounter<IntTaggedWord>(), Generics.newHashMap(), Generics.newHashMap(), Generics.newHashSet());
    }

    @Override
    public float score(IntTaggedWord itw, String word) {
        String tag = itw.tagString(this.tagIndex);
        if (word.matches(numberMatch)) {
            if (tag.equals("CARD")) {
                return 0.0f;
            }
            return Float.NEGATIVE_INFINITY;
        }
        return super.score(itw, word);
    }
}

