/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.Interval;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;

public class IntervalTree<E extends Comparable<E>, T extends HasInterval<E>>
extends AbstractCollection<T> {
    private static final double defaultAlpha = 0.65;
    private static final boolean debug = false;
    TreeNode<E, T> root = new TreeNode();

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    @Override
    public void clear() {
        this.root.clear();
    }

    @Override
    public String toString() {
        return "Size: " + this.root.size;
    }

    @Override
    public boolean add(T target) {
        return this.add(this.root, target, 0.65);
    }

    public boolean add(TreeNode<E, T> node, T target) {
        return this.add(node, target, 0.65);
    }

    public boolean add(TreeNode<E, T> node, T target, double alpha) {
        int thresholdDepth;
        if (target == null) {
            return false;
        }
        TreeNode<E, T> n = node;
        int depth = 0;
        int n2 = thresholdDepth = node.size > 10 ? (int)(-Math.log(node.size) / Math.log(alpha) + 1.0) : 10;
        while (n != null) {
            if (n.value == null) {
                n.value = target;
                n.maxEnd = target.getInterval().getEnd();
                n.size = 1;
                if (depth > thresholdDepth) {
                    TreeNode p = n.parent;
                    while (p != null) {
                        if (p.size > 10 && !this.isAlphaBalanced(p, alpha)) {
                            TreeNode newParent = this.balance(p);
                            if (p != this.root) break;
                            this.root = newParent;
                            break;
                        }
                        p = p.parent;
                    }
                }
                return true;
            }
            ++depth;
            n.maxEnd = Interval.max(n.maxEnd, target.getInterval().getEnd());
            ++n.size;
            if (target.getInterval().compareTo(n.value.getInterval()) <= 0) {
                if (n.left == null) {
                    n.left = new TreeNode();
                    n.left.parent = n;
                }
                n = n.left;
                continue;
            }
            if (n.right == null) {
                n.right = new TreeNode();
                n.right.parent = n;
            }
            n = n.right;
        }
        return false;
    }

    @Override
    public int size() {
        return this.root.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new TreeNodeIterator<E, T>(this.root);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object t : c) {
            if (!this.remove(t)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll not implemented");
    }

    @Override
    public boolean contains(Object o) {
        try {
            return this.contains((T)((HasInterval)o));
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    @Override
    public boolean remove(Object o) {
        try {
            return this.remove((T)((HasInterval)o));
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    @Override
    public boolean remove(T target) {
        return this.remove(this.root, target);
    }

    public boolean remove(TreeNode<E, T> node, T target) {
        if (target == null) {
            return false;
        }
        if (node.value == null) {
            return false;
        }
        if (target.equals(node.value)) {
            int rightSize;
            int leftSize = node.left != null ? node.left.size : 0;
            int n = rightSize = node.right != null ? node.right.size : 0;
            if (leftSize == 0) {
                if (rightSize == 0) {
                    node.clear();
                } else {
                    node.value = node.right.value;
                    node.size = node.right.size;
                    node.maxEnd = node.right.maxEnd;
                    node.left = node.right.left;
                    node.right = node.right.right;
                    if (node.left != null) {
                        node.left.parent = node;
                    }
                    if (node.right != null) {
                        node.right.parent = node;
                    }
                }
            } else if (rightSize == 0) {
                node.value = node.left.value;
                node.size = node.left.size;
                node.maxEnd = node.left.maxEnd;
                node.left = node.left.left;
                node.right = node.left.right;
                if (node.left != null) {
                    node.left.parent = node;
                }
                if (node.right != null) {
                    node.right.parent = node;
                }
            } else {
                node.value = node.left.value;
                --node.size;
                node.maxEnd = Interval.max(node.left.maxEnd, node.right.maxEnd);
                TreeNode origRight = node.right;
                node.right = node.left.right;
                node.left = node.left.left;
                if (node.left != null) {
                    node.left.parent = node;
                }
                if (node.right != null) {
                    node.right.parent = node;
                }
                TreeNode<E, T> rightmost = this.getRightmostNode(node);
                rightmost.right = origRight;
                if (rightmost.right != null) {
                    rightmost.right.parent = rightmost;
                    this.adjustUpwards(rightmost.right, node);
                }
            }
            return true;
        }
        if (target.getInterval().compareTo(node.value.getInterval()) <= 0) {
            if (node.left == null) {
                return false;
            }
            boolean res = this.remove(node.left, target);
            if (res) {
                node.maxEnd = Interval.max(node.maxEnd, node.left.maxEnd);
                --node.size;
            }
            return res;
        }
        if (node.right == null) {
            return false;
        }
        boolean res = this.remove(node.right, target);
        if (res) {
            node.maxEnd = Interval.max(node.maxEnd, node.right.maxEnd);
            --node.size;
        }
        return res;
    }

    private void adjustUpwards(TreeNode<E, T> node) {
        this.adjustUpwards(node, null);
    }

    private void adjustUpwards(TreeNode<E, T> node, TreeNode<E, T> stopAt) {
        TreeNode<E, T> n = node;
        while (n != null && n != stopAt) {
            int leftSize = n.left != null ? n.left.size : 0;
            int rightSize = n.right != null ? n.right.size : 0;
            n.maxEnd = n.value.getInterval().getEnd();
            if (n.left != null) {
                n.maxEnd = Interval.max(n.maxEnd, n.left.maxEnd);
            }
            if (n.right != null) {
                n.maxEnd = Interval.max(n.maxEnd, n.right.maxEnd);
            }
            n.size = leftSize + 1 + rightSize;
            if (n == n.parent) {
                throw new IllegalStateException("node is same as parent!!!");
            }
            n = n.parent;
        }
    }

    private void adjust(TreeNode<E, T> node) {
        this.adjustUpwards(node, node.parent);
    }

    public void check() {
        this.check(this.root);
    }

    public void check(TreeNode<E, T> treeNode) {
        Stack todo = new Stack();
        todo.add(treeNode);
        while (!todo.isEmpty()) {
            TreeNode node = (TreeNode)todo.pop();
            if (node == node.parent) {
                throw new IllegalStateException("node is same as parent!!!");
            }
            if (node.isEmpty()) {
                if (node.left != null) {
                    throw new IllegalStateException("Empty node shouldn't have left branch");
                }
                if (node.right == null) continue;
                throw new IllegalStateException("Empty node shouldn't have right branch");
            }
            int leftSize = node.left != null ? node.left.size : 0;
            int rightSize = node.right != null ? node.right.size : 0;
            Comparable leftMax = node.left != null ? (Comparable)node.left.maxEnd : null;
            Comparable rightMax = node.right != null ? (Comparable)node.right.maxEnd : null;
            Object maxEnd = node.value.getInterval().getEnd();
            if (leftMax != null && leftMax.compareTo(maxEnd) > 0) {
                maxEnd = leftMax;
            }
            if (rightMax != null && rightMax.compareTo(maxEnd) > 0) {
                maxEnd = rightMax;
            }
            if (!maxEnd.equals(node.maxEnd)) {
                throw new IllegalStateException("max end is not as expected!!!");
            }
            if (node.size != leftSize + rightSize + 1) {
                throw new IllegalStateException("node size is not one plus the sum of left and right!!!");
            }
            if (node.left != null && node.left.parent != node) {
                throw new IllegalStateException("node left parent is not same as node!!!");
            }
            if (node.right != null && node.right.parent != node) {
                throw new IllegalStateException("node right parent is not same as node!!!");
            }
            if (node.parent != null) {
                TreeNode n = node;
                while (n != null && n.parent != null) {
                    if (n == n.parent.left) {
                        if (node.value != null && node.value.getInterval().compareTo(n.parent.value.getInterval()) > 0) {
                            throw new IllegalStateException("node is not on the correct side!!!");
                        }
                    } else if (n == n.parent.right) {
                        if (node.value.getInterval().compareTo(n.parent.value.getInterval()) <= 0) {
                            throw new IllegalStateException("node is not on the correct side!!!");
                        }
                    } else {
                        throw new IllegalStateException("node is not parent's left or right child!!!");
                    }
                    n = n.parent;
                }
            }
            if (node.left != null) {
                todo.add(node.left);
            }
            if (node.right == null) continue;
            todo.add(node.right);
        }
    }

    public boolean isAlphaBalanced(TreeNode<E, T> node, double alpha) {
        int leftSize = node.left != null ? node.left.size : 0;
        int rightSize = node.right != null ? node.right.size : 0;
        int threshold = (int)alpha * node.size + 1;
        return leftSize <= threshold && rightSize <= threshold;
    }

    public void balance() {
        this.root = this.balance(this.root);
    }

    public TreeNode<E, T> balance(TreeNode<E, T> node) {
        Stack todo = new Stack();
        todo.add(node);
        TreeNode<E, T> newRoot = null;
        while (!todo.isEmpty()) {
            int medianAt;
            TreeNode n = (TreeNode)todo.pop();
            TreeNode<E, T> median = this.getNode(n, medianAt = n.size / 2);
            if (median != null && median != n) {
                this.rotateUp(median, n);
            }
            if (newRoot == null) {
                newRoot = median;
            }
            if (median.left != null) {
                todo.push(median.left);
            }
            if (median.right == null) continue;
            todo.push(median.right);
        }
        if (newRoot == null) {
            return node;
        }
        return newRoot;
    }

    public void rotateUp(TreeNode<E, T> node, TreeNode<E, T> target) {
        TreeNode<E, T> n = node;
        boolean done = false;
        while (n != null && n.parent != null && !done) {
            boolean bl = done = n.parent == target;
            if (n == n.parent.left) {
                n = this.rightRotate(n.parent);
                continue;
            }
            if (n == n.parent.right) {
                n = this.leftRotate(n.parent);
                continue;
            }
            throw new IllegalStateException("Not on parent's left or right branches.");
        }
    }

    public TreeNode<E, T> rightRotate(TreeNode<E, T> oldRoot) {
        if (oldRoot == null || oldRoot.isEmpty() || oldRoot.left == null) {
            return oldRoot;
        }
        TreeNode oldLeftRight = oldRoot.left.right;
        TreeNode newRoot = oldRoot.left;
        newRoot.right = oldRoot;
        oldRoot.left = oldLeftRight;
        newRoot.parent = oldRoot.parent;
        newRoot.maxEnd = oldRoot.maxEnd;
        newRoot.size = oldRoot.size;
        if (newRoot.parent != null) {
            if (newRoot.parent.left == oldRoot) {
                newRoot.parent.left = newRoot;
            } else if (newRoot.parent.right == oldRoot) {
                newRoot.parent.right = newRoot;
            } else {
                throw new IllegalStateException("Old root not a child of it's parent");
            }
        }
        oldRoot.parent = newRoot;
        if (oldLeftRight != null) {
            oldLeftRight.parent = oldRoot;
        }
        this.adjust(oldRoot);
        return newRoot;
    }

    public TreeNode<E, T> leftRotate(TreeNode<E, T> oldRoot) {
        if (oldRoot == null || oldRoot.isEmpty() || oldRoot.right == null) {
            return oldRoot;
        }
        TreeNode oldRightLeft = oldRoot.right.left;
        TreeNode newRoot = oldRoot.right;
        newRoot.left = oldRoot;
        oldRoot.right = oldRightLeft;
        newRoot.parent = oldRoot.parent;
        newRoot.maxEnd = oldRoot.maxEnd;
        newRoot.size = oldRoot.size;
        if (newRoot.parent != null) {
            if (newRoot.parent.left == oldRoot) {
                newRoot.parent.left = newRoot;
            } else if (newRoot.parent.right == oldRoot) {
                newRoot.parent.right = newRoot;
            } else {
                throw new IllegalStateException("Old root not a child of it's parent");
            }
        }
        oldRoot.parent = newRoot;
        if (oldRightLeft != null) {
            oldRightLeft.parent = oldRoot;
        }
        this.adjust(oldRoot);
        return newRoot;
    }

    public int height() {
        return this.height(this.root);
    }

    public int height(TreeNode<E, T> node) {
        if (node.value == null) {
            return 0;
        }
        int lh = node.left != null ? this.height(node.left) : 0;
        int rh = node.right != null ? this.height(node.right) : 0;
        return Math.max(lh, rh) + 1;
    }

    public TreeNode<E, T> getLeftmostNode(TreeNode<E, T> node) {
        TreeNode<E, T> n = node;
        while (n.left != null) {
            n = n.left;
        }
        return n;
    }

    public TreeNode<E, T> getRightmostNode(TreeNode<E, T> node) {
        TreeNode<E, T> n = node;
        while (n.right != null) {
            n = n.right;
        }
        return n;
    }

    public TreeNode<E, T> getNode(TreeNode<E, T> node, int nodeIndex) {
        int i = nodeIndex;
        TreeNode<E, T> n = node;
        while (n != null) {
            int leftSize;
            if (i < 0 || i >= n.size) {
                return null;
            }
            int n2 = leftSize = n.left != null ? n.left.size : 0;
            if (i == leftSize) {
                return n;
            }
            if (i > leftSize) {
                n = n.right;
                i = i - leftSize - 1;
                continue;
            }
            n = n.left;
        }
        return null;
    }

    public boolean addNonOverlapping(T target) {
        if (this.overlaps(target)) {
            return false;
        }
        this.add(target);
        return true;
    }

    public boolean addNonNested(T target) {
        if (this.containsInterval(target, false)) {
            return false;
        }
        this.add(target);
        return true;
    }

    public boolean overlaps(T target) {
        return IntervalTree.overlaps(this.root, target.getInterval());
    }

    public List<T> getOverlapping(T target) {
        return IntervalTree.getOverlapping(this.root, target.getInterval());
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> List<T> getOverlapping(TreeNode<E, T> n, E p) {
        ArrayList overlapping = new ArrayList();
        IntervalTree.getOverlapping(n, p, overlapping);
        return overlapping;
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> List<T> getOverlapping(TreeNode<E, T> n, Interval<E> target) {
        ArrayList overlapping = new ArrayList();
        IntervalTree.getOverlapping(n, target, overlapping);
        return overlapping;
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> void getOverlapping(TreeNode<E, T> n, E p, List<T> result) {
        IntervalTree.getOverlapping(n, Interval.toInterval(p, p), result);
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> void getOverlapping(TreeNode<E, T> node, Interval<E> target, List<T> result) {
        LinkedList todo = new LinkedList();
        todo.add(node);
        while (!todo.isEmpty()) {
            TreeNode n = (TreeNode)todo.poll();
            if (n == null || n.isEmpty() || ((Comparable)target.first).compareTo(n.maxEnd) > 0) continue;
            if (n.left != null) {
                todo.add(n.left);
            }
            if (n.value.getInterval().overlaps(target)) {
                result.add(n.value);
            }
            if (((Comparable)target.second).compareTo(n.value.getInterval().first()) < 0 || n.right == null) continue;
            todo.add(n.right);
        }
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> boolean overlaps(TreeNode<E, T> n, E p) {
        return IntervalTree.overlaps(n, Interval.toInterval(p, p));
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> boolean overlaps(TreeNode<E, T> node, Interval<E> target) {
        Stack todo = new Stack();
        todo.push(node);
        while (!todo.isEmpty()) {
            TreeNode n = (TreeNode)todo.pop();
            if (n == null || n.isEmpty() || ((Comparable)target.first).compareTo(n.maxEnd) > 0) continue;
            if (n.value.getInterval().overlaps(target)) {
                return true;
            }
            if (n.left != null) {
                todo.add(n.left);
            }
            if (((Comparable)target.second).compareTo(n.value.getInterval().first()) < 0 || n.right == null) continue;
            todo.add(n.right);
        }
        return false;
    }

    @Override
    public boolean contains(T target) {
        return IntervalTree.containsValue(this, target);
    }

    public boolean containsInterval(T target, boolean exact) {
        return IntervalTree.containsInterval(this, target.getInterval(), exact);
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> boolean containsInterval(IntervalTree<E, T> n, E p, boolean exact) {
        return IntervalTree.containsInterval(n, Interval.toInterval(p, p), exact);
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> boolean containsInterval(IntervalTree<E, T> node, Interval<E> target, boolean exact) {
        ContainsIntervalFunction containsTargetFunction = new ContainsIntervalFunction(target, exact);
        return IntervalTree.contains(node, target.getInterval(), containsTargetFunction);
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> boolean containsValue(IntervalTree<E, T> node, T target) {
        ContainsValueFunction containsTargetFunction = new ContainsValueFunction(target);
        return IntervalTree.contains(node, target.getInterval(), containsTargetFunction);
    }

    private static <E extends Comparable<E>, T extends HasInterval<E>> boolean contains(IntervalTree<E, T> tree, Interval<E> target, Function<T, Boolean> containsTargetFunction) {
        return IntervalTree.contains(tree.root, target, containsTargetFunction);
    }

    private static <E extends Comparable<E>, T extends HasInterval<E>> boolean contains(TreeNode<E, T> node, Interval<E> target, Function<T, Boolean> containsTargetFunction) {
        Stack todo = new Stack();
        todo.push(node);
        while (!todo.isEmpty()) {
            TreeNode n = (TreeNode)todo.pop();
            if (n == null || n.isEmpty() || ((Comparable)target.first).compareTo(n.maxEnd) > 0) continue;
            if (containsTargetFunction.apply(n.value).booleanValue()) {
                return true;
            }
            if (n.left != null) {
                todo.push(n.left);
            }
            if (((Comparable)target.second).compareTo(n.value.getInterval().first()) <= 0 || n.right == null) continue;
            todo.push(n.right);
        }
        return false;
    }

    public static <T, E extends Comparable<E>> List<T> getNonOverlapping(List<? extends T> items, Function<? super T, Interval<E>> toIntervalFunc) {
        ArrayList<T> nonOverlapping = new ArrayList<T>();
        IntervalTree<E, Interval<E>> intervals = new IntervalTree<E, Interval<E>>();
        for (T item : items) {
            Interval<E> i = toIntervalFunc.apply(item);
            boolean addOk = intervals.addNonOverlapping(i);
            if (!addOk) continue;
            nonOverlapping.add(item);
        }
        return nonOverlapping;
    }

    public static <T, E extends Comparable<E>> List<T> getNonOverlapping(List<? extends T> items, Function<? super T, Interval<E>> toIntervalFunc, Comparator<? super T> compareFunc) {
        ArrayList<? extends T> sorted = new ArrayList<T>(items);
        Collections.sort(sorted, compareFunc);
        return IntervalTree.getNonOverlapping(sorted, toIntervalFunc);
    }

    public static <T extends HasInterval<E>, E extends Comparable<E>> List<T> getNonOverlapping(List<? extends T> items, Comparator<? super T> compareFunc) {
        Function toIntervalFunc = new Function<T, Interval<E>>(){

            @Override
            public Interval<E> apply(T in) {
                return in.getInterval();
            }
        };
        return IntervalTree.getNonOverlapping(items, toIntervalFunc, compareFunc);
    }

    public static <T extends HasInterval<E>, E extends Comparable<E>> List<T> getNonOverlapping(List<? extends T> items) {
        Function toIntervalFunc = new Function<T, Interval<E>>(){

            @Override
            public Interval<E> apply(T in) {
                return in.getInterval();
            }
        };
        return IntervalTree.getNonOverlapping(items, toIntervalFunc);
    }

    public static <T, E extends Comparable<E>> List<T> getNonNested(List<? extends T> items, Function<? super T, Interval<E>> toIntervalFunc, Comparator<? super T> compareFunc) {
        ArrayList<T> sorted = new ArrayList<T>(items);
        Collections.sort(sorted, compareFunc);
        ArrayList res = new ArrayList();
        IntervalTree<E, Interval<E>> intervals = new IntervalTree<E, Interval<E>>();
        for (Object item : sorted) {
            Interval<E> i = toIntervalFunc.apply(item);
            boolean addOk = intervals.addNonNested(i);
            if (!addOk) continue;
            res.add(item);
        }
        return res;
    }

    private static class ContainsIntervalFunction<E extends Comparable<E>, T extends HasInterval<E>>
    implements Function<T, Boolean> {
        private Interval<E> target;
        private boolean exact;

        public ContainsIntervalFunction(Interval<E> target, boolean exact) {
            this.target = target;
            this.exact = exact;
        }

        @Override
        public Boolean apply(T in) {
            if (this.exact) {
                return in.getInterval().equals(this.target);
            }
            return in.getInterval().contains(this.target);
        }
    }

    private static class ContainsValueFunction<E extends Comparable<E>, T extends HasInterval<E>>
    implements Function<T, Boolean> {
        private T target;

        public ContainsValueFunction(T target) {
            this.target = target;
        }

        @Override
        public Boolean apply(T in) {
            return in.equals(this.target);
        }
    }

    private static class TreeNodeIterator<E extends Comparable<E>, T extends HasInterval<E>>
    extends AbstractIterator<T> {
        TreeNode<E, T> node;
        Iterator<T> curIter;
        int stage = -1;
        T next;

        public TreeNodeIterator(TreeNode<E, T> node) {
            this.node = node;
            if (node.isEmpty()) {
                this.stage = 3;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T x = this.next;
                this.next = this.getNext();
                return x;
            }
            throw new NoSuchElementException();
        }

        private T getNext() {
            if (this.stage > 2) {
                return null;
            }
            block5: while (this.curIter == null || !this.curIter.hasNext()) {
                ++this.stage;
                switch (this.stage) {
                    case 0: {
                        this.curIter = this.node.left != null ? new TreeNodeIterator(this.node.left) : null;
                        continue block5;
                    }
                    case 1: {
                        this.curIter = null;
                        return this.node.value;
                    }
                    case 2: {
                        this.curIter = this.node.right != null ? new TreeNodeIterator(this.node.right) : null;
                        continue block5;
                    }
                }
                return null;
            }
            if (this.curIter != null && this.curIter.hasNext()) {
                return (T)((HasInterval)this.curIter.next());
            }
            return null;
        }
    }

    public static class TreeNode<E extends Comparable<E>, T extends HasInterval<E>> {
        T value;
        E maxEnd;
        int size;
        TreeNode<E, T> left;
        TreeNode<E, T> right;
        TreeNode<E, T> parent;

        public boolean isEmpty() {
            return this.value == null;
        }

        public void clear() {
            this.value = null;
            this.maxEnd = null;
            this.size = 0;
            this.left = null;
            this.right = null;
        }
    }
}

