/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import uk.ac.manchester.cs.owl.explanation.AxiomSelectionListener;
import uk.ac.manchester.cs.owl.explanation.AxiomSelectionModel;

public class AxiomSelectionModelImpl
implements AxiomSelectionModel {
    private Set<OWLAxiom> selectedAxioms = new HashSet<OWLAxiom>();
    private List<AxiomSelectionListener> listeners = new ArrayList<AxiomSelectionListener>();

    @Override
    public void setAxiomSelected(OWLAxiom axiom, boolean b) {
        if (b) {
            if (!this.selectedAxioms.contains(axiom)) {
                this.selectedAxioms.add(axiom);
                this.fireEvent(axiom, true);
            }
        } else if (this.selectedAxioms.contains(axiom)) {
            this.selectedAxioms.remove(axiom);
            this.fireEvent(axiom, false);
        }
    }

    protected void fireEvent(OWLAxiom axiom, boolean added) {
        for (AxiomSelectionListener lsnr : new ArrayList<AxiomSelectionListener>(this.listeners)) {
            if (added) {
                lsnr.axiomAdded(this, axiom);
                continue;
            }
            lsnr.axiomRemoved(this, axiom);
        }
    }

    @Override
    public Set<OWLAxiom> getSelectedAxioms() {
        return Collections.unmodifiableSet(this.selectedAxioms);
    }

    @Override
    public void addAxiomSelectionListener(AxiomSelectionListener lsnr) {
        this.listeners.add(lsnr);
    }

    @Override
    public void removeAxiomSelectionListener(AxiomSelectionListener lsnr) {
        this.listeners.remove(lsnr);
    }
}

