/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.OWLEditorKit;
import uk.ac.manchester.cs.owl.explanation.ExplanationDisplay;
import uk.ac.manchester.cs.owl.explanation.JustificationType;
import uk.ac.manchester.cs.owl.explanation.WorkbenchManager;

public class ExplanationDisplayList
extends JPanel
implements Disposable {
    private OWLEditorKit editorKit;
    private ExplanationDisplay display;
    private JCheckBox displayLaconicCheckBox = new JCheckBox();
    private int explanationNumber;
    private int entailmentNumber;
    private WorkbenchManager workbenchManager;

    public ExplanationDisplayList(OWLEditorKit editorKit, WorkbenchManager workbenchManager, ExplanationDisplay display, int explanationNumber) {
        this.editorKit = editorKit;
        this.workbenchManager = workbenchManager;
        this.display = display;
        this.explanationNumber = explanationNumber;
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout(2, 2));
        JPanel headerPanel = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel("Explanation " + this.explanationNumber);
        headerPanel.add(label);
        this.displayLaconicCheckBox.setFont(this.displayLaconicCheckBox.getFont().deriveFont(10.0f));
        this.displayLaconicCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.displayLaconicCheckBox.setAction(new AbstractAction("Display laconic explanation"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplanationDisplayList.this.displayLaconicExplanation(ExplanationDisplayList.this.displayLaconicCheckBox.isSelected());
            }
        });
        if (this.workbenchManager.getWorkbenchSettings().getJustificationType().equals((Object)JustificationType.LACONIC)) {
            this.displayLaconicCheckBox.setEnabled(false);
        }
        headerPanel.add(this.displayLaconicCheckBox);
        this.add((Component)headerPanel, "North");
        JPanel displayHolder = new JPanel(new BorderLayout());
        Border marginBorder = BorderFactory.createEmptyBorder(0, 20, 0, 0);
        Border lineBorder = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
        displayHolder.setBorder(BorderFactory.createCompoundBorder(marginBorder, lineBorder));
        displayHolder.add((JComponent)((Object)this.display));
        this.add(displayHolder);
    }

    private void displayLaconicExplanation(boolean b) {
        this.display.setDisplayLaconicExplanation(b);
    }

    public void dispose() {
        this.display.dispose();
    }
}

