/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owlapi.model.OWLAxiom;

public class ExplanationProgressPanel
extends JPanel
implements ExplanationProgressMonitor<OWLAxiom> {
    private JLabel messageLabel;
    private int numberFound = 0;
    private static final String MESSAGE = "Computing explanations.  Found ";
    private boolean cancelled = false;
    private Action cancelAction;

    public ExplanationProgressPanel() {
        this.setLayout(new BorderLayout(12, 12));
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setPreferredSize(new Dimension(400, 100));
        JPanel progressPanel = new JPanel(new BorderLayout(3, 3));
        this.add((Component)progressPanel, "North");
        this.messageLabel = new JLabel("Computing explanations.  Found 0  ");
        progressPanel.add((Component)this.messageLabel, "North");
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        progressPanel.add((Component)progressBar, "South");
        this.cancelAction = new AbstractAction("Stop searching"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplanationProgressPanel.this.cancelled = true;
                this.setEnabled(false);
            }
        };
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.add((Component)buttonPanel, "South");
        buttonPanel.add(new JButton(this.cancelAction));
    }

    public void reset() {
        this.cancelled = false;
        this.numberFound = 0;
        this.cancelAction.setEnabled(true);
    }

    private void updateMessage() {
        Runnable runnable = () -> this.messageLabel.setText(MESSAGE + this.numberFound);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void foundExplanation(ExplanationGenerator explanationGenerator, Explanation explanation, Set allFoundExplanations) {
        this.numberFound = allFoundExplanations.size();
        this.updateMessage();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

