/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import uk.ac.manchester.cs.owl.explanation.ProtegeExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;
import uk.ac.manchester.cs.owl.explanation.ordering.Tree;

public class JustificationFormattingManager {
    private static JustificationFormattingManager manager;
    private Map<Explanation<?>, Map<OWLAxiom, Integer>> indentMap = new HashMap();
    private Map<Explanation<?>, List<OWLAxiom>> orderingMap = new HashMap();

    private JustificationFormattingManager() {
    }

    public static synchronized JustificationFormattingManager getManager() {
        if (manager == null) {
            manager = new JustificationFormattingManager();
        }
        return manager;
    }

    private void init(Explanation<?> explanation) {
        ProtegeExplanationOrderer orderer = new ProtegeExplanationOrderer(OWLManager.createOWLOntologyManager());
        ExplanationTree tree = orderer.getOrderedExplanation((OWLAxiom)explanation.getEntailment(), explanation.getAxioms());
        ArrayList<OWLAxiom> ordering = new ArrayList<OWLAxiom>();
        HashMap<OWLAxiom, Integer> im = new HashMap<OWLAxiom, Integer>();
        JustificationFormattingManager.fill((Tree<OWLAxiom>)tree, ordering, im);
        this.indentMap.put(explanation, im);
        this.orderingMap.put(explanation, ordering);
    }

    private static void fill(Tree<OWLAxiom> tree, List<OWLAxiom> ordering, Map<OWLAxiom, Integer> indentMap) {
        if (!tree.isRoot()) {
            ordering.add((OWLAxiom)tree.getUserObject());
            indentMap.put((OWLAxiom)tree.getUserObject(), tree.getPathToRoot().size() - 2);
        }
        for (Tree child : tree.getChildren()) {
            JustificationFormattingManager.fill((Tree<OWLAxiom>)child, ordering, indentMap);
        }
    }

    private void initIfNecessary(Explanation<?> explanation) {
        if (!this.indentMap.containsKey(explanation)) {
            this.init(explanation);
        }
    }

    public int getIndentation(Explanation<?> explanation, OWLAxiom axiom) {
        if (!explanation.getAxioms().contains(axiom) && !explanation.getEntailment().equals(axiom)) {
            throw new IllegalArgumentException("The explanation does not contain the specified axiom: " + axiom + "  " + explanation);
        }
        this.initIfNecessary(explanation);
        Integer i = this.indentMap.get(explanation).get(axiom);
        if (i != null) {
            return i;
        }
        return 0;
    }

    public void setIndentation(Explanation<?> explanation, OWLAxiom axiom, int indentation) {
        this.initIfNecessary(explanation);
        this.indentMap.get(explanation).put(axiom, indentation);
    }

    public void increaseIndentation(Explanation<?> explanation, OWLAxiom axiom) {
        this.initIfNecessary(explanation);
        Integer indent = this.getIndentation(explanation, axiom);
        this.setIndentation(explanation, axiom, indent + 1);
    }

    public void decreaseIndentation(Explanation<?> explanation, OWLAxiom axiom) {
        this.initIfNecessary(explanation);
        Integer indent = this.getIndentation(explanation, axiom);
        indent = indent - 1;
        if (indent < 0) {
            indent = 0;
        }
        this.setIndentation(explanation, axiom, indent);
    }

    public int moveAxiomUp(Explanation<?> explanation, OWLAxiom axiom) {
        this.initIfNecessary(explanation);
        List<OWLAxiom> ordering = this.orderingMap.get(explanation);
        int index = ordering.indexOf(axiom);
        if (index > 0) {
            --index;
        }
        ordering.remove(axiom);
        ordering.add(index, axiom);
        return index;
    }

    public int moveAxiomDown(Explanation<?> explanation, OWLAxiom axiom) {
        this.initIfNecessary(explanation);
        List<OWLAxiom> ordering = this.orderingMap.get(explanation);
        int index = ordering.indexOf(axiom);
        if (index < ordering.size() - 1) {
            ++index;
        }
        ordering.remove(axiom);
        ordering.add(index, axiom);
        return index;
    }

    public List<OWLAxiom> getOrdering(Explanation<?> explanation) {
        this.initIfNecessary(explanation);
        return Collections.unmodifiableList(this.orderingMap.get(explanation));
    }

    public void clearFormatting(Explanation<?> explanation) {
        this.indentMap.remove(explanation);
        this.orderingMap.remove(explanation);
    }
}

