/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owlapi.model.OWLAxiom;
import uk.ac.manchester.cs.owl.explanation.AxiomSelectionListener;
import uk.ac.manchester.cs.owl.explanation.AxiomSelectionModel;
import uk.ac.manchester.cs.owl.explanation.ExplanationDisplay;
import uk.ac.manchester.cs.owl.explanation.JustificationFrame;
import uk.ac.manchester.cs.owl.explanation.JustificationFrameList;
import uk.ac.manchester.cs.owl.explanation.JustificationFrameSectionRow;
import uk.ac.manchester.cs.owl.explanation.WorkbenchManager;

public class JustificationFrameExplanationDisplay
extends JPanel
implements ExplanationDisplay,
AxiomSelectionListener {
    private Explanation<OWLAxiom> explanation;
    private JustificationFrame frame;
    private final JustificationFrameList frameList;
    private OWLEditorKit editorKit;
    private Explanation<OWLAxiom> lacExp;
    private WorkbenchManager workbenchManager;
    private AxiomSelectionModel axiomSelectionModel;
    private boolean transmittingSelectionToModel = false;

    public JustificationFrameExplanationDisplay(OWLEditorKit editorKit, AxiomSelectionModel selectionModel, WorkbenchManager workbenchManager, Explanation<OWLAxiom> explanation) {
        this.editorKit = editorKit;
        this.workbenchManager = workbenchManager;
        this.axiomSelectionModel = selectionModel;
        this.explanation = explanation;
        this.frame = new JustificationFrame(editorKit);
        this.setLayout(new BorderLayout());
        this.frameList = new JustificationFrameList(editorKit, selectionModel, workbenchManager, (OWLFrame<Explanation<OWLAxiom>>)this.frame);
        this.add((Component)((Object)this.frameList), "North");
        this.frame.setRootObject(explanation);
        this.frameList.setBorder(BorderFactory.createEmptyBorder(7, 10, 7, 10));
        this.frameList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JustificationFrameExplanationDisplay.this.transmitSelectionToModel();
            }
        });
        this.axiomSelectionModel.addAxiomSelectionListener(new AxiomSelectionListener(){

            @Override
            public void axiomAdded(AxiomSelectionModel source, OWLAxiom axiom) {
                JustificationFrameExplanationDisplay.this.respondToAxiomSelectionChange();
            }

            @Override
            public void axiomRemoved(AxiomSelectionModel source, OWLAxiom axiom) {
                JustificationFrameExplanationDisplay.this.respondToAxiomSelectionChange();
            }
        });
    }

    private void respondToAxiomSelectionChange() {
        if (!this.transmittingSelectionToModel) {
            this.frameList.clearSelection();
            this.frameList.repaint(this.frameList.getVisibleRect());
        }
        this.frameList.repaint(this.frameList.getVisibleRect());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transmitSelectionToModel() {
        try {
            this.transmittingSelectionToModel = true;
            for (int i = 1; i < this.frameList.getModel().getSize(); ++i) {
                Object element = this.frameList.getModel().getElementAt(i);
                if (!(element instanceof JustificationFrameSectionRow)) continue;
                JustificationFrameSectionRow row = (JustificationFrameSectionRow)((Object)element);
                OWLAxiom ax = row.getAxiom();
                this.axiomSelectionModel.setAxiomSelected(ax, this.frameList.isSelectedIndex(i));
            }
        }
        finally {
            this.transmittingSelectionToModel = false;
        }
    }

    @Override
    public Explanation<OWLAxiom> getExplanation() {
        return this.explanation;
    }

    @Override
    public void dispose() {
        this.frame.dispose();
    }

    @Override
    public void setDisplayLaconicExplanation(boolean b) {
        if (b) {
            Explanation<OWLAxiom> lacExp = this.getLaconicExplanation();
            if (lacExp != null) {
                this.frame.setRootObject(lacExp);
            }
        } else {
            this.frame.setRootObject(this.explanation);
        }
    }

    private Explanation<OWLAxiom> getLaconicExplanation() {
        if (this.lacExp != null) {
            return this.lacExp;
        }
        return this.workbenchManager.getJustificationManager().getLaconicJustification(this.explanation);
    }

    @Override
    public void axiomAdded(AxiomSelectionModel source, OWLAxiom axiom) {
        System.out.println("SEL: " + axiom);
    }

    @Override
    public void axiomRemoved(AxiomSelectionModel source, OWLAxiom axiom) {
    }
}

