/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.protege.editor.core.ui.list.MListButton;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.framelist.ExplainButton;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.protege.editor.owl.ui.framelist.OWLFrameListPopupMenuAction;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owlapi.model.OWLAxiom;
import uk.ac.manchester.cs.owl.explanation.AxiomSelectionModel;
import uk.ac.manchester.cs.owl.explanation.JustificationFormattingManager;
import uk.ac.manchester.cs.owl.explanation.JustificationFrameListRenderer;
import uk.ac.manchester.cs.owl.explanation.JustificationFrameSectionRow;
import uk.ac.manchester.cs.owl.explanation.WorkbenchManager;

public class JustificationFrameList
extends OWLFrameList<Explanation<OWLAxiom>> {
    public static final Color SINGLE_POPULARITY_COLOR = new Color(170, 70, 15);
    public static final Color MULTI_POPULARITY_COLOR = new Color(10, 75, 175);
    public static final Color ALL_POPULARITY_COLOR = new Color(6, 133, 19);
    private OWLEditorKit editorKit;
    private int buttonRunWidth = 0;
    private AxiomSelectionModel axiomSelectionModel;
    private WorkbenchManager workbenchManager;

    public JustificationFrameList(OWLEditorKit editorKit, AxiomSelectionModel axiomSelectionModel, WorkbenchManager workbenchManager, OWLFrame<Explanation<OWLAxiom>> explanationOWLFrame) {
        super(editorKit, explanationOWLFrame);
        this.workbenchManager = workbenchManager;
        this.axiomSelectionModel = axiomSelectionModel;
        this.editorKit = editorKit;
        this.setWrap(false);
        this.setCellRenderer((ListCellRenderer)((Object)new JustificationFrameListRenderer(editorKit)));
        AbstractAction moveUpAction = new AbstractAction("Move up"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JustificationFrameList.this.handleMoveUp();
            }
        };
        this.getActionMap().put(moveUpAction.getValue("Name"), moveUpAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 2), moveUpAction.getValue("Name"));
        AbstractAction moveDownAction = new AbstractAction("Move down"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JustificationFrameList.this.handleMoveDown();
            }
        };
        this.getActionMap().put(moveDownAction.getValue("Name"), moveDownAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 2), moveDownAction.getValue("Name"));
        AbstractAction increaseIndentation = new AbstractAction("Increase indentation"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JustificationFrameList.this.handleIncreaseIndentation();
            }
        };
        this.getActionMap().put(increaseIndentation.getValue("Name"), increaseIndentation);
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 2), increaseIndentation.getValue("Name"));
        AbstractAction decreaseIndentation = new AbstractAction("decrease indentation"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JustificationFrameList.this.handleDecreaseIndentation();
            }
        };
        this.getActionMap().put(decreaseIndentation.getValue("Name"), decreaseIndentation);
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 2), decreaseIndentation.getValue("Name"));
    }

    private void handleMoveUp() {
        OWLAxiom selectedAxiom = this.getSelectedAxiom();
        if (selectedAxiom == null) {
            return;
        }
        JustificationFormattingManager formattingManager = JustificationFormattingManager.getManager();
        int newIndex = formattingManager.moveAxiomUp((Explanation)this.getRootObject(), selectedAxiom);
        this.getFrame().setRootObject(this.getRootObject());
        this.setSelectedIndex(newIndex + 1);
    }

    private void handleMoveDown() {
        OWLAxiom selectedAxiom = this.getSelectedAxiom();
        if (selectedAxiom == null) {
            return;
        }
        JustificationFormattingManager formattingManager = JustificationFormattingManager.getManager();
        int newIndex = formattingManager.moveAxiomDown((Explanation)this.getRootObject(), selectedAxiom);
        this.getFrame().setRootObject(this.getRootObject());
        this.setSelectedIndex(newIndex + 1);
    }

    private void handleIncreaseIndentation() {
        OWLAxiom selectedAxiom = this.getSelectedAxiom();
        if (selectedAxiom == null) {
            return;
        }
        JustificationFormattingManager formattingManager = JustificationFormattingManager.getManager();
        formattingManager.increaseIndentation((Explanation)this.getRootObject(), selectedAxiom);
        int selIndex = this.getSelectedIndex();
        this.getFrame().setRootObject(this.getRootObject());
        this.setSelectedIndex(selIndex);
    }

    private void handleDecreaseIndentation() {
        OWLAxiom selectedAxiom = this.getSelectedAxiom();
        if (selectedAxiom == null) {
            return;
        }
        JustificationFormattingManager formattingManager = JustificationFormattingManager.getManager();
        formattingManager.decreaseIndentation((Explanation)this.getRootObject(), selectedAxiom);
        int selIndex = this.getSelectedIndex();
        this.getFrame().setRootObject(this.getRootObject());
        this.setSelectedIndex(selIndex);
    }

    private OWLAxiom getSelectedAxiom() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        Object element = this.getModel().getElementAt(selectedIndex);
        if (!(element instanceof JustificationFrameSectionRow)) {
            return null;
        }
        return ((JustificationFrameSectionRow)((Object)element)).getAxiom();
    }

    protected List<MListButton> getButtons(Object value) {
        if (value instanceof JustificationFrameSectionRow) {
            List<MListButton> buttons = Arrays.asList(new ExplainButton((ActionListener)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JustificationFrameList.this.invokeExplanationHandler();
                }
            }));
            this.buttonRunWidth = buttons.size() * (this.getButtonDimension() + 2) + 20;
            return buttons;
        }
        return Collections.emptyList();
    }

    public void addToPopupMenu(OWLFrameListPopupMenuAction<Explanation<OWLAxiom>> explanationOWLFrameListPopupMenuAction) {
    }

    protected Color getItemBackgroundColor(MListItem item) {
        if (item instanceof JustificationFrameSectionRow) {
            JustificationFrameSectionRow row = (JustificationFrameSectionRow)item;
            OWLAxiom axiom = row.getAxiom();
            int rowIndex = row.getFrameSection().getRowIndex((OWLFrameSectionRow)row) + 1;
            if (!this.isSelectedIndex(rowIndex)) {
                if (this.axiomSelectionModel.getSelectedAxioms().contains(axiom)) {
                    return Color.YELLOW;
                }
                boolean inAll = true;
                for (Explanation<OWLAxiom> expl : this.workbenchManager.getJustifications((OWLAxiom)((Explanation)this.getRootObject()).getEntailment())) {
                    if (expl.contains(axiom)) continue;
                    inAll = false;
                    break;
                }
                if (inAll) {
                    return new Color(245, 255, 235);
                }
            }
        }
        return super.getItemBackgroundColor(item);
    }

    protected List<MListButton> getListItemButtons(MListItem item) {
        return Collections.emptyList();
    }

    protected Border createListItemBorder(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        return super.createListItemBorder(list, value, index, isSelected, cellHasFocus);
    }

    protected Border createPaddingBorder(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        return super.createPaddingBorder(list, value, index, isSelected, cellHasFocus);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int size = this.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            OWLAxiom entailment;
            Object element = this.getModel().getElementAt(i);
            if (!(element instanceof JustificationFrameSectionRow)) continue;
            JustificationFrameSectionRow row = (JustificationFrameSectionRow)((Object)element);
            Rectangle rect = this.getCellBounds(i, i);
            if (!rect.intersects(g.getClip().getBounds()) || this.workbenchManager.getJustificationCount(entailment = (OWLAxiom)((Explanation)this.getRootObject()).getEntailment()) <= 1) continue;
            AttributedString popularityString = this.getPopularityString(this.isSelectedIndex(i), row);
            TextLayout textLayout = new TextLayout(popularityString.getIterator(), g2.getFontRenderContext());
            float advance = textLayout.getAdvance();
            float x = (float)(rect.x + rect.width) - advance - (float)this.buttonRunWidth;
            float h = textLayout.getAscent() + textLayout.getDescent();
            float y = ((float)rect.height - h) / 2.0f + (float)rect.y + textLayout.getLeading() + textLayout.getAscent();
            textLayout.draw(g2, x, y);
            g2.setColor(Color.LIGHT_GRAY);
            TextLayout numberLayout = new TextLayout(i + ")", g2.getFont(), g2.getFontRenderContext());
            float numberX = 20.0f - numberLayout.getAdvance();
            numberLayout.draw(g2, numberX, y);
        }
    }

    private AttributedString getPopularityString(boolean sel, JustificationFrameSectionRow row) {
        Color highlightColor;
        int popularity = this.workbenchManager.getPopularity(row.getAxiom());
        OWLAxiom entailment = (OWLAxiom)((Explanation)row.getRoot()).getEntailment();
        int count = this.workbenchManager.getJustificationCount(entailment);
        StringBuilder sb = new StringBuilder("In ");
        int start = sb.length();
        if (popularity <= 1) {
            sb.append("NO");
            highlightColor = SINGLE_POPULARITY_COLOR;
        } else if (popularity != count) {
            sb.append(popularity - 1);
            highlightColor = MULTI_POPULARITY_COLOR;
        } else {
            sb.append("ALL");
            highlightColor = ALL_POPULARITY_COLOR;
        }
        int end = sb.length();
        sb.append(" other justifications");
        AttributedString as = new AttributedString(sb.toString());
        as.addAttribute(TextAttribute.FOREGROUND, Color.LIGHT_GRAY, 0, sb.length());
        if (!sel) {
            as.addAttribute(TextAttribute.FOREGROUND, highlightColor, start, end);
        }
        return as;
    }
}

