/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLPropertyAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import uk.ac.manchester.cs.owl.explanation.ordering.EntailedAxiomTree;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;
import uk.ac.manchester.cs.owl.explanation.ordering.MutableTree;
import uk.ac.manchester.cs.owl.explanation.ordering.Tree;

public class ProtegeExplanationOrderer
implements ExplanationOrderer {
    private Set<OWLAxiom> currentExplanation = Collections.emptySet();
    private final Map<OWLEntity, Set<OWLAxiom>> lhs2AxiomMap = new HashMap<OWLEntity, Set<OWLAxiom>>();
    private final Map<OWLAxiom, Set<OWLEntity>> entitiesByAxiomRHS = new HashMap<OWLAxiom, Set<OWLEntity>>();
    private final SeedExtractor seedExtractor = new SeedExtractor();
    private final OWLOntologyManager man;
    private OWLOntology ont;
    private final Map<OWLObject, Set<OWLAxiom>> mappedAxioms;
    private final Set<OWLAxiom> consumedAxioms;
    private final Set<AxiomType<?>> passTypes;
    private OWLEntity currentSource;
    private OWLEntity currentTarget;
    private static Comparator<Tree<OWLAxiom>> comparator = new OWLAxiomTreeComparator();
    private static AtomicLong randomstart = new AtomicLong(System.currentTimeMillis());
    private static PropertiesFirstComparator propertiesFirstComparator = new PropertiesFirstComparator();

    public ProtegeExplanationOrderer(OWLOntologyManager m) {
        this.man = m;
        this.mappedAxioms = new HashMap<OWLObject, Set<OWLAxiom>>();
        this.passTypes = new HashSet();
        this.passTypes.add(AxiomType.DISJOINT_CLASSES);
        this.consumedAxioms = new HashSet<OWLAxiom>();
    }

    private void reset() {
        this.lhs2AxiomMap.clear();
        this.entitiesByAxiomRHS.clear();
        this.consumedAxioms.clear();
    }

    public ExplanationTree getOrderedExplanation(OWLAxiom entailment, Set<OWLAxiom> axioms) {
        this.currentExplanation = new HashSet<OWLAxiom>(axioms);
        this.buildIndices();
        EntailedAxiomTree root = new EntailedAxiomTree(entailment);
        this.currentSource = this.seedExtractor.getSource(entailment);
        this.insertChildren(this.currentSource, (ExplanationTree)root);
        this.currentTarget = this.seedExtractor.getTarget(entailment);
        Set axs = root.getUserObjectClosure();
        final HashSet targetAxioms = new HashSet();
        if (this.currentTarget != null) {
            if (this.currentTarget.isOWLClass()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLClass()));
            }
            if (this.currentTarget.isOWLObjectProperty()) {
                targetAxioms.addAll(this.ont.getAxioms((OWLObjectPropertyExpression)this.currentTarget.asOWLObjectProperty()));
            }
            if (this.currentTarget.isOWLDataProperty()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLDataProperty()));
            }
            if (this.currentTarget.isOWLNamedIndividual()) {
                targetAxioms.addAll(this.ont.getAxioms((OWLIndividual)this.currentTarget.asOWLNamedIndividual()));
            }
        }
        List rootAxioms = axioms.stream().filter(ax -> !axs.contains(ax)).collect(Collectors.toList());
        Collections.sort(rootAxioms, new Comparator<OWLAxiom>(){

            @Override
            public int compare(OWLAxiom o1, OWLAxiom o2) {
                if (targetAxioms.contains(o1)) {
                    return 1;
                }
                if (targetAxioms.contains(o2)) {
                    return -1;
                }
                return 0;
            }
        });
        for (OWLAxiom ax2 : rootAxioms) {
            root.addChild((MutableTree)new ExplanationTree(ax2));
        }
        return root;
    }

    private List<OWLEntity> getRHSEntitiesSorted(OWLAxiom ax) {
        Collection<OWLEntity> entities = this.getRHSEntities(ax);
        ArrayList<OWLEntity> sortedEntities = new ArrayList<OWLEntity>(entities);
        Collections.sort(sortedEntities, propertiesFirstComparator);
        return sortedEntities;
    }

    private void insertChildren(OWLEntity entity, ExplanationTree tree) {
        HashSet currentPath = new HashSet(tree.getUserObjectPathToRoot());
        Set axioms = Collections.emptySet();
        if (entity != null) {
            if (entity.isOWLClass()) {
                axioms = this.ont.getAxioms(entity.asOWLClass());
            } else if (entity.isOWLObjectProperty()) {
                axioms = this.ont.getAxioms((OWLObjectPropertyExpression)entity.asOWLObjectProperty());
            } else if (entity.isOWLDataProperty()) {
                axioms = this.ont.getAxioms(entity.asOWLDataProperty());
            } else if (entity.isOWLNamedIndividual()) {
                axioms = this.ont.getAxioms((OWLIndividual)entity.asOWLNamedIndividual());
            }
            for (OWLAxiom ax : axioms) {
                if (this.passTypes.contains(ax.getAxiomType())) continue;
                Set<OWLAxiom> mapped = ProtegeExplanationOrderer.getIndexedSet(entity, this.mappedAxioms, true);
                if (this.consumedAxioms.contains(ax) || mapped.contains(ax) || currentPath.contains(ax)) continue;
                mapped.add(ax);
                this.consumedAxioms.add(ax);
                ExplanationTree child = new ExplanationTree(ax);
                tree.addChild((MutableTree)child);
                for (OWLEntity ent : this.getRHSEntitiesSorted(ax)) {
                    this.insertChildren(ent, child);
                }
            }
        }
        this.sortChildrenAxioms(tree);
    }

    private void sortChildrenAxioms(ExplanationTree tree) {
        tree.sortChildren(comparator);
    }

    private void buildIndices() {
        this.reset();
        AxiomMapBuilder builder = new AxiomMapBuilder();
        for (OWLAxiom ax : this.currentExplanation) {
            ax.accept((OWLAxiomVisitor)builder);
        }
        try {
            if (this.ont != null) {
                this.man.removeOntology(this.ont);
            }
            this.ont = this.man.createOntology(IRI.create((String)"http://www.semanticweb.org/", (String)("ontology" + randomstart.incrementAndGet())));
            ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
            for (OWLAxiom ax : this.currentExplanation) {
                changes.add(new AddAxiom(this.ont, ax));
                ax.accept((OWLAxiomVisitor)builder);
            }
            this.man.applyChanges(changes);
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private static <K, E> Set<E> getIndexedSet(K obj, Map<K, Set<E>> map, boolean addIfEmpty) {
        Set<E> values = map.get(obj);
        if (values == null) {
            values = new HashSet();
            if (addIfEmpty) {
                map.put(obj, values);
            }
        }
        return values;
    }

    protected Set<OWLAxiom> getAxiomsForLHS(OWLEntity lhs) {
        return ProtegeExplanationOrderer.getIndexedSet(lhs, this.lhs2AxiomMap, true);
    }

    private Collection<OWLEntity> getRHSEntities(OWLAxiom axiom) {
        return ProtegeExplanationOrderer.getIndexedSet(axiom, this.entitiesByAxiomRHS, true);
    }

    protected void indexAxiomsByRHSEntities(OWLObject rhs, OWLAxiom axiom) {
        ProtegeExplanationOrderer.getIndexedSet(axiom, this.entitiesByAxiomRHS, true).addAll(rhs.getSignature());
    }

    private class AxiomMapBuilder
    implements OWLAxiomVisitor {
        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)axiom.getSubClass().asOWLClass()).add((OWLAxiom)axiom);
                ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSuperClass(), (OWLAxiom)axiom);
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add((OWLAxiom)axiom);
            }
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add((OWLAxiom)axiom);
            }
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (!desc.isAnonymous()) {
                    ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)desc.asOWLClass()).add((OWLAxiom)axiom);
                }
                ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)desc, (OWLAxiom)axiom);
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add((OWLAxiom)axiom);
            ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getDomain(), (OWLAxiom)axiom);
        }

        public void visit(OWLImportsDeclaration axiom) {
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add((OWLAxiom)axiom);
            }
            ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getDomain(), (OWLAxiom)axiom);
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!prop.isAnonymous()) {
                    ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)prop.asOWLObjectProperty()).add((OWLAxiom)axiom);
                }
                ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)prop, (OWLAxiom)axiom);
            }
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                if (ind.isAnonymous()) continue;
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)ind.asOWLNamedIndividual()).add((OWLAxiom)axiom);
                ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)ind, (OWLAxiom)axiom);
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)prop.asOWLDataProperty()).add((OWLAxiom)axiom);
                ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)prop, (OWLAxiom)axiom);
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!prop.isAnonymous()) {
                    ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)prop.asOWLObjectProperty()).add((OWLAxiom)axiom);
                }
                ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)prop, (OWLAxiom)axiom);
            }
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add((OWLAxiom)axiom);
            }
            ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getRange(), (OWLAxiom)axiom);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add((OWLAxiom)axiom);
            }
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty()).add((OWLAxiom)axiom);
            }
            ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSuperProperty(), (OWLAxiom)axiom);
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)axiom.getOWLClass()).add((OWLAxiom)axiom);
        }

        public void visit(OWLDeclarationAxiom axiom) {
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add((OWLAxiom)axiom);
            }
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add((OWLAxiom)axiom);
            }
            ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getRange(), (OWLAxiom)axiom);
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add((OWLAxiom)axiom);
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)prop.asOWLDataProperty()).add((OWLAxiom)axiom);
                ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)prop, (OWLAxiom)axiom);
            }
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getIndividual().isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)axiom.getIndividual().asOWLNamedIndividual()).add((OWLAxiom)axiom);
                ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getClassExpression(), (OWLAxiom)axiom);
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (!desc.isAnonymous()) {
                    ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)desc.asOWLClass()).add((OWLAxiom)axiom);
                }
                ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)desc, (OWLAxiom)axiom);
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSubject(), (OWLAxiom)axiom);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add((OWLAxiom)axiom);
            }
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add((OWLAxiom)axiom);
            }
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty()).add((OWLAxiom)axiom);
            ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSuperProperty(), (OWLAxiom)axiom);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add((OWLAxiom)axiom);
            }
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                if (ind.isAnonymous()) continue;
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)ind.asOWLNamedIndividual()).add((OWLAxiom)axiom);
                ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)ind, (OWLAxiom)axiom);
            }
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            if (!axiom.getFirstProperty().isAnonymous()) {
                ProtegeExplanationOrderer.this.getAxiomsForLHS((OWLEntity)axiom.getFirstProperty().asOWLObjectProperty()).add((OWLAxiom)axiom);
            }
            ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getFirstProperty(), (OWLAxiom)axiom);
            ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSecondProperty(), (OWLAxiom)axiom);
        }

        public void visit(SWRLRule rule) {
        }

        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                ProtegeExplanationOrderer.this.indexAxiomsByRHSEntities((OWLObject)axiom.getClassExpression().asOWLClass(), (OWLAxiom)axiom);
            }
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        }
    }

    private static class SeedExtractor
    implements OWLAxiomVisitor {
        private OWLEntity source;
        private OWLEntity target;

        public OWLEntity getSource(OWLAxiom axiom) {
            axiom.accept((OWLAxiomVisitor)this);
            return this.source;
        }

        public OWLEntity getTarget(OWLAxiom axiom) {
            axiom.accept((OWLAxiomVisitor)this);
            return this.target;
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            OWLClassExpression classExpression;
            if (!axiom.getSubClass().isAnonymous()) {
                this.source = axiom.getSubClass().asOWLClass();
            }
            if (!axiom.getSuperClass().isOWLNothing() && !(classExpression = axiom.getSuperClass()).isAnonymous()) {
                this.target = classExpression.asOWLClass();
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                if (ce.isAnonymous()) continue;
                if (this.source == null) {
                    this.source = ce.asOWLClass();
                    continue;
                }
                if (this.target != null) break;
                this.target = ce.asOWLClass();
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
        }

        public void visit(OWLImportsDeclaration axiom) {
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isAnonymous()) {
                this.source = ((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty();
            }
            if (!((OWLObjectPropertyExpression)axiom.getSuperProperty()).isAnonymous()) {
                this.target = ((OWLObjectPropertyExpression)axiom.getSuperProperty()).asOWLObjectProperty();
            }
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
        }

        public void visit(OWLDeclarationAxiom axiom) {
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                this.source = axiom.getIndividual().asOWLNamedIndividual();
                this.target = axiom.getClassExpression().asOWLClass();
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClass cls : axiom.getNamedClasses()) {
                if (this.source == null) {
                    this.source = cls;
                    continue;
                }
                if (this.target != null) break;
                this.target = cls;
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSameIndividualAxiom axiom) {
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        }

        public void visit(SWRLRule rule) {
        }

        public void visit(OWLHasKeyAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
        }
    }

    private static final class OWLAxiomTreeComparator
    implements Comparator<Tree<OWLAxiom>>,
    Serializable {
        private static final long serialVersionUID = 30406L;

        @Override
        public int compare(Tree<OWLAxiom> o1, Tree<OWLAxiom> o2) {
            OWLAxiom ax1 = (OWLAxiom)o1.getUserObject();
            OWLAxiom ax2 = (OWLAxiom)o2.getUserObject();
            if (ax1 instanceof OWLEquivalentClassesAxiom) {
                return 1;
            }
            if (ax2 instanceof OWLEquivalentClassesAxiom) {
                return -1;
            }
            if (ax1 instanceof OWLPropertyAxiom) {
                return -1;
            }
            int childCount1 = o1.getChildCount();
            childCount1 = childCount1 > 0 ? 0 : 1;
            int childCount2 = o2.getChildCount();
            int diff = childCount1 - (childCount2 = childCount2 > 0 ? 0 : 1);
            if (diff != 0) {
                return diff;
            }
            if (ax1 instanceof OWLSubClassOfAxiom && ax2 instanceof OWLSubClassOfAxiom) {
                OWLSubClassOfAxiom sc1 = (OWLSubClassOfAxiom)ax1;
                OWLSubClassOfAxiom sc2 = (OWLSubClassOfAxiom)ax2;
                return sc1.getSuperClass().compareTo((Object)sc2.getSuperClass());
            }
            return 1;
        }
    }

    private static final class PropertiesFirstComparator
    implements Comparator<OWLObject> {
        @Override
        public int compare(OWLObject o1, OWLObject o2) {
            if (o1 instanceof OWLProperty) {
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            return 1;
        }
    }
}

