/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.Scrollable;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.explanation.AxiomSelectionListener;
import uk.ac.manchester.cs.owl.explanation.AxiomSelectionModel;
import uk.ac.manchester.cs.owl.explanation.AxiomSelectionModelImpl;
import uk.ac.manchester.cs.owl.explanation.EntailmentSelectionListener;
import uk.ac.manchester.cs.owl.explanation.ExplanationDisplay;
import uk.ac.manchester.cs.owl.explanation.ExplanationDisplayList;
import uk.ac.manchester.cs.owl.explanation.ExplanationManagerListener;
import uk.ac.manchester.cs.owl.explanation.JustificationFrameExplanationDisplay;
import uk.ac.manchester.cs.owl.explanation.JustificationManager;
import uk.ac.manchester.cs.owl.explanation.JustificationType;
import uk.ac.manchester.cs.owl.explanation.WorkbenchManager;
import uk.ac.manchester.cs.owl.explanation.WorkbenchSettings;

public class WorkbenchPanel
extends JPanel
implements Disposable,
OWLModelManagerListener,
EntailmentSelectionListener,
AxiomSelectionModel,
ExplanationManagerListener {
    private OWLEditorKit editorKit;
    private JComponent explanationDisplayHolder;
    private JScrollPane scrollPane;
    private JSpinner maxExplanationsSelector = new JSpinner();
    private Collection<ExplanationDisplay> panels;
    private AxiomSelectionModelImpl selectionModel;
    private WorkbenchManager workbenchManager;
    private static final Logger logger = LoggerFactory.getLogger(WorkbenchPanel.class);

    public WorkbenchPanel(OWLEditorKit ek, OWLAxiom entailment) {
        this.editorKit = ek;
        WorkspaceFrame workspaceFrame = ProtegeManager.getInstance().getFrame((Workspace)ek.getWorkspace());
        JustificationManager justificationManager = JustificationManager.getExplanationManager((JFrame)workspaceFrame, ek.getOWLModelManager());
        this.workbenchManager = new WorkbenchManager(justificationManager, entailment);
        this.setLayout(new BorderLayout());
        this.selectionModel = new AxiomSelectionModelImpl();
        this.panels = new ArrayList<ExplanationDisplay>();
        this.editorKit.getModelManager().addListener((OWLModelManagerListener)this);
        this.explanationDisplayHolder = new Box(1);
        HolderPanel pan = new HolderPanel(new BorderLayout());
        pan.add((Component)this.explanationDisplayHolder, "North");
        this.scrollPane = new JScrollPane(pan);
        this.scrollPane.setBorder(null);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.getViewport().setBackground(null);
        this.scrollPane.setOpaque(false);
        JPanel rhsPanel = new JPanel(new BorderLayout(7, 7));
        JPanel explanationListPanel = new JPanel(new BorderLayout());
        explanationListPanel.add(this.scrollPane);
        explanationListPanel.setMinimumSize(new Dimension(10, 10));
        JComponent headerPanel = this.createHeaderPanel();
        JPanel headerPanelHolder = new JPanel(new BorderLayout());
        headerPanelHolder.add((Component)headerPanel, "West");
        explanationListPanel.add((Component)headerPanelHolder, "North");
        rhsPanel.add(explanationListPanel);
        this.add(rhsPanel);
        this.refill();
    }

    private JComponent createHeaderPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel headerPanel = new JPanel(layout);
        final WorkbenchSettings workbenchSettings = this.workbenchManager.getWorkbenchSettings();
        JRadioButton regularButton = new JRadioButton(new AbstractAction("Show regular justifications"){

            @Override
            public void actionPerformed(ActionEvent e) {
                workbenchSettings.setJustificationType(JustificationType.REGULAR);
                WorkbenchPanel.this.refill();
            }
        });
        regularButton.setSelected(true);
        headerPanel.add((Component)regularButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(0, 0, 2, 30), 0, 0));
        JRadioButton laconicButton = new JRadioButton(new AbstractAction("Show laconic justifications"){

            @Override
            public void actionPerformed(ActionEvent e) {
                workbenchSettings.setJustificationType(JustificationType.LACONIC);
                WorkbenchPanel.this.refill();
            }
        });
        headerPanel.add((Component)laconicButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 2, new Insets(0, 0, 0, 30), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(regularButton);
        bg.add(laconicButton);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(workbenchSettings.getLimit(), 1, 900, 1);
        this.maxExplanationsSelector.setModel(spinnerModel);
        this.maxExplanationsSelector.setEnabled(!workbenchSettings.isFindAllExplanations());
        final JRadioButton computeAllExplanationsRadioButton = new JRadioButton();
        computeAllExplanationsRadioButton.setAction(new AbstractAction("All justifications"){

            @Override
            public void actionPerformed(ActionEvent e) {
                workbenchSettings.setFindAllExplanations(computeAllExplanationsRadioButton.isSelected());
                WorkbenchPanel.this.maxExplanationsSelector.setEnabled(!workbenchSettings.isFindAllExplanations());
                WorkbenchPanel.this.refill();
            }
        });
        JRadioButton computeMaxExplanationsRadioButton = new JRadioButton();
        computeMaxExplanationsRadioButton.setAction(new AbstractAction("Limit justifications to"){

            @Override
            public void actionPerformed(ActionEvent e) {
                workbenchSettings.setFindAllExplanations(false);
                WorkbenchPanel.this.maxExplanationsSelector.setEnabled(!workbenchSettings.isFindAllExplanations());
                WorkbenchPanel.this.refill();
            }
        });
        ButtonGroup limitButtonGroup = new ButtonGroup();
        limitButtonGroup.add(computeAllExplanationsRadioButton);
        limitButtonGroup.add(computeMaxExplanationsRadioButton);
        if (workbenchSettings.isFindAllExplanations()) {
            computeAllExplanationsRadioButton.setSelected(true);
        } else {
            computeMaxExplanationsRadioButton.setSelected(true);
        }
        headerPanel.add((Component)computeAllExplanationsRadioButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
        headerPanel.add((Component)computeMaxExplanationsRadioButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
        Timer spinnerUpdateTimer = new Timer(800, e -> {
            workbenchSettings.setLimit((Integer)this.maxExplanationsSelector.getValue());
            this.refill();
        });
        spinnerUpdateTimer.setRepeats(false);
        headerPanel.add((Component)this.maxExplanationsSelector, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.maxExplanationsSelector.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
        this.maxExplanationsSelector.addChangeListener(e -> spinnerUpdateTimer.restart());
        return headerPanel;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    @Override
    public void explanationLimitChanged(JustificationManager explanationManager) {
        this.maxExplanationsSelector.setEnabled(!this.workbenchManager.getWorkbenchSettings().isFindAllExplanations());
        this.selectionChanged();
    }

    @Override
    public void explanationsComputed(OWLAxiom entailment) {
    }

    @Override
    public void selectionChanged() {
        this.refill();
    }

    protected ExplanationDisplay createExplanationDisplay(Explanation<OWLAxiom> explanation, int num, int total, int limit) {
        return new JustificationFrameExplanationDisplay(this.editorKit, this, this.workbenchManager, explanation);
    }

    private void refill() {
        try {
            this.panels.forEach(ExplanationDisplay::dispose);
            this.explanationDisplayHolder.removeAll();
            this.explanationDisplayHolder.validate();
            OWLAxiom entailment = this.workbenchManager.getEntailment();
            WorkbenchSettings settings = this.workbenchManager.getWorkbenchSettings();
            Set<Explanation<OWLAxiom>> justifications = this.workbenchManager.getJustifications(entailment);
            List<Explanation<OWLAxiom>> exps = this.getOrderedExplanations(justifications);
            int count = 1;
            for (Explanation<OWLAxiom> exp : exps) {
                ExplanationDisplay explanationDisplayPanel = this.createExplanationDisplay(exp, count, exps.size(), settings.getLimit());
                ExplanationDisplayList list = new ExplanationDisplayList(this.editorKit, this.workbenchManager, explanationDisplayPanel, count);
                list.setBorder(BorderFactory.createEmptyBorder(2, 0, 10, 0));
                this.explanationDisplayHolder.add(list);
                this.panels.add(explanationDisplayPanel);
                if (settings.isFindAllExplanations() || ++count <= settings.getLimit()) continue;
                break;
            }
            this.explanationDisplayHolder.add(Box.createVerticalStrut(10));
            this.scrollPane.validate();
        }
        catch (ExplanationException e) {
            logger.error("An error occurred whilst computing explanations: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected List<Explanation<OWLAxiom>> getOrderedExplanations(Set<Explanation<OWLAxiom>> explanations) {
        ArrayList<Explanation<OWLAxiom>> orderedExplanations = new ArrayList<Explanation<OWLAxiom>>();
        orderedExplanations.addAll(explanations);
        Collections.sort(orderedExplanations, new Comparator<Explanation<OWLAxiom>>(){

            @Override
            public int compare(Explanation<OWLAxiom> o1, Explanation<OWLAxiom> o2) {
                int diff = WorkbenchPanel.this.getAxiomTypes((Explanation<OWLAxiom>)o1).size() - WorkbenchPanel.this.getAxiomTypes((Explanation<OWLAxiom>)o2).size();
                if (diff != 0) {
                    return diff;
                }
                diff = WorkbenchPanel.this.getClassExpressionTypes((Explanation<OWLAxiom>)o1).size() - WorkbenchPanel.this.getClassExpressionTypes((Explanation<OWLAxiom>)o2).size();
                if (diff != 0) {
                    return diff;
                }
                return o1.getSize() - o2.getSize();
            }
        });
        return orderedExplanations;
    }

    private Set<AxiomType<?>> getAxiomTypes(Explanation<OWLAxiom> explanation) {
        HashSet result = new HashSet();
        for (OWLAxiom ax : explanation.getAxioms()) {
            result.add(ax.getAxiomType());
        }
        return result;
    }

    private Set<ClassExpressionType> getClassExpressionTypes(Explanation<OWLAxiom> explanation) {
        HashSet<ClassExpressionType> result = new HashSet<ClassExpressionType>();
        for (OWLAxiom ax : explanation.getAxioms()) {
            result.addAll(ax.getNestedClassExpressions().stream().map(OWLClassExpression::getClassExpressionType).collect(Collectors.toList()));
        }
        return result;
    }

    public void dispose() {
        this.editorKit.getModelManager().removeListener((OWLModelManagerListener)this);
        for (ExplanationDisplay panel : this.panels) {
            panel.dispose();
        }
    }

    public void handleChange(OWLModelManagerChangeEvent event) {
    }

    @Override
    public void addAxiomSelectionListener(AxiomSelectionListener lsnr) {
        this.selectionModel.addAxiomSelectionListener(lsnr);
    }

    @Override
    public void removeAxiomSelectionListener(AxiomSelectionListener lsnr) {
        this.selectionModel.removeAxiomSelectionListener(lsnr);
    }

    @Override
    public void setAxiomSelected(OWLAxiom axiom, boolean b) {
        this.selectionModel.setAxiomSelected(axiom, b);
    }

    @Override
    public Set<OWLAxiom> getSelectedAxioms() {
        return this.selectionModel.getSelectedAxioms();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension workspaceSize = this.editorKit.getWorkspace().getSize();
        int width = (int)(workspaceSize.getWidth() * 0.8);
        int height = (int)(workspaceSize.getHeight() * 0.7);
        return new Dimension(width, height);
    }

    private class HolderPanel
    extends JPanel
    implements Scrollable {
        public HolderPanel(LayoutManager layout) {
            super(layout);
            this.setOpaque(false);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return super.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 30;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 30;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

