/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.DeclHandler;

public final class SAXParsers {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAXParsers.class);

    private SAXParsers() {
    }

    public static SAXParserFactory initFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        try {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new OWLRuntimeException(e);
        }
        factory.setNamespaceAware(true);
        return factory;
    }

    public static SAXParser initParserWithOWLAPIStandards(DeclHandler handler) {
        try {
            SAXParser parser = SAXParsers.initFactory().newSAXParser();
            try {
                parser.setProperty("http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit", "100000000");
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                LOGGER.warn("http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit not supported by parser type " + parser.getClass().getName());
                try {
                    parser.setProperty("entityExpansionLimit", "100000000");
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException ex) {
                    LOGGER.warn("entityExpansionLimit not supported by parser type " + parser.getClass().getName());
                }
            }
            if (handler != null) {
                try {
                    parser.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                    LOGGER.warn("http://xml.org/sax/properties/declaration-handler not supported by parser type " + parser.getClass().getName() + ": entity declarations will not be roundtripped.");
                }
            }
            return parser;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new OWLRuntimeException(e);
        }
    }
}

