/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.framework;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Optional;
import org.osgi.framework.Version;
import org.protege.osgi.framework.SymbolicName;

public class BundleInfo {
    private static final int BEFORE_OTHER = -1;
    private static final int AFTER_OTHER = 1;
    private static final int SAME = 0;
    private final File bundleFile;
    private final SymbolicName symbolicName;
    private final Optional<Version> version;

    public BundleInfo(File bundleFile, SymbolicName symbolicName, Optional<Version> version) {
        this.bundleFile = (File)Preconditions.checkNotNull((Object)bundleFile);
        this.symbolicName = (SymbolicName)Preconditions.checkNotNull((Object)symbolicName);
        this.version = (Optional)Preconditions.checkNotNull(version);
    }

    public File getBundleFile() {
        return this.bundleFile;
    }

    public SymbolicName getSymbolicName() {
        return this.symbolicName;
    }

    public Optional<Version> getVersion() {
        return this.version;
    }

    public int compareByVersion(BundleInfo other) {
        if (this.version.isPresent()) {
            if (other.version.isPresent()) {
                return this.version.get().compareTo(other.version.get());
            }
            return -1;
        }
        if (other.version.isPresent()) {
            return 1;
        }
        return 0;
    }

    public boolean isNewerVersionThan(BundleInfo other) {
        return this.compareByVersion(other) > 0;
    }

    public boolean isNewerTimestampThan(BundleInfo other) {
        return this.bundleFile.lastModified() > other.bundleFile.lastModified();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bundleFile, this.symbolicName, this.version});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BundleInfo)) {
            return false;
        }
        BundleInfo other = (BundleInfo)obj;
        return this.bundleFile.equals(other.bundleFile) && this.symbolicName.equals(other.symbolicName) && this.version.equals(other.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BundleInfo").addValue((Object)this.bundleFile).addValue((Object)this.symbolicName).addValue(this.version).toString();
    }
}

