/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.framework;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.osgi.framework.Version;
import org.protege.osgi.framework.BundleInfo;
import org.protege.osgi.framework.SymbolicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleSearchPath {
    private Logger logger = LoggerFactory.getLogger((String)BundleSearchPath.class.getCanonicalName());
    public static final String USER_HOME = "user.home";
    public static final String USER_HOME_VAR = "${user.home}/";
    private List<File> path = new ArrayList<File>();
    private List<String> allowedBundles = new ArrayList<String>();

    public void addSearchPath(String dir) {
        if (dir.startsWith(USER_HOME_VAR)) {
            String homeDirectory = System.getProperty(USER_HOME);
            dir = dir.substring(USER_HOME_VAR.length());
            this.path.add(new File(homeDirectory, dir));
        } else {
            this.path.add(new File(dir));
        }
    }

    public List<File> getPath() {
        return this.path;
    }

    public List<String> getAllowedBundles() {
        return this.allowedBundles;
    }

    public void addAllowedBundle(String bundle) {
        this.allowedBundles.add(bundle);
    }

    public Collection<File> search() {
        LinkedHashMap<SymbolicName, BundleInfo> nameToFileMap = new LinkedHashMap<SymbolicName, BundleInfo>();
        for (File dir : this.path) {
            File[] contents;
            if (!dir.exists() || !dir.isDirectory() || (contents = dir.listFiles()) == null) continue;
            for (File jar : contents) {
                Optional<BundleInfo> parseBundleInfo;
                String jarName = jar.getName();
                if (!jar.getName().endsWith(".jar") || !this.isAllowedBundle(jarName) || !(parseBundleInfo = this.toBundleInfo(jar)).isPresent()) continue;
                this.addJar(parseBundleInfo.get(), nameToFileMap);
            }
        }
        return nameToFileMap.values().stream().map(BundleInfo::getBundleFile).collect(Collectors.toList());
    }

    private boolean isAllowedBundle(String jarName) {
        return this.allowedBundles.isEmpty() || this.allowedBundles.contains(jarName);
    }

    private void addJar(BundleInfo bundleInfo, Map<SymbolicName, BundleInfo> nameToFileMap) {
        SymbolicName symbolicName = bundleInfo.getSymbolicName();
        BundleInfo existingBundleInfo = nameToFileMap.get(symbolicName);
        if (existingBundleInfo == null) {
            nameToFileMap.put(symbolicName, bundleInfo);
            return;
        }
        if (bundleInfo.isNewerVersionThan(existingBundleInfo)) {
            nameToFileMap.put(symbolicName, bundleInfo);
            this.logger.warn("Found duplicate plugin/bundle.  Using the latest version, {} and ignoring the previous version, {}.", (Object)bundleInfo.getBundleFile().getName(), (Object)existingBundleInfo.getBundleFile().getName());
        } else if (bundleInfo.isNewerTimestampThan(existingBundleInfo)) {
            nameToFileMap.put(symbolicName, bundleInfo);
            this.logger.warn("Found duplicate plugin/bundle. Using the most recent, {} (modified {}) and ignoring the older copy, {} (modified {}).", new Object[]{bundleInfo.getBundleFile().getName(), String.format("%tc", bundleInfo.getBundleFile().lastModified()), existingBundleInfo.getBundleFile().getName(), String.format("%tc", existingBundleInfo.getBundleFile().lastModified())});
        } else {
            this.logger.warn("Ignoring plugin/bundle ({}) because it is a duplicate of {}.", (Object)existingBundleInfo.getBundleFile().getName(), (Object)bundleInfo.getBundleFile().getName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<BundleInfo> toBundleInfo(File file) {
        try (JarInputStream is = new JarInputStream(new FileInputStream(file));){
            Manifest mf = is.getManifest();
            Attributes attributes = mf.getMainAttributes();
            String symbolicName = attributes.getValue("Bundle-SymbolicName");
            if (symbolicName == null) {
                Optional<BundleInfo> optional2 = Optional.empty();
                return optional2;
            }
            String versionString = attributes.getValue("Bundle-Version");
            Optional<Version> version = versionString == null ? Optional.empty() : Optional.of(new Version(versionString));
            Optional<BundleInfo> optional = Optional.of(new BundleInfo(file, new SymbolicName(symbolicName), version));
            return optional;
        }
        catch (Exception e) {
            this.logger.warn("Could not parse {} as plugin/bundle. Error: ", (Object)file, (Object)e);
            return Optional.empty();
        }
    }

    public String toString() {
        MoreObjects.ToStringHelper ts = MoreObjects.toStringHelper((String)"BundleSearchPath");
        for (File path : this.getPath()) {
            ts.add("path", (Object)path.getAbsolutePath());
        }
        for (String allowedBundle : this.allowedBundles) {
            ts.add("allowedBundle", (Object)allowedBundle);
        }
        return ts.toString();
    }
}

