/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.framework;

import com.google.common.base.Objects;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public class NameWithVersion
implements Comparable<NameWithVersion> {
    private static final Pattern VERSION_NUMBER_PATTERN = Pattern.compile("[0-9]+(\\.[0-9]+)*");
    private final String fileName;

    public NameWithVersion(String fileName) {
        this.fileName = fileName;
    }

    private List<Comparable> split() {
        Matcher matcher = VERSION_NUMBER_PATTERN.matcher(this.fileName);
        int prevEnd = 0;
        ArrayList<Comparable> components = new ArrayList<Comparable>();
        while (matcher.find()) {
            int start = matcher.start();
            if (prevEnd != start) {
                String prev = this.fileName.substring(prevEnd, start);
                components.add(new StringComponent(prev));
            }
            prevEnd = matcher.end();
            String versionComponents = this.fileName.substring(matcher.start(), matcher.end());
            components.add(new VersionComponent(new Version(versionComponents)));
        }
        if (prevEnd < this.fileName.length()) {
            components.add(new StringComponent(this.fileName.substring(prevEnd + 1)));
        }
        return components;
    }

    public String toString() {
        return Objects.toStringHelper((String)"PluginFileName").addValue((Object)this.fileName).toString();
    }

    @Override
    public int compareTo(NameWithVersion o) {
        return Ordering.natural().lexicographical().compare(this.split(), o.split());
    }

    private static class VersionComponent
    extends NameComponent {
        private Version version;

        public VersionComponent(Version version) {
            this.version = version;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof VersionComponent) {
                return this.version.compareTo(((VersionComponent)o).version);
            }
            return 1;
        }

        public String toString() {
            return Objects.toStringHelper((String)"VersionComponent").addValue((Object)this.version).toString();
        }
    }

    private static class StringComponent
    extends NameComponent {
        private String component;

        public StringComponent(String component) {
            this.component = component;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof StringComponent) {
                return this.component.compareTo(((StringComponent)o).component);
            }
            return -1;
        }

        public String toString() {
            return Objects.toStringHelper((String)"StringComponent").addValue((Object)this.component).toString();
        }
    }

    private static abstract class NameComponent
    implements Comparable<Object> {
        private NameComponent() {
        }
    }
}

