/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl;

import com.google.common.base.Optional;
import java.io.File;
import java.net.ProtocolException;
import java.net.URI;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.protege.editor.core.BookMarkedURIManager;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.editorkit.AbstractEditorKit;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitDescriptor;
import org.protege.editor.core.editorkit.EditorKitFactory;
import org.protege.editor.core.editorkit.RecentEditorKitManager;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.owl.OWLEditorKitFactory;
import org.protege.editor.owl.ProtegeOWL;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLModelManagerImpl;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.model.io.IOListenerPlugin;
import org.protege.editor.owl.model.io.IOListenerPluginInstance;
import org.protege.editor.owl.model.io.IOListenerPluginLoader;
import org.protege.editor.owl.model.search.SearchManager;
import org.protege.editor.owl.model.search.SearchMetadataImportManager;
import org.protege.editor.owl.ui.OntologyFormatPanel;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.error.OntologyLoadErrorHandlerUI;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.ontology.OntologyPreferences;
import org.protege.editor.owl.ui.ontology.imports.missing.MissingImportHandlerUI;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLEditorKit
extends AbstractEditorKit<OWLEditorKitFactory> {
    private static final Logger logger = LoggerFactory.getLogger(OWLEditorKit.class);
    public static final String ID = "OWLEditorKit";
    public static final String URI_KEY = "URI";
    public static final String FILE_URI_SCHEME = "file";
    private OWLWorkspace workspace;
    private OWLModelManager modelManager;
    private Set<URI> newPhysicalURIs;
    private OntologyLoadErrorHandlerUI loadErrorHandler;
    private ServiceRegistration registration;
    private boolean modifiedDocument = false;
    private OWLOntologyChangeListener ontologyChangeListener;
    private SearchManager searchManager;

    public OWLEditorKit(OWLEditorKitFactory editorKitFactory) {
        super((EditorKitFactory)editorKitFactory);
    }

    protected void initialise() {
        logger.info("OWL API Version: {}", (Object)VersionInfo.getVersionInfo().getVersion());
        this.newPhysicalURIs = new HashSet<URI>();
        this.modelManager = new OWLModelManagerImpl();
        this.modelManager.setExplanationManager(new ExplanationManager(this));
        this.modelManager.setMissingImportHandler(new MissingImportHandlerUI(this));
        this.modelManager.setSaveErrorHandler(this::handleSaveError);
        this.ontologyChangeListener = owlOntologyChanges -> {
            this.modifiedDocument = true;
        };
        this.modelManager.addOntologyChangeListener(this.ontologyChangeListener);
        this.searchManager = new SearchManager(this, new SearchMetadataImportManager());
        this.loadErrorHandler = new OntologyLoadErrorHandlerUI(this);
        this.modelManager.setLoadErrorHandler(this.loadErrorHandler);
        this.loadIOListenerPlugins();
        this.registration = ProtegeOWL.getBundleContext().registerService(EditorKit.class.getCanonicalName(), (Object)this, new Hashtable());
        this.getWorkspace().refreshComponents();
    }

    public boolean hasModifiedDocument() {
        return this.modifiedDocument;
    }

    @Deprecated
    public void setOWLModelManager(OWLModelManager modelManager) {
        this.modelManager = modelManager;
        ServiceReference sr = ProtegeOWL.getBundleContext().getServiceReference(PackageAdmin.class.getCanonicalName());
        PackageAdmin admin = (PackageAdmin)ProtegeOWL.getBundleContext().getService(sr);
        Bundle customizer = admin.getBundle(modelManager.getClass());
        String name = (String)customizer.getHeaders().get("Bundle-Name");
        if (name == null) {
            name = customizer.getSymbolicName();
        }
        this.getOWLWorkspace().setCustomizedBy("Prot\u00e9g\u00e9 Customized by " + name);
    }

    public String getId() {
        return ID;
    }

    public OWLWorkspace getWorkspace() {
        if (this.workspace == null) {
            this.workspace = new OWLWorkspace();
            this.workspace.setup((EditorKit)this);
            this.workspace.initialise();
        }
        return this.workspace;
    }

    public OWLWorkspace getOWLWorkspace() {
        return this.getWorkspace();
    }

    public OWLModelManager getModelManager() {
        return this.modelManager;
    }

    public OWLModelManager getOWLModelManager() {
        return this.getModelManager();
    }

    public SearchManager getSearchManager() {
        return this.searchManager;
    }

    public boolean handleLoadRecentRequest(EditorKitDescriptor descriptor) throws Exception {
        URI uri = descriptor.getURI(URI_KEY);
        return uri != null && this.handleLoadFrom(uri);
    }

    public boolean handleLoadRequest() throws Exception {
        File f = new UIHelper(this).chooseOWLFile("Select an OWL file");
        return f != null && this.handleLoadFrom(f.toURI());
    }

    public boolean handleLoadFrom(URI uri) throws Exception {
        this.loadErrorHandler.setReloadFlag(false);
        boolean success = ((OWLModelManagerImpl)this.getModelManager()).loadOntologyFromPhysicalURI(uri);
        if (success) {
            this.addRecent(uri);
        } else if (this.loadErrorHandler.getReloadFlag()) {
            success = this.handleLoadFrom(uri);
        }
        this.modifiedDocument = true;
        return success;
    }

    private OWLOntologyID createDefaultOntologyId() {
        return new OWLOntologyID(Optional.of((Object)this.createFreshOntologyIRI()), Optional.absent());
    }

    private IRI createFreshOntologyIRI() {
        OntologyPreferences ontologyPreferences = OntologyPreferences.getInstance();
        return IRI.create((URI)ontologyPreferences.generateNextURI());
    }

    public boolean handleNewRequest() throws Exception {
        OWLOntologyID id = this.createDefaultOntologyId();
        OWLOntology ont = this.getModelManager().createNewOntology(id, URI.create(((IRI)id.getDefaultDocumentIRI().get()).toString()));
        OWLOntologyManager owlOntologyManager = this.getModelManager().getOWLOntologyManager();
        owlOntologyManager.setOntologyFormat(ont, (OWLDocumentFormat)new RDFXMLDocumentFormat());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSave() throws Exception {
        try {
            logger.info(LogBanner.start((String)"Saving Workspace and Ontologies"));
            Set<OWLOntology> dirtyOntologies = this.getModelManager().getDirtyOntologies();
            this.getWorkspace().save();
            if (dirtyOntologies.isEmpty()) {
                logger.info("No ontology changes detected.  Not writing any ontology documents.");
                return;
            }
            try {
                this.getModelManager().save();
                this.newPhysicalURIs.forEach(this::addRecent);
                this.newPhysicalURIs.clear();
                logger.info("Saved ontologies");
            }
            catch (OWLOntologyStorageException e) {
                OWLOntology ont = this.getModelManager().getActiveOntology();
                OWLDocumentFormat format = this.getModelManager().getOWLOntologyManager().getOntologyFormat(ont);
                String message = String.format("Could not save ontology in the specified format (%s).\nPlease select 'Save As' and choose another format.", format);
                logger.warn(message);
                ErrorLogPanel.showErrorDialog((Throwable)new OWLOntologyStorageException(message, (Throwable)e));
            }
        }
        finally {
            logger.info(LogBanner.end());
        }
    }

    public void handleSaveAs() throws Exception {
        OWLOntology ont = this.getModelManager().getActiveOntology();
        this.handleSaveAs(ont);
    }

    private boolean handleSaveAs(OWLOntology ont) throws Exception {
        File file;
        OWLOntologyManager man = this.getModelManager().getOWLOntologyManager();
        OWLDocumentFormat oldFormat = man.getOntologyFormat(ont);
        OWLDocumentFormat format = OntologyFormatPanel.showDialog(this, oldFormat, String.format("<html><body><div>Choose a format to use when saving the <span style='font-weight: bold;'>'%s'</span> ontology.</div><div style='padding-top: 20px; color: gray'; width: 150px;>(If you are unsure as to what format to choose, we recommend that you use the standard RDF/XML format, or a widely supported format such as Turtle)</div></body></html>", this.getModelManager().getRendering((OWLObject)ont)));
        if (format == null) {
            logger.info("No ontology document format has been selected.  Aborting saveAs.");
            return false;
        }
        if (oldFormat instanceof PrefixDocumentFormat && format instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat oldPrefixes = (PrefixDocumentFormat)oldFormat;
            for (String name : oldPrefixes.getPrefixNames()) {
                String prefix = oldPrefixes.getPrefix(name);
                if (prefix == null) continue;
                ((PrefixDocumentFormat)format).setPrefix(name, prefix);
            }
        }
        if ((file = this.getSaveAsOWLFile(ont)) != null) {
            man.setOntologyFormat(ont, format);
            man.setOntologyDocumentIRI(ont, IRI.create((File)file));
            this.getModelManager().save(ont);
            this.addRecent(file.toURI());
            return true;
        }
        return false;
    }

    private File getSaveAsOWLFile(OWLOntology ont) {
        UIHelper helper = new UIHelper(this);
        File file = helper.saveOWLFile(String.format("Please select a location in which to save: %s", this.getModelManager().getRendering((OWLObject)ont)));
        if (file != null) {
            int extensionIndex = file.toString().lastIndexOf(46);
            if (extensionIndex == -1) {
                file = new File(file.toString() + ".owl");
            } else if (extensionIndex != file.toString().length() - 4) {
                file = new File(file.toString() + ".owl");
            }
        }
        return file;
    }

    public void addRecent(URI physicalURI) {
        String label = physicalURI.toString();
        if (FILE_URI_SCHEME.equals(physicalURI.getScheme())) {
            label = new File(physicalURI).getPath();
        } else {
            BookMarkedURIManager.getInstance().add(physicalURI);
        }
        EditorKitDescriptor descriptor = new EditorKitDescriptor(label, this.getEditorKitFactory());
        descriptor.setURI(URI_KEY, physicalURI);
        RecentEditorKitManager.getInstance().add(descriptor);
    }

    private void handleSaveError(OWLOntology ont, URI physicalURIForOntology, OWLOntologyStorageException e) throws Exception {
        if (e.getCause() == null || !(e.getCause() instanceof ProtocolException)) {
            throw e;
        }
        this.handleSaveAs(ont);
    }

    private void loadIOListenerPlugins() {
        IOListenerPluginLoader loader = new IOListenerPluginLoader(this);
        for (IOListenerPlugin pl : loader.getPlugins()) {
            try {
                IOListenerPluginInstance instance = (IOListenerPluginInstance)pl.newInstance();
                this.getModelManager().addIOListener(instance);
            }
            catch (Throwable e) {
                logger.warn("An IOListenerPlugin threw an error: {}", e);
            }
        }
    }

    public Disposable get(Object key) {
        return this.getOWLModelManager().get(key);
    }

    public void put(Object key, Disposable value) {
        this.getOWLModelManager().put(key, value);
    }

    public void dispose() {
        logger.info(LogBanner.start((String)"Disposing of Workspace"));
        this.getModelManager().removeOntologyChangeListener(this.ontologyChangeListener);
        super.dispose();
        this.searchManager.dispose();
        this.workspace.dispose();
        try {
            this.modelManager.dispose();
        }
        catch (Exception e) {
            ErrorLogPanel.showErrorDialog((Throwable)e);
        }
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        logger.info(LogBanner.end());
    }
}

