/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.Serializable;
import java.net.ProtocolException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.protege.editor.core.AbstractModelManager;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.model.MissingImportHandler;
import org.protege.editor.owl.model.MissingImportHandlerImpl;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.SaveErrorHandler;
import org.protege.editor.owl.model.cache.OWLEntityRenderingCache;
import org.protege.editor.owl.model.cache.OWLEntityRenderingCacheImpl;
import org.protege.editor.owl.model.cache.OWLObjectRenderingCache;
import org.protege.editor.owl.model.classexpression.anonymouscls.AnonymousDefinedClassManager;
import org.protege.editor.owl.model.entity.CustomOWLEntityFactory;
import org.protege.editor.owl.model.entity.OWLEntityFactory;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.find.OWLEntityFinder;
import org.protege.editor.owl.model.find.OWLEntityFinderImpl;
import org.protege.editor.owl.model.hierarchy.OWLHierarchyManager;
import org.protege.editor.owl.model.hierarchy.OWLHierarchyManagerImpl;
import org.protege.editor.owl.model.history.HistoryManager;
import org.protege.editor.owl.model.history.HistoryManagerImpl;
import org.protege.editor.owl.model.inference.OWLReasonerManager;
import org.protege.editor.owl.model.inference.OWLReasonerManagerImpl;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.model.io.AutoMappedRepositoryIRIMapper;
import org.protege.editor.owl.model.io.IOListener;
import org.protege.editor.owl.model.io.IOListenerEvent;
import org.protege.editor.owl.model.io.OntologySourcesManager;
import org.protege.editor.owl.model.io.UserResolvedIRIMapper;
import org.protege.editor.owl.model.io.WebConnectionIRIMapper;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.protege.editor.owl.model.selection.ontologies.ImportsClosureOntologySelectionStrategy;
import org.protege.editor.owl.model.selection.ontologies.OntologySelectionStrategy;
import org.protege.editor.owl.model.util.ListenerManager;
import org.protege.editor.owl.ui.OWLObjectRenderingComparator;
import org.protege.editor.owl.ui.clsdescriptioneditor.ManchesterOWLExpressionCheckerFactory;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionCheckerFactory;
import org.protege.editor.owl.ui.error.OntologyLoadErrorHandler;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererImpl;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererListener;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.protege.editor.owl.ui.renderer.OWLObjectRenderer;
import org.protege.editor.owl.ui.renderer.OWLObjectRendererImpl;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.plugin.RendererPlugin;
import org.protege.xmlcatalog.XMLCatalog;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.PriorityCollection;
import org.semanticweb.owlapi.util.SimpleIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyManagerImpl;

public class OWLModelManagerImpl
extends AbstractModelManager
implements OWLModelManager,
OWLEntityRendererListener,
OWLOntologyChangeListener,
OWLOntologyLoaderListener {
    private final Logger logger = LoggerFactory.getLogger(OWLModelManagerImpl.class);
    private final HistoryManager historyManager;
    private OWLModelManagerEntityRenderer entityRenderer;
    private OWLObjectRenderer objectRenderer;
    private OWLOntology activeOntology;
    private OWLEntityRenderingCache owlEntityRenderingCache;
    private OWLObjectRenderingCache owlObjectRenderingCache;
    private OWLEntityFinder entityFinder;
    private final OWLReasonerManager owlReasonerManager;
    private final Set<OWLOntologyID> dirtyOntologies = new HashSet<OWLOntologyID>();
    private final OWLOntologyManager manager;
    private final OntologyCatalogManager ontologyLibraryManager = new OntologyCatalogManager();
    private ExplanationManager explanationManager;
    private OWLEntityFactory entityFactory;
    private final Set<OWLOntology> activeOntologies = new HashSet<OWLOntology>();
    private final Set<OntologySelectionStrategy> ontSelectionStrategies = new HashSet<OntologySelectionStrategy>();
    private OntologySelectionStrategy activeOntologiesStrategy;
    private OWLExpressionCheckerFactory owlExpressionCheckerFactory;
    private SaveErrorHandler saveErrorHandler;
    private OntologyLoadErrorHandler loadErrorHandler;
    private final UserResolvedIRIMapper userResolvedIRIMapper = new UserResolvedIRIMapper(new MissingImportHandlerImpl());
    private final List<OWLModelManagerListener> modelManagerChangeListeners = new ArrayList<OWLModelManagerListener>();
    private final ListenerManager<OWLModelManagerListener> modelManagerListenerManager = new ListenerManager();
    private final ListenerManager<OWLOntologyChangeListener> changeListenerManager = new ListenerManager();
    private final List<IOListener> ioListeners = new ArrayList<IOListener>();

    public OWLModelManagerImpl() {
        this.manager = OWLManager.createConcurrentOWLOntologyManager();
        this.manager.addOntologyChangeListener((OWLOntologyChangeListener)this);
        AutoMappedRepositoryIRIMapper autoMappedRepositoryIRIMapper = new AutoMappedRepositoryIRIMapper(this);
        PriorityCollection iriMappers = this.manager.getIRIMappers();
        iriMappers.clear();
        iriMappers.add((Serializable[])new OWLOntologyIRIMapper[]{this.userResolvedIRIMapper});
        iriMappers.add((Serializable[])new OWLOntologyIRIMapper[]{new WebConnectionIRIMapper()});
        iriMappers.add((Serializable[])new OWLOntologyIRIMapper[]{autoMappedRepositoryIRIMapper});
        this.objectRenderer = new OWLObjectRendererImpl(this);
        this.owlEntityRenderingCache = new OWLEntityRenderingCacheImpl();
        this.owlEntityRenderingCache.setOWLModelManager(this);
        this.owlObjectRenderingCache = new OWLObjectRenderingCache(this);
        this.owlExpressionCheckerFactory = new ManchesterOWLExpressionCheckerFactory(this);
        this.activeOntologiesStrategy = new ImportsClosureOntologySelectionStrategy(this);
        this.historyManager = new HistoryManagerImpl(this);
        this.owlReasonerManager = new OWLReasonerManagerImpl(this);
        this.owlReasonerManager.getReasonerPreferences().addListener(() -> this.fireEvent(EventType.ONTOLOGY_CLASSIFIED));
        this.getOWLEntityRenderer();
        this.put(OntologySourcesManager.ID, new OntologySourcesManager(this));
    }

    public void dispose() {
        super.dispose();
        OntologySourcesManager sourcesMngr = (OntologySourcesManager)this.get(OntologySourcesManager.ID);
        this.removeIOListener(sourcesMngr);
        try {
            this.owlEntityRenderingCache.dispose();
            this.owlObjectRenderingCache.dispose();
            if (this.entityRenderer != null) {
                this.entityRenderer.dispose();
            }
            this.owlReasonerManager.dispose();
        }
        catch (Exception e) {
            this.logger.error("An error occurred whilst disposing of the model manager: {}", (Object)e.getMessage(), (Object)e);
        }
        this.modelManagerListenerManager.dumpWarningForAllListeners(this.logger, "(Listeners should be removed in the plugin dispose method!)");
        this.changeListenerManager.dumpWarningForAllListeners(this.logger, "(Listeners should be removed in the plugin dispose method!)");
    }

    public boolean isDirty() {
        return !this.dirtyOntologies.isEmpty();
    }

    @Override
    public boolean isDirty(OWLOntology ontology) {
        return this.dirtyOntologies.contains(ontology.getOntologyID());
    }

    @Override
    public void setClean(OWLOntology ontology) {
        this.dirtyOntologies.remove(ontology.getOntologyID());
    }

    @Override
    public OWLOntologyManager getOWLOntologyManager() {
        return this.manager;
    }

    @Override
    public OntologyCatalogManager getOntologyCatalogManager() {
        return this.ontologyLibraryManager;
    }

    @Override
    public OWLHierarchyManager getOWLHierarchyManager() {
        OWLHierarchyManager hm = (OWLHierarchyManager)this.get(OWLHierarchyManager.ID);
        if (hm == null) {
            hm = new OWLHierarchyManagerImpl(this);
            this.put(OWLHierarchyManager.ID, hm);
        }
        return hm;
    }

    @Override
    public ExplanationManager getExplanationManager() {
        return this.explanationManager;
    }

    @Override
    public void setExplanationManager(ExplanationManager explanationManager) {
        this.explanationManager = explanationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadOntologyFromPhysicalURI(URI uri) {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        try {
            this.logger.info(LogBanner.start((String)"Loading Ontology"));
            this.logger.info("Loading ontology from {}", (Object)uri);
            stopwatch.start();
            if (UIUtil.isLocalFile((URI)uri)) {
                File parentFile = new File(uri).getParentFile();
                this.addRootFolder(parentFile);
            }
            OWLOntology ontology = null;
            try {
                ontology = this.manager.loadOntologyFromOntologyDocument(IRI.create((URI)uri));
                this.setActiveOntology(ontology);
                this.fireEvent(EventType.ONTOLOGY_LOADED);
                OWLOntologyID id = ontology.getOntologyID();
                if (!id.isAnonymous()) {
                    this.manager.getIRIMappers().add((Serializable[])new OWLOntologyIRIMapper[]{new SimpleIRIMapper((IRI)id.getDefaultDocumentIRI().get(), IRI.create((URI)uri))});
                }
            }
            catch (OWLOntologyCreationException ooce) {
                this.logger.info("Failed to load ontology: {}", (Throwable)ooce);
            }
            boolean bl = ontology != null;
            return bl;
        }
        finally {
            this.logger.info("Loading for ontology and imports closure successfully completed in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            this.logger.info(LogBanner.end());
        }
    }

    public void startedLoadingOntology(OWLOntologyLoaderListener.LoadingStartedEvent event) {
        this.logger.info("Loading {} from {}", (Object)event.getOntologyID(), (Object)event.getDocumentIRI());
        this.fireBeforeLoadEvent(event.getOntologyID(), event.getDocumentIRI().toURI());
    }

    public void finishedLoadingOntology(OWLOntologyLoaderListener.LoadingFinishedEvent event) {
        if (!event.isSuccessful()) {
            Exception e = event.getException();
            if (this.loadErrorHandler != null) {
                try {
                    this.loadErrorHandler.handleErrorLoadingOntology(event.getOntologyID(), event.getDocumentIRI().toURI(), e);
                }
                catch (Throwable e1) {
                    ErrorLogPanel.showErrorDialog((Throwable)e1);
                }
            }
        }
        this.fireAfterLoadEvent(event.getOntologyID(), event.getDocumentIRI().toURI());
    }

    @Override
    public XMLCatalog addRootFolder(File dir) {
        return this.ontologyLibraryManager.addFolder(dir);
    }

    private void fireBeforeLoadEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.beforeLoad(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                this.logger.warn("An IOListener threw an exception during event dispatch: {}", e);
            }
        }
    }

    private void fireAfterLoadEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.afterLoad(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                this.logger.warn("An IOListener threw an exception during event dispatch: {}", e);
            }
        }
    }

    @Override
    public URI getOntologyPhysicalURI(OWLOntology ontology) {
        IRI ontologyDocumentIRI = this.manager.getOntologyDocumentIRI(ontology);
        if (this.isDefaultOWLAPIDocumentIRI(ontologyDocumentIRI)) {
            return URI.create("");
        }
        return ontologyDocumentIRI.toURI();
    }

    private boolean isDefaultOWLAPIDocumentIRI(IRI iri) {
        URI uri = iri.toURI();
        String scheme = uri.getScheme();
        return scheme != null && scheme.equals("owlapi");
    }

    @Override
    public void setPhysicalURI(OWLOntology ontology, URI physicalURI) {
        this.manager.setOntologyDocumentIRI(ontology, IRI.create((URI)physicalURI));
    }

    @Override
    public OWLOntology createNewOntology(OWLOntologyID ontologyID, URI physicalURI) throws OWLOntologyCreationException {
        if (physicalURI != null && ontologyID.getDefaultDocumentIRI().isPresent()) {
            this.manager.getIRIMappers().add((Serializable[])new OWLOntologyIRIMapper[]{new SimpleIRIMapper((IRI)ontologyID.getDefaultDocumentIRI().get(), IRI.create((URI)physicalURI))});
        }
        OWLOntology ont = this.manager.createOntology(ontologyID);
        this.setActiveOntology(ont);
        if (physicalURI != null) {
            try {
                File containingDirectory = new File(physicalURI).getParentFile();
                if (containingDirectory.exists()) {
                    this.getOntologyCatalogManager().addFolder(containingDirectory);
                }
            }
            catch (IllegalArgumentException iae) {
                this.logger.warn("Cannot generate ontology catalog for ontology at " + physicalURI);
            }
        }
        this.fireEvent(EventType.ONTOLOGY_CREATED);
        return ont;
    }

    @Override
    public OWLOntology reload(OWLOntology ont) throws OWLOntologyCreationException {
        IRI ontologyDocumentIRI = IRI.create((URI)this.getOntologyPhysicalURI(ont));
        this.manager.removeOntology(ont);
        boolean wasTheActiveOntology = false;
        if (ont.equals(this.activeOntology)) {
            wasTheActiveOntology = true;
            this.activeOntology = null;
        }
        this.dirtyOntologies.remove(ont.getOntologyID());
        try {
            ont = this.manager.loadOntologyFromOntologyDocument(ontologyDocumentIRI);
        }
        catch (Throwable t) {
            ((OWLOntologyManagerImpl)this.manager).ontologyCreated(ont);
            this.manager.setOntologyDocumentIRI(ont, ontologyDocumentIRI);
            throw t instanceof OWLOntologyCreationException ? (OWLOntologyCreationException)t : new OWLOntologyCreationException(t);
        }
        if (wasTheActiveOntology) {
            this.activeOntology = ont;
        }
        this.rebuildActiveOntologiesCache();
        this.refreshRenderer();
        this.fireEvent(EventType.ONTOLOGY_RELOADED);
        return ont;
    }

    @Override
    public boolean removeOntology(OWLOntology ont) {
        if (this.manager.contains(ont.getOntologyID()) && this.manager.getOntologies().size() > 1) {
            boolean resetActiveOntologyRequired = ont.equals(this.activeOntology);
            this.activeOntologies.remove(ont);
            this.dirtyOntologies.remove(ont.getOntologyID());
            this.manager.removeOntology(ont);
            if (resetActiveOntologyRequired) {
                OWLOntology newActiveOnt = null;
                if (!this.activeOntologies.isEmpty()) {
                    newActiveOnt = this.activeOntologies.iterator().next();
                }
                if (newActiveOnt == null && !this.manager.getOntologies().isEmpty()) {
                    newActiveOnt = (OWLOntology)this.manager.getOntologies().iterator().next();
                }
                this.setActiveOntology(newActiveOnt, true);
            } else {
                this.setActiveOntology(this.activeOntology, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void save() throws OWLOntologyStorageException {
        for (OWLOntologyID ontId : new HashSet<OWLOntologyID>(this.dirtyOntologies)) {
            if (this.manager.contains(ontId)) {
                this.save(this.manager.getOntology(ontId));
                continue;
            }
            this.dirtyOntologies.remove(ontId);
        }
    }

    @Override
    public void save(OWLOntology ont) throws OWLOntologyStorageException {
        URI documentURI = this.manager.getOntologyDocumentIRI(ont).toURI();
        try {
            OWLDocumentFormat format;
            this.fireBeforeSaveEvent(ont.getOntologyID(), documentURI);
            if (!UIUtil.isLocalFile((URI)documentURI)) {
                throw new OWLOntologyStorageException((Throwable)new ProtocolException("Cannot save file to remote location: " + documentURI));
            }
            OWLDocumentFormat previousFormat = this.manager.getOntologyFormat(ont);
            if (previousFormat == null) {
                format = new RDFXMLDocumentFormat();
                this.logger.info("No document format for {} has been found.  Using the {} format.", (Object)ont.getOntologyID(), (Object)format);
            } else {
                format = previousFormat;
            }
            IRI documentIRI = IRI.create((URI)documentURI);
            this.manager.saveOntology(ont, format, documentIRI);
            this.manager.setOntologyDocumentIRI(ont, documentIRI);
            this.logger.info("Saved ontology {} to {} in {} format", new Object[]{ont.getOntologyID(), documentIRI, format});
            this.dirtyOntologies.remove(ont.getOntologyID());
            this.fireEvent(EventType.ONTOLOGY_SAVED);
            this.fireAfterSaveEvent(ont.getOntologyID(), documentURI);
        }
        catch (OWLOntologyStorageException e) {
            if (this.saveErrorHandler != null) {
                try {
                    this.saveErrorHandler.handleErrorSavingOntology(ont, documentURI, e);
                }
                catch (Exception e1) {
                    throw new OWLOntologyStorageException((Throwable)e1);
                }
            }
            throw e;
        }
    }

    @Override
    @Deprecated
    public void saveAs() throws OWLOntologyStorageException {
        this.save();
    }

    private void fireBeforeSaveEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.beforeSave(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                this.logger.warn("An IOListener threw an error during event dispatch: {}", e);
            }
        }
    }

    private void fireAfterSaveEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.afterSave(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                this.logger.warn("An IOListener threw an error during event dispatch: {}", e);
            }
        }
    }

    @Override
    public Set<OWLOntology> getOntologies() {
        return this.manager.getOntologies();
    }

    @Override
    public Set<OWLOntology> getDirtyOntologies() {
        HashSet<OWLOntology> ontologies = new HashSet<OWLOntology>();
        for (OWLOntologyID ontId : new ArrayList<OWLOntologyID>(this.dirtyOntologies)) {
            if (this.manager.contains(ontId)) {
                ontologies.add(this.manager.getOntology(ontId));
                continue;
            }
            this.dirtyOntologies.remove(ontId);
        }
        return ontologies;
    }

    @Override
    public void setDirty(OWLOntology ontology) {
        this.dirtyOntologies.add(ontology.getOntologyID());
    }

    @Override
    public OWLOntology getActiveOntology() {
        return this.activeOntology;
    }

    @Override
    public OWLDataFactory getOWLDataFactory() {
        return this.manager.getOWLDataFactory();
    }

    @Override
    public Set<OWLOntology> getActiveOntologies() {
        return this.activeOntologies;
    }

    @Override
    public boolean isActiveOntologyMutable() {
        return this.isMutable(this.getActiveOntology());
    }

    @Override
    public boolean isMutable(OWLOntology ontology) {
        return true;
    }

    @Override
    public void setActiveOntology(OWLOntology activeOntology) {
        this.setActiveOntology(activeOntology, false);
    }

    @Override
    public void setActiveOntologiesStrategy(OntologySelectionStrategy strategy) {
        this.activeOntologiesStrategy = strategy;
        this.setActiveOntology(this.getActiveOntology(), true);
        this.fireEvent(EventType.ONTOLOGY_VISIBILITY_CHANGED);
    }

    @Override
    public OntologySelectionStrategy getActiveOntologiesStrategy() {
        return this.activeOntologiesStrategy;
    }

    @Override
    public Set<OntologySelectionStrategy> getActiveOntologiesStrategies() {
        return this.ontSelectionStrategies;
    }

    private void setActiveOntology(OWLOntology activeOntology, boolean force) {
        if (!force && this.activeOntology != null && this.activeOntology.equals(activeOntology)) {
            return;
        }
        this.activeOntology = activeOntology;
        this.logger.debug("Setting active ontology to " + activeOntology.getOntologyID());
        this.rebuildActiveOntologiesCache();
        this.entityRenderer.ontologiesChanged();
        this.rebuildEntityIndices();
        this.fireEvent(EventType.ACTIVE_ONTOLOGY_CHANGED);
    }

    @Override
    public void registerOntologySelectionStrategy(OntologySelectionStrategy strategy) {
        this.ontSelectionStrategies.add(strategy);
    }

    private void rebuildActiveOntologiesCache() {
        this.activeOntologies.clear();
        this.activeOntologies.addAll(this.activeOntologiesStrategy.getOntologies());
    }

    @Override
    public void applyChange(OWLOntologyChange change) {
        try {
            AnonymousDefinedClassManager adcManager = (AnonymousDefinedClassManager)this.get(AnonymousDefinedClassManager.ID);
            if (adcManager != null) {
                change = adcManager.getChangeRewriter().rewriteChange(change);
            }
            this.manager.applyChange(change);
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    @Override
    public void applyChanges(List<? extends OWLOntologyChange> changes) {
        try {
            AnonymousDefinedClassManager adcManager = (AnonymousDefinedClassManager)this.get(AnonymousDefinedClassManager.ID);
            if (adcManager != null) {
                changes = adcManager.getChangeRewriter().rewriteChanges(changes);
            }
            this.manager.applyChanges(changes);
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        this.getHistoryManager().logChanges(changes);
        boolean refreshActiveOntology = false;
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (oWLOntologyChange instanceof SetOntologyID) {
                SetOntologyID ontologyIDChange = (SetOntologyID)oWLOntologyChange;
                this.dirtyOntologies.remove(ontologyIDChange.getOriginalOntologyID());
            }
            this.dirtyOntologies.add(oWLOntologyChange.getOntology().getOntologyID());
            if (!oWLOntologyChange.isImportChange()) continue;
            refreshActiveOntology = true;
        }
        if (refreshActiveOntology) {
            this.setActiveOntology(this.getActiveOntology(), true);
        }
    }

    @Override
    public boolean isChangedEntity(OWLEntity entity) {
        return false;
    }

    @Override
    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    @Override
    public void addOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.manager.addOntologyChangeListener(listener);
        this.changeListenerManager.recordListenerAdded(listener);
    }

    @Override
    public void removeOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.manager.removeOntologyChangeListener(listener);
        this.changeListenerManager.recordListenerRemoved(listener);
    }

    @Override
    public void addListener(OWLModelManagerListener listener) {
        this.modelManagerChangeListeners.add(listener);
        this.modelManagerListenerManager.recordListenerAdded(listener);
    }

    @Override
    public void removeListener(OWLModelManagerListener listener) {
        this.modelManagerChangeListeners.remove(listener);
        this.modelManagerListenerManager.recordListenerRemoved(listener);
    }

    @Override
    public void fireEvent(EventType type) {
        this.logger.debug("Firing event {}", (Object)type);
        OWLModelManagerChangeEvent event = new OWLModelManagerChangeEvent(this, type);
        for (OWLModelManagerListener listener : new ArrayList<OWLModelManagerListener>(this.modelManagerChangeListeners)) {
            try {
                listener.handleChange(event);
            }
            catch (Throwable e) {
                this.logger.warn("Exception thrown by listener: {}.  Detatching bad listener.", (Object)listener.getClass().getName());
                this.modelManagerChangeListeners.remove(listener);
            }
        }
    }

    @Override
    public void addIOListener(IOListener listener) {
        this.ioListeners.add(listener);
    }

    @Override
    public void removeIOListener(IOListener listener) {
        this.ioListeners.remove(listener);
    }

    @Override
    public OWLModelManagerEntityRenderer getOWLEntityRenderer() {
        if (this.entityRenderer == null) {
            try {
                OWLRendererPreferences preferences = OWLRendererPreferences.getInstance();
                RendererPlugin plugin = preferences.getRendererPlugin();
                this.entityRenderer = plugin.newInstance();
                this.loadRenderer();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.logger.error(e.getMessage());
            }
            if (this.entityRenderer == null) {
                this.entityRenderer = new OWLEntityRendererImpl();
                this.loadRenderer();
            }
        }
        return this.entityRenderer;
    }

    @Override
    public String getRendering(OWLObject object) {
        if (object instanceof OWLEntity) {
            AnonymousDefinedClassManager adcManager = (AnonymousDefinedClassManager)this.get(AnonymousDefinedClassManager.ID);
            if (adcManager != null && object instanceof OWLClass && adcManager.isAnonymous((OWLClass)object)) {
                return this.owlObjectRenderingCache.getRendering((OWLObject)adcManager.getExpression((OWLClass)object), this.getOWLObjectRenderer());
            }
            this.getOWLEntityRenderer();
            String rendering = this.owlEntityRenderingCache.getRendering((OWLEntity)object);
            if (rendering != null) {
                return rendering;
            }
            return this.getOWLEntityRenderer().render((OWLEntity)object);
        }
        return this.owlObjectRenderingCache.getRendering(object, this.getOWLObjectRenderer());
    }

    @Override
    public void renderingChanged(OWLEntity entity, OWLModelManagerEntityRenderer renderer) {
        this.owlEntityRenderingCache.updateRendering(entity);
        this.owlObjectRenderingCache.clear();
        for (OWLModelManagerListener listener : new ArrayList<OWLModelManagerListener>(this.modelManagerChangeListeners)) {
            listener.handleChange(new OWLModelManagerChangeEvent(this, EventType.ENTITY_RENDERING_CHANGED));
        }
    }

    @Override
    public void refreshRenderer() {
        if (this.entityRenderer != null) {
            this.entityRenderer.removeListener(this);
            try {
                this.entityRenderer.dispose();
            }
            catch (Exception e) {
                this.logger.warn("An error occurred whilst disposing of the entity renderer: {}", (Throwable)e);
            }
        }
        this.entityRenderer = null;
        this.getOWLEntityRenderer();
        this.loadRenderer();
    }

    private void loadRenderer() {
        this.entityRenderer.addListener(this);
        this.entityRenderer.setup(this);
        this.entityRenderer.initialise();
        this.rebuildEntityIndices();
        this.fireEvent(EventType.ENTITY_RENDERER_CHANGED);
    }

    @Override
    public void setOWLEntityRenderer(OWLModelManagerEntityRenderer renderer) {
        this.refreshRenderer();
    }

    @Override
    public OWLObjectRenderer getOWLObjectRenderer() {
        return this.objectRenderer;
    }

    @Override
    public OWLExpressionCheckerFactory getOWLExpressionCheckerFactory() {
        return this.owlExpressionCheckerFactory;
    }

    @Override
    public OWLEntityFactory getOWLEntityFactory() {
        if (this.entityFactory == null) {
            this.entityFactory = new CustomOWLEntityFactory(this);
        }
        return this.entityFactory;
    }

    @Override
    public void setOWLEntityFactory(OWLEntityFactory owlEntityFactory) {
        this.entityFactory = owlEntityFactory;
    }

    @Override
    public OWLEntityFinder getOWLEntityFinder() {
        if (this.entityFinder == null) {
            this.entityFinder = new OWLEntityFinderImpl(this, this.owlEntityRenderingCache);
        }
        return this.entityFinder;
    }

    @Override
    public Comparator<OWLObject> getOWLObjectComparator() {
        OWLObjectRenderingComparator comparator = (OWLObjectRenderingComparator)this.get("OWL_OBJECT_COMPARATOR_KEY");
        if (comparator == null) {
            comparator = new OWLObjectRenderingComparator(this);
            this.put("OWL_OBJECT_COMPARATOR_KEY", comparator);
        }
        return comparator;
    }

    private void rebuildEntityIndices() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.owlEntityRenderingCache.rebuild();
        this.owlObjectRenderingCache.clear();
        stopwatch.stop();
        this.logger.debug("Rebuilt entity indices in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Override
    public OWLReasonerManager getOWLReasonerManager() {
        return this.owlReasonerManager;
    }

    @Override
    public OWLReasoner getReasoner() {
        return this.getOWLReasonerManager().getCurrentReasoner();
    }

    @Override
    public ReasonerPreferences getReasonerPreferences() {
        return this.getOWLReasonerManager().getReasonerPreferences();
    }

    @Override
    public void setMissingImportHandler(MissingImportHandler missingImportHandler) {
        this.userResolvedIRIMapper.setMissingImportHandler(missingImportHandler);
    }

    @Override
    public void setSaveErrorHandler(SaveErrorHandler handler) {
        this.saveErrorHandler = handler;
    }

    @Override
    public void setLoadErrorHandler(OntologyLoadErrorHandler handler) {
        this.loadErrorHandler = handler;
    }
}

