/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.annotation;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.protege.editor.owl.model.annotation.EntityCreationMetadataProvider;
import org.protege.editor.owl.model.user.UserNameProvider;
import org.protege.editor.owl.model.util.DateFormatter;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.vocab.DublinCoreVocabulary;

public class SimpleEntityCreationMetadataProvider
implements EntityCreationMetadataProvider {
    private final UserNameProvider userNameProvider;
    private final DateFormatter dateFormatter;

    public SimpleEntityCreationMetadataProvider(UserNameProvider userNameProvider, DateFormatter dateFormatter) {
        this.userNameProvider = (UserNameProvider)Preconditions.checkNotNull((Object)userNameProvider);
        this.dateFormatter = (DateFormatter)Preconditions.checkNotNull((Object)dateFormatter);
    }

    @Override
    public List<OWLOntologyChange> getEntityCreationMetadataChanges(OWLEntity entity, OWLOntology targetOntology, OWLDataFactory df) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        Optional<String> userName = this.userNameProvider.getUserName();
        Date date = new Date();
        if (userName.isPresent()) {
            changes.add((OWLOntologyChange)new AddAxiom(targetOntology, (OWLAxiom)df.getOWLAnnotationAssertionAxiom(df.getOWLAnnotationProperty(DublinCoreVocabulary.CREATOR.getIRI()), (OWLAnnotationSubject)entity.getIRI(), (OWLAnnotationValue)df.getOWLLiteral(userName.get()))));
            changes.add((OWLOntologyChange)new AddAxiom(targetOntology, (OWLAxiom)df.getOWLAnnotationAssertionAxiom(df.getOWLAnnotationProperty(DublinCoreVocabulary.DATE.getIRI()), (OWLAnnotationSubject)entity.getIRI(), (OWLAnnotationValue)df.getOWLLiteral(this.dateFormatter.formatDate(date)))));
        }
        return changes;
    }
}

