/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.axiom;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.axiom.ActiveOntologyLocationStrategy;
import org.protege.editor.owl.model.axiom.DefaultAxiomSubjectProvider;
import org.protege.editor.owl.model.axiom.DefaultSubjectDefinitionExtractor;
import org.protege.editor.owl.model.axiom.DefaultTopologicallySortedImportsClosureProvider;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationStrategy;
import org.protege.editor.owl.model.axiom.FreshAxiomLocationStrategyFactory;
import org.protege.editor.owl.model.axiom.SubjectDefinitionLocationStrategy;

public enum FreshAxiomLocation {
    ACTIVE_ONTOLOGY("ActiveOntology", new FreshAxiomLocationStrategyFactory(){

        @Override
        public FreshAxiomLocationStrategy getStrategy(OWLEditorKit editorKit) {
            return new ActiveOntologyLocationStrategy();
        }
    }),
    SUBJECT_DEFINING_ONTOLOGY("SubjectDefiningOntology", new FreshAxiomLocationStrategyFactory(){

        @Override
        public FreshAxiomLocationStrategy getStrategy(OWLEditorKit editorKit) {
            return new SubjectDefinitionLocationStrategy(new DefaultTopologicallySortedImportsClosureProvider(), new DefaultAxiomSubjectProvider(), new DefaultSubjectDefinitionExtractor());
        }
    });

    private final String locationName;
    private final FreshAxiomLocationStrategyFactory strategy;

    private FreshAxiomLocation(String locationName, FreshAxiomLocationStrategyFactory strategy) {
        this.locationName = locationName;
        this.strategy = strategy;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public static FreshAxiomLocation getDefaultValue() {
        return ACTIVE_ONTOLOGY;
    }

    public FreshAxiomLocationStrategyFactory getStrategyFactory() {
        return this.strategy;
    }

    public static Optional<FreshAxiomLocation> getLocationFromName(String name) {
        Preconditions.checkNotNull((Object)name);
        for (FreshAxiomLocation location : FreshAxiomLocation.values()) {
            if (!location.getLocationName().endsWith(name)) continue;
            return Optional.of((Object)((Object)location));
        }
        return Optional.absent();
    }
}

