/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.vocab.DublinCoreVocabulary;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SKOSVocabulary;

public class AnnotationPropertyComparator
implements Comparator<OWLAnnotationProperty> {
    private Comparator<? super OWLAnnotationProperty> delegate;
    private ImmutableList<IRI> annotationPropertyIRIOrdering;
    private static final ImmutableList<IRI> DEFAULT_ORDERING = ImmutableList.builder().add((Object[])new IRI[]{OWLRDFVocabulary.RDFS_LABEL.getIRI(), SKOSVocabulary.PREFLABEL.getIRI(), DublinCoreVocabulary.TITLE.getIRI(), IRI.create((String)"http://www.geneontology.org/formats/oboInOwl#id"), Obo2OWLConstants.Obo2OWLVocabulary.hasAlternativeId.getIRI(), Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasOboNamespace.getIRI(), Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000115.getIRI(), SKOSVocabulary.DEFINITION.getIRI(), SKOSVocabulary.NOTE.getIRI(), OWLRDFVocabulary.RDFS_COMMENT.getIRI(), SKOSVocabulary.ALTLABEL.getIRI(), OWLRDFVocabulary.RDFS_SEE_ALSO.getIRI(), OWLRDFVocabulary.RDFS_IS_DEFINED_BY.getIRI(), Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasExactSynonym.getIRI(), Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasRelatedSynonym.getIRI(), Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasBroadSynonym.getIRI(), Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasNarrowSynonym.getIRI(), Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_hasDbXref.getIRI(), Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_Subset.getIRI()}).build();

    public AnnotationPropertyComparator(ImmutableList<IRI> annotationPropertyIRIOrdering, Comparator<? super OWLAnnotationProperty> delegate) {
        this.annotationPropertyIRIOrdering = (ImmutableList)Preconditions.checkNotNull(annotationPropertyIRIOrdering);
        this.delegate = (Comparator)Preconditions.checkNotNull(delegate);
    }

    public static AnnotationPropertyComparator withDefaultOrdering(Comparator<? super OWLAnnotationProperty> delegate) {
        return new AnnotationPropertyComparator(DEFAULT_ORDERING, (Comparator)Preconditions.checkNotNull(delegate));
    }

    @Override
    public int compare(OWLAnnotationProperty o1, OWLAnnotationProperty o2) {
        int index2;
        IRI iri1 = o1.getIRI();
        IRI iri2 = o2.getIRI();
        int index1 = this.getIndex(iri1);
        int indexDiff = index1 - (index2 = this.getIndex(iri2));
        if (indexDiff != 0) {
            return indexDiff;
        }
        return this.delegate.compare((OWLAnnotationProperty)o1, (OWLAnnotationProperty)o2);
    }

    private int getIndex(IRI iri1) {
        int index = this.annotationPropertyIRIOrdering.indexOf((Object)iri1);
        if (index == -1) {
            return Integer.MAX_VALUE;
        }
        return index;
    }
}

