/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.entity;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.entity.AutoIDException;
import org.protege.editor.owl.model.entity.AutoIDGenerator;
import org.protege.editor.owl.model.entity.EntityCreationPreferences;
import org.protege.editor.owl.model.entity.LabelDescriptor;
import org.protege.editor.owl.model.entity.OWLEntityCreationException;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.entity.OWLEntityFactory;
import org.protege.editor.owl.model.entity.Revertable;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomOWLEntityFactory
implements OWLEntityFactory {
    private Logger logger = LoggerFactory.getLogger(CustomOWLEntityFactory.class);
    private OWLModelManager mngr;
    private static AutoIDGenerator autoIDGenerator;
    private LabelDescriptor labelDescriptor;

    public CustomOWLEntityFactory(OWLModelManager mngr) {
        this.mngr = mngr;
    }

    public static <T extends OWLEntity> T getOWLEntity(OWLDataFactory factory, Class<T> type, IRI iri) {
        if (OWLClass.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(factory.getOWLClass(iri)));
        }
        if (OWLObjectProperty.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(factory.getOWLObjectProperty(iri)));
        }
        if (OWLDataProperty.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(factory.getOWLDataProperty(iri)));
        }
        if (OWLNamedIndividual.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(factory.getOWLNamedIndividual(iri)));
        }
        if (OWLAnnotationProperty.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(factory.getOWLAnnotationProperty(iri)));
        }
        if (OWLDatatype.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(factory.getOWLDatatype(iri)));
        }
        throw new RuntimeException("Missing branch for entity type: " + type.getSimpleName());
    }

    @Override
    public OWLEntityCreationSet<OWLClass> createOWLClass(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLClass.class, shortName, baseIRI);
    }

    @Override
    public OWLEntityCreationSet<OWLObjectProperty> createOWLObjectProperty(String shortName, IRI baseURI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLObjectProperty.class, shortName, baseURI);
    }

    @Override
    public OWLEntityCreationSet<OWLDataProperty> createOWLDataProperty(String shortName, IRI baseURI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLDataProperty.class, shortName, baseURI);
    }

    @Override
    public OWLEntityCreationSet<OWLAnnotationProperty> createOWLAnnotationProperty(String shortName, IRI baseURI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLAnnotationProperty.class, shortName, baseURI);
    }

    @Override
    public OWLEntityCreationSet<OWLNamedIndividual> createOWLIndividual(String shortName, IRI baseURI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLNamedIndividual.class, shortName, baseURI);
    }

    @Override
    public OWLEntityCreationSet<OWLDatatype> createOWLDatatype(String shortName, IRI baseIRI) throws OWLEntityCreationException {
        return this.createOWLEntity(OWLDatatype.class, shortName, baseIRI);
    }

    @Override
    public <T extends OWLEntity> OWLEntityCreationSet<T> createOWLEntity(Class<T> type, String shortName, IRI baseURI) throws OWLEntityCreationException {
        try {
            EntityNameInfo name = this.generateName(type, shortName, baseURI);
            T entity = CustomOWLEntityFactory.getOWLEntity(this.mngr.getOWLDataFactory(), type, name.getIri());
            List<OWLOntologyChange> changes = this.getChanges(entity, name);
            return new OWLEntityCreationSet<T>(entity, changes);
        }
        catch (URISyntaxException | AutoIDException e) {
            throw new OWLEntityCreationException(e);
        }
    }

    @Override
    public <T extends OWLEntity> OWLEntityCreationSet<T> preview(Class<T> type, String shortName, IRI base) throws OWLEntityCreationException {
        if (this.getAutoIDGenerator() instanceof Revertable) {
            ((Revertable)((Object)this.getAutoIDGenerator())).checkpoint();
        }
        try {
            OWLEntityCreationSet<T> oWLEntityCreationSet = this.createOWLEntity(type, shortName, base);
            return oWLEntityCreationSet;
        }
        catch (OWLEntityCreationException e) {
            throw e;
        }
        finally {
            if (this.getAutoIDGenerator() instanceof Revertable) {
                ((Revertable)((Object)this.getAutoIDGenerator())).revert();
            }
        }
    }

    protected <T extends OWLEntity> EntityNameInfo generateName(Class<T> type, String shortName, IRI baseURI) throws AutoIDException, URISyntaxException, OWLEntityCreationException {
        IRI iri;
        if (baseURI == null) {
            baseURI = this.useDefaultBaseIRI() || this.mngr.getActiveOntology().getOntologyID().isAnonymous() ? this.getDefaultBaseIRI() : (IRI)this.mngr.getActiveOntology().getOntologyID().getOntologyIRI().get();
        }
        String id = null;
        if (this.isFragmentAutoGenerated()) {
            HashSet<IRI> tried = new HashSet<IRI>();
            do {
                if (tried.contains(iri = this.createIRI(id = this.getAutoIDGenerator().getNextID(type), baseURI))) {
                    throw new AutoIDException("Auto id generator ran out of new ids - fix this in the new entity preferences");
                }
                tried.add(iri);
            } while (this.isIRIAlreadyUsed(iri));
        } else {
            iri = this.createIRI(shortName, baseURI);
            if (this.isIRIAlreadyUsed(type, iri)) {
                throw new OWLEntityCreationException("Entity already exists: " + iri);
            }
            if (this.isGenerateIDLabel()) {
                id = this.getAutoIDGenerator().getNextID(type);
            }
        }
        return new EntityNameInfo(iri, id, shortName);
    }

    protected <T extends OWLEntity> List<OWLOntologyChange> getChanges(T entity, EntityNameInfo name) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        if (this.isGenerateIDLabel() && name.getId() != null) {
            changes.addAll(this.createLabel(entity, name.getId()));
        }
        if (this.isGenerateNameLabel() && name.getShortName() != null) {
            changes.addAll(this.createLabel(entity, name.getShortName()));
        }
        OWLDataFactory df = this.mngr.getOWLDataFactory();
        OWLDeclarationAxiom ax = df.getOWLDeclarationAxiom(entity);
        changes.add((OWLOntologyChange)new AddAxiom(this.mngr.getActiveOntology(), (OWLAxiom)ax));
        return changes;
    }

    protected IRI createIRI(String fragment, IRI baseIRI) throws URISyntaxException {
        String base;
        fragment = fragment.replace(" ", "_");
        if (baseIRI == null) {
            baseIRI = this.useDefaultBaseIRI() ? EntityCreationPreferences.getDefaultBaseIRI() : (IRI)this.mngr.getActiveOntology().getOntologyID().getOntologyIRI().get();
        }
        if (!(base = baseIRI.toString().replace(" ", "_")).endsWith("#") && !base.endsWith("/")) {
            base = base + EntityCreationPreferences.getDefaultSeparator();
        }
        return IRI.create((URI)new URI(base + fragment));
    }

    private List<? extends OWLOntologyChange> createLabel(OWLEntity owlEntity, String value) {
        LabelDescriptor descr = this.getLabelDescriptor();
        IRI iri = descr.getIRI();
        String lang = descr.getLanguage();
        OWLDataFactory df = this.mngr.getOWLDataFactory();
        OWLLiteral con = df.getOWLLiteral(value, lang);
        OWLAnnotationProperty prop = df.getOWLAnnotationProperty(iri);
        OWLAnnotationAssertionAxiom ax = df.getOWLAnnotationAssertionAxiom(prop, (OWLAnnotationSubject)owlEntity.getIRI(), (OWLAnnotationValue)con);
        return Collections.singletonList(new AddAxiom(this.mngr.getActiveOntology(), (OWLAxiom)ax));
    }

    private LabelDescriptor getLabelDescriptor() {
        Class<? extends LabelDescriptor> cls = EntityCreationPreferences.getLabelDescriptorClass();
        if (this.labelDescriptor == null || !cls.equals(this.labelDescriptor.getClass())) {
            try {
                this.labelDescriptor = cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.logger.error("Cannot create label descriptor", (Throwable)e);
            }
        }
        return this.labelDescriptor;
    }

    private AutoIDGenerator getAutoIDGenerator() {
        Class<? extends AutoIDGenerator> prefAutoIDClass = EntityCreationPreferences.getAutoIDGeneratorClass();
        if (autoIDGenerator == null || !prefAutoIDClass.equals(autoIDGenerator.getClass())) {
            try {
                autoIDGenerator = prefAutoIDClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.logger.error("Cannot create auto ID generator", (Throwable)e);
            }
        }
        return autoIDGenerator;
    }

    private <T extends OWLEntity> boolean isIRIAlreadyUsed(Class<T> type, IRI iri) {
        for (OWLOntology ont : this.mngr.getActiveOntologies()) {
            if (!(OWLClass.class.isAssignableFrom(type) && ont.containsClassInSignature(iri) || OWLObjectProperty.class.isAssignableFrom(type) && ont.containsObjectPropertyInSignature(iri) || OWLDataProperty.class.isAssignableFrom(type) && ont.containsDataPropertyInSignature(iri) || OWLIndividual.class.isAssignableFrom(type) && ont.containsIndividualInSignature(iri) || OWLAnnotationProperty.class.isAssignableFrom(type) && ont.containsAnnotationPropertyInSignature(iri)) && (!OWLDatatype.class.isAssignableFrom(type) || !ont.containsDatatypeInSignature(iri))) continue;
            return true;
        }
        return false;
    }

    private boolean isIRIAlreadyUsed(IRI iri) {
        for (OWLOntology ont : this.mngr.getOntologies()) {
            if (!ont.containsEntityInSignature(iri)) continue;
            return true;
        }
        return false;
    }

    protected boolean useDefaultBaseIRI() {
        return EntityCreationPreferences.useDefaultBaseIRI();
    }

    protected boolean isFragmentAutoGenerated() {
        return EntityCreationPreferences.isFragmentAutoGenerated();
    }

    protected boolean isGenerateNameLabel() {
        return EntityCreationPreferences.isGenerateNameLabel();
    }

    protected boolean isGenerateIDLabel() {
        return EntityCreationPreferences.isGenerateIDLabel();
    }

    protected IRI getDefaultBaseIRI() {
        return EntityCreationPreferences.getDefaultBaseIRI();
    }

    public static class EntityNameInfo {
        private IRI iri;
        private String id;
        private String shortName;

        public EntityNameInfo(IRI iri, String id, String shortName) {
            this.iri = iri;
            this.id = id;
            this.shortName = shortName;
        }

        public IRI getIri() {
            return this.iri;
        }

        public String getId() {
            return this.id;
        }

        public String getShortName() {
            return this.shortName;
        }
    }
}

