/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.find;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.protege.editor.owl.model.OWLModelManagerImpl;
import org.protege.editor.owl.model.cache.OWLEntityRenderingCache;
import org.protege.editor.owl.model.find.OWLEntityFinder;
import org.protege.editor.owl.model.find.OWLEntityFinderPreferences;
import org.protege.editor.owl.model.util.OWLDataTypeUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLEntityFinderImpl
implements OWLEntityFinder {
    private final Logger logger = LoggerFactory.getLogger(OWLEntityFinderImpl.class);
    private OWLEntityRenderingCache renderingCache;
    private OWLModelManagerImpl mngr;
    private static final String WILDCARD = "*";
    private static final String ESCAPE_CHAR = "'";

    public OWLEntityFinderImpl(OWLModelManagerImpl mngr, OWLEntityRenderingCache renderingCache) {
        this.mngr = mngr;
        this.renderingCache = renderingCache;
    }

    @Override
    public OWLClass getOWLClass(String rendering) {
        OWLClass cls = this.renderingCache.getOWLClass(rendering);
        if (cls == null && !rendering.startsWith(ESCAPE_CHAR) && !rendering.endsWith(ESCAPE_CHAR)) {
            cls = this.renderingCache.getOWLClass(ESCAPE_CHAR + rendering + ESCAPE_CHAR);
        }
        return cls;
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(String rendering) {
        OWLObjectProperty prop = this.renderingCache.getOWLObjectProperty(rendering);
        if (prop == null && !rendering.startsWith(ESCAPE_CHAR) && !rendering.endsWith(ESCAPE_CHAR)) {
            prop = this.renderingCache.getOWLObjectProperty(ESCAPE_CHAR + rendering + ESCAPE_CHAR);
        }
        return prop;
    }

    @Override
    public OWLDataProperty getOWLDataProperty(String rendering) {
        OWLDataProperty prop = this.renderingCache.getOWLDataProperty(rendering);
        if (prop == null && !rendering.startsWith(ESCAPE_CHAR) && !rendering.endsWith(ESCAPE_CHAR)) {
            prop = this.renderingCache.getOWLDataProperty(ESCAPE_CHAR + rendering + ESCAPE_CHAR);
        }
        return prop;
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(String rendering) {
        OWLAnnotationProperty prop = this.renderingCache.getOWLAnnotationProperty(rendering);
        if (prop == null && !rendering.startsWith(ESCAPE_CHAR) && !rendering.endsWith(ESCAPE_CHAR)) {
            prop = this.renderingCache.getOWLAnnotationProperty(ESCAPE_CHAR + rendering + ESCAPE_CHAR);
        }
        return prop;
    }

    @Override
    public OWLNamedIndividual getOWLIndividual(String rendering) {
        OWLNamedIndividual individual = this.renderingCache.getOWLIndividual(rendering);
        if (individual == null && !rendering.startsWith(ESCAPE_CHAR) && !rendering.endsWith(ESCAPE_CHAR)) {
            individual = this.renderingCache.getOWLIndividual(ESCAPE_CHAR + rendering + ESCAPE_CHAR);
        }
        return individual;
    }

    @Override
    public OWLDatatype getOWLDatatype(String rendering) {
        OWLDatatype dataType = this.renderingCache.getOWLDatatype(rendering);
        if (dataType == null && !rendering.startsWith(ESCAPE_CHAR) && !rendering.endsWith(ESCAPE_CHAR)) {
            dataType = this.renderingCache.getOWLDatatype(ESCAPE_CHAR + rendering + ESCAPE_CHAR);
        }
        return dataType;
    }

    @Override
    public OWLEntity getOWLEntity(String rendering) {
        OWLEntity entity = this.renderingCache.getOWLEntity(rendering);
        if (entity == null && !rendering.startsWith(ESCAPE_CHAR) && !rendering.endsWith(ESCAPE_CHAR)) {
            entity = this.renderingCache.getOWLEntity(ESCAPE_CHAR + rendering + ESCAPE_CHAR);
        }
        return entity;
    }

    @Override
    public Set<String> getOWLEntityRenderings() {
        return this.renderingCache.getOWLEntityRenderings();
    }

    @Override
    public Set<OWLClass> getMatchingOWLClasses(String match) {
        return this.getEntities(match, OWLClass.class, OWLEntityFinderPreferences.getInstance().isUseRegularExpressions());
    }

    @Override
    public Set<OWLClass> getMatchingOWLClasses(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLClass.class, fullRegExp);
    }

    @Override
    public Set<OWLClass> getMatchingOWLClasses(String match, boolean fullRegExp, int flags) {
        return this.getEntities(match, OWLClass.class, fullRegExp, flags);
    }

    @Override
    public Set<OWLObjectProperty> getMatchingOWLObjectProperties(String match) {
        return this.getEntities(match, OWLObjectProperty.class, OWLEntityFinderPreferences.getInstance().isUseRegularExpressions());
    }

    @Override
    public Set<OWLObjectProperty> getMatchingOWLObjectProperties(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLObjectProperty.class, fullRegExp);
    }

    @Override
    public Set<OWLObjectProperty> getMatchingOWLObjectProperties(String match, boolean fullRegExp, int flags) {
        return this.getEntities(match, OWLObjectProperty.class, fullRegExp, flags);
    }

    @Override
    public Set<OWLDataProperty> getMatchingOWLDataProperties(String match) {
        return this.getEntities(match, OWLDataProperty.class, OWLEntityFinderPreferences.getInstance().isUseRegularExpressions());
    }

    @Override
    public Set<OWLDataProperty> getMatchingOWLDataProperties(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLDataProperty.class, fullRegExp);
    }

    @Override
    public Set<OWLDataProperty> getMatchingOWLDataProperties(String match, boolean fullRegExp, int flags) {
        return this.getEntities(match, OWLDataProperty.class, fullRegExp, flags);
    }

    @Override
    public Set<OWLNamedIndividual> getMatchingOWLIndividuals(String match) {
        return this.getEntities(match, OWLNamedIndividual.class, OWLEntityFinderPreferences.getInstance().isUseRegularExpressions());
    }

    @Override
    public Set<OWLNamedIndividual> getMatchingOWLIndividuals(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLNamedIndividual.class, fullRegExp);
    }

    @Override
    public Set<OWLNamedIndividual> getMatchingOWLIndividuals(String match, boolean fullRegExp, int flags) {
        return this.getEntities(match, OWLNamedIndividual.class, fullRegExp, flags);
    }

    @Override
    public Set<OWLDatatype> getMatchingOWLDatatypes(String match) {
        return this.getEntities(match, OWLDatatype.class, OWLEntityFinderPreferences.getInstance().isUseRegularExpressions());
    }

    @Override
    public Set<OWLDatatype> getMatchingOWLDatatypes(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLDatatype.class, fullRegExp);
    }

    @Override
    public Set<OWLDatatype> getMatchingOWLDatatypes(String match, boolean fullRegExp, int flags) {
        return this.getEntities(match, OWLDatatype.class, fullRegExp, flags);
    }

    @Override
    public Set<OWLAnnotationProperty> getMatchingOWLAnnotationProperties(String match) {
        return this.getEntities(match, OWLAnnotationProperty.class, OWLEntityFinderPreferences.getInstance().isUseRegularExpressions());
    }

    @Override
    public Set<OWLAnnotationProperty> getMatchingOWLAnnotationProperties(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLAnnotationProperty.class, fullRegExp);
    }

    @Override
    public Set<OWLAnnotationProperty> getMatchingOWLAnnotationProperties(String match, boolean fullRegExp, int flags) {
        return this.getEntities(match, OWLAnnotationProperty.class, fullRegExp, flags);
    }

    @Override
    public Set<OWLEntity> getMatchingOWLEntities(String match) {
        return this.getEntities(match, OWLEntity.class, OWLEntityFinderPreferences.getInstance().isUseRegularExpressions());
    }

    @Override
    public Set<OWLEntity> getMatchingOWLEntities(String match, boolean fullRegExp) {
        return this.getEntities(match, OWLEntity.class, fullRegExp);
    }

    @Override
    public Set<OWLEntity> getMatchingOWLEntities(String match, boolean fullRegExp, int flags) {
        return this.getEntities(match, OWLEntity.class, fullRegExp, flags);
    }

    @Override
    public Set<OWLEntity> getEntities(IRI iri) {
        HashSet<OWLEntity> entities = new HashSet<OWLEntity>();
        for (OWLOntology ont : this.mngr.getActiveOntologies()) {
            if (ont.containsClassInSignature(iri)) {
                entities.add((OWLEntity)this.mngr.getOWLDataFactory().getOWLClass(iri));
            }
            if (ont.containsObjectPropertyInSignature(iri)) {
                entities.add((OWLEntity)this.mngr.getOWLDataFactory().getOWLObjectProperty(iri));
            }
            if (ont.containsDataPropertyInSignature(iri)) {
                entities.add((OWLEntity)this.mngr.getOWLDataFactory().getOWLDataProperty(iri));
            }
            if (ont.containsIndividualInSignature(iri)) {
                entities.add((OWLEntity)this.mngr.getOWLDataFactory().getOWLNamedIndividual(iri));
            }
            if (ont.containsAnnotationPropertyInSignature(iri)) {
                entities.add((OWLEntity)this.mngr.getOWLDataFactory().getOWLAnnotationProperty(iri));
            }
            if (!ont.containsDatatypeInSignature(iri)) continue;
            entities.add((OWLEntity)this.mngr.getOWLDataFactory().getOWLDatatype(iri));
        }
        return entities;
    }

    private <T extends OWLEntity> Set<T> getEntities(String match, Class<T> type, boolean fullRegExp) {
        return this.getEntities(match, type, fullRegExp, 2);
    }

    private <T extends OWLEntity> Set<T> getEntities(String match, Class<T> type, boolean fullRegExp, int flags) {
        if (match.length() == 0) {
            return Collections.emptySet();
        }
        if (fullRegExp) {
            return this.doRegExpSearch(match, type, flags);
        }
        return this.doWildcardSearch(match, type);
    }

    private <T extends OWLEntity> Set<T> doRegExpSearch(String match, Class<T> type, int flags) {
        HashSet<T> results = new HashSet<T>();
        try {
            Pattern pattern = Pattern.compile(match, flags);
            for (String rendering : this.getRenderings(type)) {
                T ent;
                Matcher m = pattern.matcher(rendering);
                if (!m.find() || (ent = this.getEntity(rendering, type)) == null) continue;
                results.add(ent);
            }
        }
        catch (PatternSyntaxException e) {
            this.logger.warn("Invalid regular expression: " + e.getMessage());
        }
        return results;
    }

    private <T extends OWLEntity> Set<T> doWildcardSearch(String match, Class<T> type) {
        Set<Object> results = new HashSet();
        if (match.equals(WILDCARD)) {
            results = this.getAllEntities(type);
        } else {
            SimpleWildCardMatcher matcher;
            if (match.startsWith(WILDCARD)) {
                if (match.length() > 1 && match.endsWith(WILDCARD)) {
                    matcher = new SimpleWildCardMatcher(){

                        @Override
                        public boolean matches(String rendering, String s) {
                            return rendering.indexOf(s) != -1;
                        }
                    };
                    match = match.substring(1, match.length() - 1);
                } else {
                    matcher = new SimpleWildCardMatcher(){

                        @Override
                        public boolean matches(String rendering, String s) {
                            return rendering.indexOf(s) != -1;
                        }
                    };
                    match = match.substring(1, match.length());
                }
            } else {
                if (match.endsWith(WILDCARD) && match.length() > 1) {
                    match = match.substring(0, match.length() - 1);
                }
                matcher = new SimpleWildCardMatcher(){

                    @Override
                    public boolean matches(String rendering, String s) {
                        return rendering.startsWith(s) || rendering.startsWith(OWLEntityFinderImpl.ESCAPE_CHAR + s);
                    }
                };
            }
            if (match.trim().length() == 0) {
                this.logger.debug("Attempt to match the empty string (no results)");
            } else {
                match = match.toLowerCase();
                this.logger.debug("Match: " + match);
                for (String rendering : this.getRenderings(type)) {
                    if (rendering.length() <= 0 || !matcher.matches(rendering.toLowerCase(), match)) continue;
                    results.add(this.getEntity(rendering, type));
                }
            }
        }
        return results;
    }

    private <T extends OWLEntity> Set<T> getAllEntities(Class<T> type) {
        if (type.equals(OWLDatatype.class)) {
            return new OWLDataTypeUtils(this.mngr.getOWLOntologyManager()).getKnownDatatypes(this.mngr.getActiveOntologies());
        }
        HashSet entities = new HashSet();
        for (OWLOntology ont : this.mngr.getActiveOntologies()) {
            if (type.equals(OWLClass.class)) {
                entities.addAll(ont.getClassesInSignature());
                continue;
            }
            if (type.equals(OWLObjectProperty.class)) {
                entities.addAll(ont.getObjectPropertiesInSignature());
                continue;
            }
            if (type.equals(OWLDataProperty.class)) {
                entities.addAll(ont.getDataPropertiesInSignature());
                continue;
            }
            if (type.equals(OWLIndividual.class)) {
                entities.addAll(ont.getIndividualsInSignature());
                continue;
            }
            if (type.equals(OWLAnnotationProperty.class)) {
                entities.addAll(ont.getAnnotationPropertiesInSignature());
                continue;
            }
            if (!type.equals(OWLDatatype.class)) continue;
            entities.addAll(ont.getDatatypesInSignature());
        }
        return entities;
    }

    private <T extends OWLEntity> T getEntity(String rendering, Class<T> type) {
        if (OWLClass.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(this.renderingCache.getOWLClass(rendering)));
        }
        if (OWLObjectProperty.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(this.renderingCache.getOWLObjectProperty(rendering)));
        }
        if (OWLDataProperty.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(this.renderingCache.getOWLDataProperty(rendering)));
        }
        if (OWLNamedIndividual.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(this.renderingCache.getOWLIndividual(rendering)));
        }
        if (OWLAnnotationProperty.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(this.renderingCache.getOWLAnnotationProperty(rendering)));
        }
        if (OWLDatatype.class.isAssignableFrom(type)) {
            return (T)((OWLEntity)type.cast(this.renderingCache.getOWLDatatype(rendering)));
        }
        return (T)((OWLEntity)type.cast(this.renderingCache.getOWLEntity(rendering)));
    }

    private <T extends OWLEntity> Set<String> getRenderings(Class<T> type) {
        if (OWLClass.class.isAssignableFrom(type)) {
            return this.renderingCache.getOWLClassRenderings();
        }
        if (OWLObjectProperty.class.isAssignableFrom(type)) {
            return this.renderingCache.getOWLObjectPropertyRenderings();
        }
        if (OWLDataProperty.class.isAssignableFrom(type)) {
            return this.renderingCache.getOWLDataPropertyRenderings();
        }
        if (OWLNamedIndividual.class.isAssignableFrom(type)) {
            return this.renderingCache.getOWLIndividualRenderings();
        }
        if (OWLAnnotationProperty.class.isAssignableFrom(type)) {
            return this.renderingCache.getOWLAnnotationPropertyRenderings();
        }
        if (OWLDatatype.class.isAssignableFrom(type)) {
            return this.renderingCache.getOWLDatatypeRenderings();
        }
        return this.renderingCache.getOWLEntityRenderings();
    }

    private static interface SimpleWildCardMatcher {
        public boolean matches(String var1, String var2);
    }
}

