/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProviderListener;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOWLObjectHierarchyProvider<N extends OWLObject>
implements OWLObjectHierarchyProvider<N> {
    private final Logger logger = LoggerFactory.getLogger(AbstractOWLObjectHierarchyProvider.class);
    private volatile boolean fireEvents;
    private List<OWLObjectHierarchyProviderListener<N>> listeners;
    private OWLOntologyManager manager;
    private Predicate<N> filter = n -> true;

    protected AbstractOWLObjectHierarchyProvider(OWLOntologyManager owlOntologyManager) {
        this.manager = owlOntologyManager;
        this.listeners = new ArrayList<OWLObjectHierarchyProviderListener<N>>();
        this.fireEvents = true;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    @Override
    public void setFilter(Predicate<N> filter) {
        this.filter = (Predicate)Preconditions.checkNotNull(filter);
        this.fireHierarchyChanged();
    }

    @Override
    public void clearFilter() {
        this.filter = n -> true;
        this.fireHierarchyChanged();
    }

    @Override
    public Predicate<N> getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<OWLObjectHierarchyProviderListener<N>> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
        }
    }

    @Override
    public Set<N> getAncestors(N object) {
        HashSet results = new HashSet();
        this.getAncestors(results, object);
        return results;
    }

    private void getAncestors(Set<N> results, N object) {
        for (OWLObject parent : this.getParents(object)) {
            if (results.contains(parent)) continue;
            results.add(parent);
            this.getAncestors(results, parent);
        }
    }

    @Override
    public Set<N> getChildren(N object) {
        return this.getUnfilteredChildren(object).stream().filter(this.filter).collect(Collectors.toSet());
    }

    protected Set<N> getUnfilteredChildren(N object) {
        return Collections.emptySet();
    }

    @Override
    public Set<N> getDescendants(N object) {
        HashSet results = new HashSet();
        this.getDescendants(results, object);
        return results;
    }

    private void getDescendants(Set<N> results, N object) {
        for (OWLObject child : this.getChildren(object)) {
            if (results.contains(child)) continue;
            results.add(child);
            this.getDescendants(results, child);
        }
    }

    @Override
    public Set<List<N>> getPathsToRoot(N obj) {
        return this.setOfPaths(obj, new HashSet());
    }

    private Set<List<N>> setOfPaths(N obj, Set<N> processed) {
        if (this.getRoots().contains(obj)) {
            return this.getSingleSetOfLists(obj);
        }
        HashSet<List<N>> paths = new HashSet<List<N>>();
        for (OWLObject par : this.getParents(obj)) {
            if (processed.contains(par)) continue;
            processed.add(par);
            paths.addAll(this.append(obj, this.setOfPaths(par, processed)));
        }
        return paths;
    }

    private Set<List<N>> getSingleSetOfLists(N obj) {
        HashSet<List<N>> set = new HashSet<List<N>>();
        ArrayList<N> list = new ArrayList<N>();
        list.add(obj);
        set.add(list);
        return set;
    }

    private Set<List<N>> append(N obj, Set<List<N>> setOfPaths) {
        for (List<N> path : setOfPaths) {
            path.add(obj);
        }
        return setOfPaths;
    }

    protected void setFireEvents(boolean b) {
        this.fireEvents = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(OWLObjectHierarchyProviderListener<N> listener) {
        List<OWLObjectHierarchyProviderListener<N>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(OWLObjectHierarchyProviderListener<N> listener) {
        List<OWLObjectHierarchyProviderListener<N>> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OWLObjectHierarchyProviderListener<N>> getListeners() {
        List<OWLObjectHierarchyProviderListener<N>> list = this.listeners;
        synchronized (list) {
            return new ArrayList<OWLObjectHierarchyProviderListener<N>>(this.listeners);
        }
    }

    protected void fireNodeChanged(N node) {
        if (!this.fireEvents) {
            return;
        }
        for (OWLObjectHierarchyProviderListener<N> listener : this.getListeners()) {
            try {
                listener.nodeChanged(node);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.logger.error("{}: Listener {} has thrown an exception.  Removing bad listener.", (Object)this.getClass().getName(), listener);
                this.removeListener(listener);
                throw new RuntimeException(e);
            }
        }
    }

    protected void fireHierarchyChanged() {
        if (!this.fireEvents) {
            return;
        }
        for (OWLObjectHierarchyProviderListener<N> listener : this.getListeners()) {
            try {
                listener.hierarchyChanged();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

