/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.hierarchy.AssertedClassHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.IndividualsByTypeHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLAnnotationPropertyHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLDataPropertyHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLHierarchyManager;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLObjectPropertyHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.cls.InferredOWLClassHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.property.InferredObjectPropertyHierarchyProvider;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;

public class OWLHierarchyManagerImpl
implements OWLHierarchyManager {
    private OWLObjectHierarchyProvider<OWLClass> assertedClassHierarchyProvider;
    private InferredOWLClassHierarchyProvider inferredClassHierarchyProvider;
    private OWLObjectHierarchyProvider<OWLObjectProperty> assertedObjectPropertyHierarchyProvider;
    private OWLObjectHierarchyProvider<OWLObjectProperty> inferredObjectPropertyHierarchyProvider;
    private OWLObjectHierarchyProvider<OWLDataProperty> assertedDataPropertyHierarchyProvider;
    private OWLAnnotationPropertyHierarchyProvider assertedAnnotationPropertyHierarchyProvider;
    private IndividualsByTypeHierarchyProvider individualsByTypeHierarchyProvider;
    private OWLModelManager mngr;
    private OWLModelManagerListener listener = new OWLModelManagerListener(){

        @Override
        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || event.isType(EventType.ONTOLOGY_RELOADED)) {
                OWLHierarchyManagerImpl.this.rebuildAsNecessary();
            }
        }
    };

    public OWLHierarchyManagerImpl(OWLModelManager mngr) {
        this.mngr = mngr;
        mngr.addListener(this.listener);
    }

    @Override
    public OWLObjectHierarchyProvider<OWLClass> getOWLClassHierarchyProvider() {
        if (this.assertedClassHierarchyProvider == null) {
            this.assertedClassHierarchyProvider = new AssertedClassHierarchyProvider(this.mngr.getOWLOntologyManager());
            this.assertedClassHierarchyProvider.setOntologies(this.mngr.getActiveOntologies());
        }
        return this.assertedClassHierarchyProvider;
    }

    @Override
    public OWLObjectHierarchyProvider<OWLClass> getInferredOWLClassHierarchyProvider() {
        if (this.inferredClassHierarchyProvider == null) {
            this.inferredClassHierarchyProvider = new InferredOWLClassHierarchyProvider(this.mngr, this.mngr.getOWLOntologyManager());
        }
        return this.inferredClassHierarchyProvider;
    }

    @Override
    public OWLObjectHierarchyProvider<OWLObjectProperty> getOWLObjectPropertyHierarchyProvider() {
        if (this.assertedObjectPropertyHierarchyProvider == null) {
            this.assertedObjectPropertyHierarchyProvider = new OWLObjectPropertyHierarchyProvider(this.mngr.getOWLOntologyManager());
            this.assertedObjectPropertyHierarchyProvider.setOntologies(this.mngr.getActiveOntologies());
        }
        return this.assertedObjectPropertyHierarchyProvider;
    }

    @Override
    public OWLObjectHierarchyProvider<OWLDataProperty> getOWLDataPropertyHierarchyProvider() {
        if (this.assertedDataPropertyHierarchyProvider == null) {
            this.assertedDataPropertyHierarchyProvider = new OWLDataPropertyHierarchyProvider(this.mngr.getOWLOntologyManager());
            this.assertedDataPropertyHierarchyProvider.setOntologies(this.mngr.getActiveOntologies());
        }
        return this.assertedDataPropertyHierarchyProvider;
    }

    @Override
    public OWLAnnotationPropertyHierarchyProvider getOWLAnnotationPropertyHierarchyProvider() {
        if (this.assertedAnnotationPropertyHierarchyProvider == null) {
            this.assertedAnnotationPropertyHierarchyProvider = new OWLAnnotationPropertyHierarchyProvider(this.mngr.getOWLOntologyManager());
            this.assertedAnnotationPropertyHierarchyProvider.setOntologies(this.mngr.getOntologies());
        }
        return this.assertedAnnotationPropertyHierarchyProvider;
    }

    @Override
    public IndividualsByTypeHierarchyProvider getOWLIndividualsByTypeHierarchyProvider() {
        if (this.individualsByTypeHierarchyProvider == null) {
            this.individualsByTypeHierarchyProvider = new IndividualsByTypeHierarchyProvider(this.mngr.getOWLOntologyManager());
            this.individualsByTypeHierarchyProvider.setOntologies(this.mngr.getActiveOntologies());
        }
        return this.individualsByTypeHierarchyProvider;
    }

    @Override
    public OWLObjectHierarchyProvider<OWLObjectProperty> getInferredOWLObjectPropertyHierarchyProvider() {
        if (this.inferredObjectPropertyHierarchyProvider == null) {
            this.inferredObjectPropertyHierarchyProvider = new InferredObjectPropertyHierarchyProvider(this.mngr);
            this.inferredObjectPropertyHierarchyProvider.setOntologies(this.mngr.getActiveOntologies());
        }
        return this.inferredObjectPropertyHierarchyProvider;
    }

    public void dispose() throws Exception {
        this.mngr.removeListener(this.listener);
        if (this.assertedClassHierarchyProvider != null) {
            this.assertedClassHierarchyProvider.dispose();
        }
        if (this.inferredClassHierarchyProvider != null) {
            this.inferredClassHierarchyProvider.dispose();
        }
        if (this.assertedObjectPropertyHierarchyProvider != null) {
            this.assertedObjectPropertyHierarchyProvider.dispose();
        }
        if (this.inferredObjectPropertyHierarchyProvider != null) {
            this.inferredObjectPropertyHierarchyProvider.dispose();
        }
        if (this.assertedDataPropertyHierarchyProvider != null) {
            this.assertedDataPropertyHierarchyProvider.dispose();
        }
        if (this.individualsByTypeHierarchyProvider != null) {
            this.individualsByTypeHierarchyProvider.dispose();
        }
    }

    private void rebuildAsNecessary() {
        Set<OWLOntology> ontologies = this.mngr.getActiveOntologies();
        if (this.assertedClassHierarchyProvider != null) {
            this.getOWLClassHierarchyProvider().setOntologies(ontologies);
        }
        if (this.assertedObjectPropertyHierarchyProvider != null) {
            this.getOWLObjectPropertyHierarchyProvider().setOntologies(ontologies);
        }
        if (this.assertedDataPropertyHierarchyProvider != null) {
            this.getOWLDataPropertyHierarchyProvider().setOntologies(ontologies);
        }
        if (this.individualsByTypeHierarchyProvider != null) {
            this.getOWLIndividualsByTypeHierarchyProvider().setOntologies(ontologies);
        }
        if (this.assertedAnnotationPropertyHierarchyProvider != null) {
            this.getOWLAnnotationPropertyHierarchyProvider().setOntologies(ontologies);
        }
    }
}

