/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.cls;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class InferredOWLClassHierarchyProvider
extends AbstractOWLObjectHierarchyProvider<OWLClass> {
    private final OWLModelManager owlModelManager;
    private final OWLClass owlThing;
    private final OWLClass owlNothing;
    private OWLModelManagerListener owlModelManagerListener = new OWLModelManagerListener(){

        @Override
        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.isType(EventType.REASONER_CHANGED) || event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || event.isType(EventType.ONTOLOGY_CLASSIFIED) || event.isType(EventType.ONTOLOGY_RELOADED)) {
                InferredOWLClassHierarchyProvider.this.fireHierarchyChanged();
            }
        }
    };

    public InferredOWLClassHierarchyProvider(OWLModelManager owlModelManager, OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
        this.owlModelManager = owlModelManager;
        this.owlThing = owlModelManager.getOWLDataFactory().getOWLThing();
        this.owlNothing = owlModelManager.getOWLDataFactory().getOWLNothing();
        owlModelManager.addListener(this.owlModelManagerListener);
    }

    public void rebuild() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.owlModelManager.removeListener(this.owlModelManagerListener);
    }

    @Override
    public Set<OWLClass> getRoots() {
        return Collections.singleton(this.owlThing);
    }

    protected OWLReasoner getReasoner() {
        return this.owlModelManager.getOWLReasonerManager().getCurrentReasoner();
    }

    @Override
    public Set<OWLClass> getUnfilteredChildren(OWLClass object) {
        if (!this.getReasoner().isConsistent()) {
            return Collections.emptySet();
        }
        Set subs = this.getReasoner().getSubClasses((OWLClassExpression)object, true).getFlattened();
        if (object.isOWLThing() && !this.owlModelManager.getReasoner().getUnsatisfiableClasses().isSingleton()) {
            subs.add(this.owlNothing);
        } else if (object.isOWLNothing()) {
            subs.addAll(this.getReasoner().getUnsatisfiableClasses().getEntities());
            subs.remove(this.owlNothing);
        } else {
            subs.remove(this.owlNothing);
            Iterator it = subs.iterator();
            while (it.hasNext()) {
                if (this.getReasoner().isSatisfiable((OWLClassExpression)it.next())) continue;
                it.remove();
            }
        }
        return subs;
    }

    @Override
    public Set<OWLClass> getDescendants(OWLClass object) {
        if (!this.getReasoner().isConsistent()) {
            return Collections.emptySet();
        }
        return this.getReasoner().getSubClasses((OWLClassExpression)object, false).getFlattened();
    }

    @Override
    public Set<OWLClass> getParents(OWLClass object) {
        if (!this.getReasoner().isConsistent()) {
            return Collections.emptySet();
        }
        if (object.isOWLNothing()) {
            return Collections.singleton(this.owlThing);
        }
        if (!this.getReasoner().isSatisfiable((OWLClassExpression)object)) {
            return Collections.singleton(this.owlNothing);
        }
        Set parents = this.getReasoner().getSuperClasses((OWLClassExpression)object, true).getFlattened();
        parents.remove(object);
        return parents;
    }

    @Override
    public Set<OWLClass> getAncestors(OWLClass object) {
        if (!this.getReasoner().isConsistent()) {
            return Collections.emptySet();
        }
        return this.getReasoner().getSuperClasses((OWLClassExpression)object, false).getFlattened();
    }

    @Override
    public Set<OWLClass> getEquivalents(OWLClass object) {
        if (!this.getReasoner().isConsistent()) {
            return Collections.emptySet();
        }
        if (!this.getReasoner().isSatisfiable((OWLClassExpression)object)) {
            return Collections.emptySet();
        }
        Set equivalents = this.getReasoner().getEquivalentClasses((OWLClassExpression)object).getEntities();
        equivalents.remove(object);
        return equivalents;
    }

    @Override
    public boolean containsReference(OWLClass object) {
        return false;
    }

    protected void addRoot(OWLClass object) {
    }

    protected void removeRoot(OWLClass object) {
    }

    protected Set<OWLClass> getOrphanRoots(OWLClass object) {
        return Collections.emptySet();
    }

    @Override
    public void setOntologies(Set<OWLOntology> ontologies) {
    }
}

